include SPI.h
#include Adafruit_GFX.h
#include Max72xxPanel.h

int pinCS = 10; // Attach CS to this pin, DIN to MOSI and CLK to SCK (cf http://arduino•cc/en/Reference/SPI )
int numberOfHorizontalDisplays = 1;
int numberOfVerticalDisplays = 4;

Max72xxPanel matrix = Max72xxPanel(pinCS, numberOfHorizontalDisplays, numberOfVerticalDisplays);

String tape = "Ayo belajar Arduino bersama DA Electronics";
int wait = 50; // In milliseconds

int spacer = 1;
int width = 5 + spacer; // The font width is 5 pixels

void setup() {

matrix.setIntensity(7); // Use a value between 0 and 15 for brightness

// Adjust to your own needs
matrix.setRotation(matrix.getRotation() + 1 ); // The first display is position upside down
// matrix.setRotation(1, 1); // The first display is position upside down
}

void loop() {

for ( int i = 0 ; i < width * tape.length() + matrix.width() - 1 - spacer; i++ ) {

matrix.fillScreen(LOW);

int letter = i / width;
int x = (matrix.width() - 1) - i % width;
int y = (matrix.height() - 8) / 2; // center the text vertically

while ( x + width - spacer >= 0 && letter >= 0 ) {
if ( letter < tape.length() ) {
matrix.drawChar(x, y, tape[letter], HIGH, LOW, 1);
}

letter--;
x -= width;
}

matrix.write(); // Send bitmap to display

delay(wait);
}
} 
