/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import ancestris.util.swing.DialogManager;
import genj.edit.beans.CCPMenu;
import genj.edit.beans.PropertyBean;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.util.GridBagHelper;
import genj.util.swing.ImageIcon;
import genj.util.swing.TextFieldWidget;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.net.URI;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class SimpleValueBean
extends PropertyBean {
    private final GridBagHelper gh = new GridBagHelper((Container)this);
    private JButton webLink = new JButton((Icon)new ImageIcon(MetaProperty.class, "images/Web"));
    private TextFieldWidget tfield = new TextFieldWidget("", 8);
    private JLabel tfieldRO;

    public SimpleValueBean() {
        this.tfield.setComponentPopupMenu((JPopupMenu)new CCPMenu((JTextComponent)this.tfield));
        this.tfieldRO = new JLabel("");
        this.tfield.addChangeListener((ChangeListener)this.changeSupport);
        this.webLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String link = SimpleValueBean.this.property.getDisplayValue().replaceAll(" ", "%20");
                try {
                    URI uri = new URI(link);
                    Desktop.getDesktop().browse(uri);
                }
                catch (Exception ex) {
                    DialogManager.createError((String)PropertyBean.RESOURCES.getString("link.error"), (String)link).show();
                    PropertyBean.LOG.severe("Error accessing link. Exception=" + ex.getLocalizedMessage());
                }
            }
        });
    }

    @Override
    protected void commitImpl(Property property) {
        if (!property.isReadOnly()) {
            property.setGuessed(false);
            property.setValue(this.tfield.getText());
            this.setPropertyImpl(property);
        }
    }

    @Override
    public boolean isEditable() {
        return this.tfield.isEditable();
    }

    @Override
    public void setPropertyImpl(Property property) {
        this.removeAll();
        if (property == null) {
            this.tfield.setText("");
            this.tfield.setEditable(true);
            this.tfield.setVisible(true);
            this.gh.add((Component)this.tfield, 0, 0, 1, 1, 1);
        } else {
            String txt = property.getDisplayValue();
            if (property.isReadOnly()) {
                this.tfieldRO.setText(txt);
                this.tfieldRO.setVisible(txt.length() > 0);
                this.defaultFocus = null;
                this.gh.add((Component)this.tfieldRO, 0, 0, 1, 1, 1);
            } else {
                this.tfield.setText(txt);
                this.tfield.setEditable(true);
                this.tfield.setVisible(true);
                this.gh.add((Component)this.tfield, 0, 0, 1, 1, 1);
            }
            if (txt.startsWith("http://") || txt.startsWith("https://")) {
                this.gh.add((Component)this.webLink, 1, 0, 1, 1, 1);
            }
        }
        this.gh.addFiller(0, 1);
        this.changeSupport.setChanged(false);
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        this.tfield.addKeyListener(l);
    }

    public String getValue() {
        return this.tfield.getText();
    }
}

