/*
 * Decompiled with CFR 0.152.
 */
package genj.search;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.search.Hit;
import genj.search.Matcher;
import genj.search.Worker;
import genj.search.WorkerListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorkerTag
extends Worker {
    private List<String> tags;

    public WorkerTag(WorkerListener listener) {
        super(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Gedcom gedcom, int max_hits, boolean case_sensitive, Object ... args) {
        String localTags = (String)args[0];
        String value = (String)args[1];
        Boolean regexp = (Boolean)args[2];
        AtomicBoolean atomicBoolean = this.lock;
        synchronized (atomicBoolean) {
            if (this.thread != null) {
                throw new IllegalStateException("can't start while running");
            }
            this.gedcom = gedcom;
            this.max_hits = max_hits;
            this.case_sensitive = case_sensitive;
            this.matcher = this.getMatcher(value, regexp);
            this.tags = this.split(localTags);
            this.hits.clear();
            this.entities.clear();
            this.hitCount = 0;
            this.lock.set(true);
            this.thread = new Thread(() -> {
                try {
                    this.listener.started();
                    this.search(this.gedcom);
                    this.flush();
                }
                catch (Throwable t) {
                    Logger.getLogger("ancestris.search").log(Level.FINE, "worker bailed", t);
                }
                finally {
                    AtomicBoolean atomicBoolean = this.lock;
                    synchronized (atomicBoolean) {
                        this.thread = null;
                        this.lock.set(false);
                        this.lock.notifyAll();
                    }
                    try {
                        this.listener.stopped();
                    }
                    catch (Throwable throwable) {}
                }
            });
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    private List<String> split(String tags) {
        String[] ss = tags.split(",|\\s");
        ArrayList<String> result = new ArrayList<String>(ss.length);
        for (String s : ss) {
            if ((s = s.trim()).length() <= 0 || result.contains(s)) continue;
            result.add(s);
        }
        return result;
    }

    private boolean checkPath(Entity entity, Property prop) {
        if (this.tags.isEmpty()) {
            return true;
        }
        TagPath path = prop.getPath();
        for (String tag : this.tags) {
            if (path.contains(tag)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void search(Entity entity, Property prop) {
        if (this.checkPath(entity, prop) && !prop.isTransient()) {
            this.search(entity, prop, prop.getDisplayValue(), false);
        }
        int n = prop.getNoOfProperties();
        for (int i = 0; i < n; ++i) {
            this.search(entity, prop.getProperty(i));
        }
    }

    private void search(Entity entity, Property prop, String value, boolean isID) {
        Matcher.Match[] matches = this.matcher.match(value);
        if (matches.length == 0) {
            return;
        }
        if (this.hitCount >= this.max_hits) {
            return;
        }
        this.entities.add(entity);
        Hit hit = new Hit(prop, value, matches, this.entities.size(), isID);
        this.hits.add(hit);
        ++this.hitCount;
        long now = System.currentTimeMillis();
        if (now - this.lastFlush > 500L) {
            this.flush();
        }
        this.lastFlush = now;
    }
}

