/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.matchers;

import ancestris.modules.gedcom.matchers.MatcherOptions;
import ancestris.modules.gedcom.matchers.Options;
import ancestris.modules.gedcom.matchers.PotentialMatch;
import genj.gedcom.Entity;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;

public abstract class EntityMatcher<E extends Entity, O extends MatcherOptions>
implements Comparator<E>,
Options<O> {
    private static final Logger log = Logger.getLogger(EntityMatcher.class.getName());
    protected O options = null;

    public List<PotentialMatch<E>> getPotentialMatches(List<E> entities, ProgressHandle progressHandle, int counter) throws InterruptedException {
        ArrayList<PotentialMatch<E>> matches = new ArrayList<PotentialMatch<E>>();
        HashMap<String, List<String>> compareDone = new HashMap<String, List<String>>();
        Map<String, List<E>> sortedEntities = this.sort(entities);
        log.log(Level.FINE, "sorted entities {0} ...", sortedEntities.size());
        block0: for (String key : sortedEntities.keySet()) {
            List<E> entityList = sortedEntities.get(key);
            log.log(Level.FINE, "entities to compare {0} ...", entityList.size());
            if (entityList.size() <= 1) continue;
            for (Entity leftEntity : entityList) {
                progressHandle.progress("Recherche de doublons (" + matches.size() + " doublons trouv\u00e9s)", counter++);
                this.getDuplicates(compareDone, leftEntity, entityList, matches);
                Thread.sleep(0L);
                if (matches.size() < 1000) continue;
                continue block0;
            }
        }
        log.log(Level.FINE, "Potential matches: {0}", matches.size());
        return matches;
    }

    public List<PotentialMatch<E>> getDuplicates(E leftEntity, List<E> entityList) {
        ArrayList<PotentialMatch<E>> matches = new ArrayList<PotentialMatch<E>>();
        HashMap<String, List<String>> compareDone = new HashMap<String, List<String>>();
        this.getDuplicates(compareDone, leftEntity, entityList, matches);
        return matches;
    }

    private void getDuplicates(Map<String, List<String>> compareDone, E leftEntity, List<E> entityList, List<PotentialMatch<E>> matches) {
        ArrayList<String> idCompared = new ArrayList<String>();
        compareDone.put(leftEntity.getId(), idCompared);
        log.log(Level.FINE, "comparing {0} with {1} entities ...", new Object[]{leftEntity.getId(), entityList.size()});
        int numberOfCompares = 0;
        for (Entity rightEntity : entityList) {
            idCompared.add(rightEntity.getId());
            if (compareDone.get(rightEntity.getId()) != null && (compareDone.get(rightEntity.getId()) == null || compareDone.get(rightEntity.getId()).contains(leftEntity.getId()))) continue;
            ++numberOfCompares;
            int diff = this.compare(leftEntity, rightEntity);
            if (diff < 0 || diff <= 50 || matches.size() >= 1000) continue;
            matches.add(new PotentialMatch<Entity>((Entity)leftEntity, rightEntity, diff));
            if (matches.size() < 1000) continue;
            break;
        }
        log.log(Level.FINE, "... {0} comparisons done", numberOfCompares);
    }

    private Map<String, List<E>> sort(List<E> entities) {
        HashMap<String, List<E>> map = new HashMap<String, List<E>>();
        for (Entity entity : entities) {
            String[] keys;
            for (String key : keys = this.getKeys(entity)) {
                List<Entity> arrayList;
                if (map.containsKey(key)) {
                    arrayList = (List)map.get(key);
                    arrayList.add(entity);
                    continue;
                }
                arrayList = new ArrayList();
                arrayList.add(entity);
                map.put(key, arrayList);
            }
        }
        return map;
    }

    @Override
    public O getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(O options) {
        this.options = options;
    }

    protected abstract String[] getKeys(E var1);
}

