/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.searchduplicates;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.modules.gedcom.matchers.MatcherOptions;
import ancestris.modules.gedcom.searchduplicates.Bundle;
import ancestris.modules.gedcom.searchduplicates.SearchDuplicatesPanel;
import ancestris.modules.gedcom.searchduplicates.SearchDuplicatesPlugin;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class SearchDuplicatesWizardAction
extends AbstractAncestrisContextAction {
    private static final Logger log = Logger.getLogger(SearchDuplicatesPlugin.class.getName());
    private static RequestProcessor RP = null;
    private RequestProcessor.Task theTask = null;

    public SearchDuplicatesWizardAction() {
        this.setImage("ancestris/modules/gedcom/searchduplicates/CheckDuplicateIcon.png");
        this.setText(NbBundle.getMessage(SearchDuplicatesWizardAction.class, (String)"CTL_CheckDuplicatesAction"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        Context contextToOpen = this.getContext();
        if (contextToOpen != null) {
            Gedcom gedcom = contextToOpen.getGedcom();
            JButton OKButton = new JButton(NbBundle.getMessage(SearchDuplicatesWizardAction.class, (String)"ok_button"));
            SearchDuplicatesPanel panel = new SearchDuplicatesPanel(gedcom, OKButton);
            Object o = DialogManager.create((String)(NbBundle.getMessage(SearchDuplicatesWizardAction.class, (String)"CTL_CheckDuplicatesAction").replaceAll("&", "") + " - " + gedcom.getDisplayName()), (JComponent)panel).setMessageType(-1).setOptions(new Object[]{OKButton, DialogManager.CANCEL_OPTION}).setDialogId("duplicateWindow").show();
            if (o != OKButton) {
                return;
            }
            List<String> entities2Ckeck = panel.getEntitiesToCheck();
            TreeMap<String, MatcherOptions> selectedOptions = panel.getSelectedOptions();
            if (RP == null) {
                RP = new RequestProcessor("SearchDuplicatesWizardAction", 1, true);
            }
            final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)Bundle.CheckDuplicates_runing(), (Cancellable)new Cancellable(){

                public boolean cancel() {
                    log.log(Level.INFO, "handleCancel");
                    if (null == SearchDuplicatesWizardAction.this.theTask) {
                        return false;
                    }
                    return SearchDuplicatesWizardAction.this.theTask.cancel();
                }
            });
            this.theTask = RP.create((Runnable)new SearchDuplicatesPlugin(gedcom, entities2Ckeck, selectedOptions, progressHandle));
            this.theTask.addTaskListener(new TaskListener(){

                public void taskFinished(Task task) {
                    progressHandle.finish();
                }
            });
            this.theTask.schedule(0);
        }
    }
}

