/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.creator.WebSection;
import genj.gedcom.Entity;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class WebDaysDetails
extends WebSection {
    private Comparator<Property> sortEvents = new Comparator<Property>(){

        @Override
        public int compare(Property prop1, Property prop2) {
            if (prop1 == null && prop2 != null) {
                return -1;
            }
            if (prop1 != null && prop2 == null) {
                return 1;
            }
            if (prop1 == null && prop2 == null) {
                return 0;
            }
            PropertyDate date1 = (PropertyDate)prop1;
            PropertyDate date2 = (PropertyDate)prop2;
            if (date1 == null) {
                return -1;
            }
            if (date2 == null) {
                return 1;
            }
            if (date1.compareTo((Property)date2) != 0) {
                return date1.compareTo((Property)date2);
            }
            Entity ent1 = prop1.getEntity();
            Entity ent2 = prop2.getEntity();
            if (ent1 == null) {
                return -1;
            }
            if (ent2 == null) {
                return 1;
            }
            return ent1.toString().compareTo(ent2.toString());
        }
    };

    public WebDaysDetails(boolean generate, WebBook wb, WebBookParams wp, WebHelper wh) {
        super(generate, wb, wp, wh);
    }

    public void init() {
        this.init(this.trs("TXT_Daysdetails"), "daysdetails", "daysdetails_", this.formatFromSize(this.wh.getNbIndis()), 1, this.sizeIndiSection);
        this.calcPages();
    }

    @Override
    public void create() {
        if (this.wb.sectionIndividualsDetails != null) {
            this.personPage = this.wb.sectionIndividualsDetails.getPagesMap();
            this.prefixPersonDetailsDir = this.buildLinkShort(this, this.wb.sectionIndividualsDetails);
        }
        File dir = this.wh.createDir(this.wh.getDir().getAbsolutePath() + File.separator + this.sectionDir, true);
        this.exportData(dir);
    }

    private void exportData(File dir) {
        List<String> days = this.wh.getDays(this.wh.gedcom);
        String fileStr = "";
        File file = null;
        PrintWriter out = null;
        String dayfile = "";
        int cpt = 0;
        int nbDays = days.size();
        int previousPage = 0;
        int currentPage = 0;
        int nextPage = 0;
        int lastPage = nbDays / this.nbPerPage + 1;
        for (String day : days) {
            previousPage = (currentPage = ++cpt / this.nbPerPage + 1) == 1 ? 1 : currentPage - 1;
            nextPage = currentPage == lastPage ? currentPage : currentPage + 1;
            dayfile = this.sectionPrefix + String.format(this.formatNbrs, currentPage) + this.sectionSuffix;
            if (fileStr.compareTo(dayfile) != 0) {
                if (out != null) {
                    this.exportLinks(out, this.sectionPrefix + String.format(this.formatNbrs, currentPage - 1) + this.sectionSuffix, 1, Math.max(1, previousPage - 1), currentPage == lastPage ? lastPage : nextPage - 1, lastPage);
                    this.printCloseHTML(out);
                    out.close();
                    this.wh.log.write(fileStr + this.trs("EXEC_DONE"));
                }
                fileStr = dayfile;
                file = this.wh.getFileForName(dir, dayfile);
                out = this.wh.getWriter(file, this.UTF8);
                this.printOpenHTML(out, "TXT_Daysdetails", this);
            }
            this.exportLinks(out, dayfile, 1, previousPage, nextPage, lastPage);
            this.exportDayDetails(out, day);
        }
        if (out != null) {
            this.exportLinks(out, dayfile, 1, previousPage, nextPage, lastPage);
            this.printCloseHTML(out);
            this.wh.log.write(fileStr + this.trs("EXEC_DONE"));
        }
        if (out != null) {
            out.close();
        }
    }

    private void exportDayDetails(PrintWriter out, String date) {
        String month = this.trs(this.Months[Integer.valueOf(date.substring(0, 2)) - 1]);
        String day = date.substring(2, 4);
        String anchor = this.htmlAnchorText(month) + day;
        out.println("<h2 class=\"unk\"><a name=\"" + anchor + "\"></a>" + day + "&nbsp;" + this.htmlText(month) + "</h2>");
        List<Property> listProps = this.wh.getDaysProps(date);
        Collections.sort(listProps, this.sortEvents);
        boolean first = true;
        for (Property prop : listProps) {
            if (prop == null || prop.getValue().length() == 0) continue;
            if (first) {
                out.println("<div class=\"daycont\">");
                out.println("<span class=\"dayhd1\">" + this.htmlText(this.trs("date_detail")) + "</span>");
                out.println("<span class=\"dayhd2\">" + this.htmlText(this.trs("date_event")) + "</span>");
                out.println("<span class=\"dayhd3\">" + this.htmlText(this.trs("date_indi")) + "</span>");
                out.println("<span class=\"spacer\">&nbsp;</span>");
                first = false;
            }
            out.println("<span class=\"dayevt1\">" + this.wrapEventDate((PropertyDate)prop) + "</span>");
            out.println("<span class=\"dayevt2\">" + this.wrapPropertyName(prop.getParent()) + "</span>");
            out.println("<span class=\"dayevt3\">" + this.wrapEntity(prop.getEntity()) + "</span>");
        }
        out.println("<span class=\"spacer\">&nbsp;</span>");
        out.println("<div class=\"spacer\">&nbsp;</div>");
        out.println("</div>");
    }

    private void calcPages() {
        String dayfile = "";
        String fileStr = "";
        int cpt = 0;
        for (String day : this.wh.getDays(this.wh.gedcom)) {
            dayfile = this.sectionPrefix + String.format(this.formatNbrs, ++cpt / this.nbPerPage + 1) + this.sectionSuffix;
            if (fileStr.compareTo(dayfile) != 0) {
                fileStr = dayfile;
            }
            this.dayPage.put(day, dayfile);
        }
    }

    public Map<String, String> getPagesMap() {
        return this.dayPage;
    }
}

