/*
 * Decompiled with CFR 0.152.
 */
package genj.fo;

import ancestris.api.core.Version;
import genj.util.ImageSniffer;
import genj.util.Resources;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import org.openide.util.Lookup;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Document {
    public static final int FONT_XX_SMALL = 0;
    public static final int FONT_X_SMALL = 1;
    public static final int FONT_SMALL = 2;
    public static final int FONT_MEDIUM = 3;
    public static final int FONT_LARGE = 4;
    public static final int FONT_X_LARGE = 5;
    public static final int FONT_XX_LARGE = 6;
    private static final Resources RESOURCES = Resources.get(Document.class);
    protected static final Pattern REGEX_ATTR = Pattern.compile("([^,]+)=([^,\\(]*(\\(.*?\\))?)");
    private static final String NS_XSLFO = "http://www.w3.org/1999/XSL/Format";
    private static final String NS_GENJ = "http://genj.sourceforge.net/XSL/Format";
    private static final String FORMAT_SECTION = "font-weight=bold,space-before=0.5cm,space-after=0.2cm,keep-with-next.within-page=always";
    private static final String FORMAT_SECTION_LARGER = "font-size=larger,font-weight=bold,space-before=0.5cm,space-after=0.2cm,keep-with-next.within-page=always";
    private static final String[] fontSizes = new String[]{"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large"};
    private org.w3c.dom.Document doc;
    private Element cursor;
    private String title;
    private boolean needsTOC = false;
    private final Map<File, List<Element>> file2elements = new HashMap<File, List<Element>>();
    private final List<TOCEntry> toc = new ArrayList<TOCEntry>();
    private int minSectionFontSize;
    private int maxSectionFontSize;
    private final Map<String, Map<String, Map<String, List<Element>>>> index2primary2secondary2elements = new TreeMap<String, Map<String, Map<String, List<Element>>>>();
    private int idSequence = 0;
    private boolean containsCSV = false;

    public Document(String title) {
        this.createDoc(title, null, 0, 3, 6, 0);
    }

    public Document(String title, String fontFamily, int fontSize, int sizeMin, int sizeMax, int orientation) {
        this.createDoc(title, fontFamily, fontSize, sizeMin, sizeMax, orientation);
    }

    private void createDoc(String title, String fontFamily, int fontSize, int sizeMin, int sizeMax, int orientation) {
        this.title = title;
        this.setSectionSizes(sizeMin, sizeMax);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.doc = dbf.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException t) {
            throw new RuntimeException(t);
        }
        this.cursor = (Element)this.doc.appendChild(this.doc.createElementNS(NS_XSLFO, "root"));
        this.cursor.setAttribute("xmlns", NS_XSLFO);
        this.cursor.setAttribute("xmlns:genj", NS_GENJ);
        if (fontFamily != null) {
            this.cursor.setAttribute("font-family", fontFamily);
        } else {
            this.cursor.setAttribute("font-family", "Arial");
        }
        if (fontSize != 0) {
            this.cursor.setAttribute("font-size", "" + fontSize);
        }
        this.push("layout-master-set");
        if (orientation == 0) {
            this.push("simple-page-master", "master-name=master,margin-top=1cm,margin-bottom=1cm,margin-left=1cm,margin-right=1cm");
        } else {
            this.push("simple-page-master", "master-name=master,margin-top=1cm,margin-bottom=1cm,margin-left=1cm,margin-right=1cm, page-height=21cm, page-width=29.7cm");
        }
        this.push("region-body", "margin-bottom=1cm").pop();
        this.push("region-after", "extent=0.8cm").pop();
        this.pop().pop().push("page-sequence", "master-reference=master");
        this.push("title").text(this.getTitle(), "").pop();
        this.push("static-content", "flow-name=xsl-region-after");
        this.push("table", "border=none");
        this.push("table-body");
        this.push("table-row");
        this.push("table-cell");
        this.push("block", "text-align=left,font-size=7,space-before=2cm");
        this.text(" Ancestris / " + ((Version)Lookup.getDefault().lookup(Version.class)).getVersionString() + " : " + new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis())) + "    ", "");
        this.pop();
        this.pop();
        this.push("table-cell");
        this.push("block", "text-align=right");
        this.push("page-number").pop();
        this.pop();
        this.pop();
        this.pop();
        this.pop();
        this.pop();
        this.pop();
        this.push("flow", "flow-name=xsl-region-body");
        this.push("block");
    }

    public void setSectionSizes(int minSize, int maxSize) {
        if (minSize < 0 || minSize > maxSize || maxSize > fontSizes.length - 1) {
            throw new IllegalArgumentException("setSectionSizes(" + minSize + "," + maxSize + ")");
        }
        this.minSectionFontSize = minSize;
        this.maxSectionFontSize = maxSize;
    }

    protected boolean containsCSV() {
        return this.containsCSV;
    }

    public String toString() {
        return this.getTitle();
    }

    protected void close() {
        if (this.cursor == null) {
            return;
        }
        this.indexes();
        if (this.needsTOC) {
            this.toc();
        }
        this.cursor = null;
    }

    public String getTitle() {
        return this.title;
    }

    DOMSource getDOMSource() {
        return new DOMSource(this.doc);
    }

    public Document addTOC() {
        this.needsTOC = true;
        return this;
    }

    public Document addTOCEntry(String title) {
        this.addTOC();
        String id = "toc" + this.toc.size();
        this.addAnchor(id);
        this.toc.add(new TOCEntry(id, title));
        return this;
    }

    private String getFontSize(int sectionDepth) {
        int i = this.maxSectionFontSize + 1 - sectionDepth;
        if (i < this.minSectionFontSize) {
            i = this.minSectionFontSize;
        }
        return fontSizes[i];
    }

    public Document startSection(String title, String id, int sectionDepth) {
        if (id != null && id.startsWith("_")) {
            throw new IllegalArgumentException("underscore is reserved for internal IDs");
        }
        this.pop("flow", "addSection() is not applicable outside document flow");
        this.cursor = (Element)this.cursor.getLastChild();
        if (id == null || id.length() == 0) {
            id = "toc" + this.toc.size();
        }
        String fontSize = this.getFontSize(sectionDepth);
        this.pop().push("block", "font-size=" + fontSize + "," + FORMAT_SECTION + ",id=" + id);
        this.toc.add(new TOCEntry(id, title));
        this.addText(title);
        this.nextParagraph();
        return this;
    }

    public Document startSection(String title, String id) {
        return this.startSection(title, id, 1);
    }

    public Document startSection(String title, int sectionDepth) {
        return this.startSection(title, "", sectionDepth);
    }

    public Document startSection(String title) {
        return this.startSection(title, "");
    }

    public Document addIndexTerm(String index, String primary) {
        return this.addIndexTerm(index, primary, "");
    }

    public Document addIndexTerm(String index, String primary, String secondary) {
        String id;
        List<Element> elements;
        Map<String, List<Element>> secondary2elements;
        if (index == null) {
            throw new IllegalArgumentException("addIndexTerm() requires name of index");
        }
        if ((index = index.trim()).length() == 0) {
            throw new IllegalArgumentException("addIndexTerm() name of index can't be empty");
        }
        if ((primary = this.trimIndexTerm(primary)).length() == 0) {
            return this;
        }
        secondary = this.trimIndexTerm(secondary);
        Map<String, Map<String, List<Element>>> primary2secondary2elements = this.index2primary2secondary2elements.get(index);
        if (primary2secondary2elements == null) {
            primary2secondary2elements = new TreeMap<String, Map<String, List<Element>>>();
            this.index2primary2secondary2elements.put(index, primary2secondary2elements);
        }
        if ((secondary2elements = primary2secondary2elements.get(primary)) == null) {
            secondary2elements = new TreeMap<String, List<Element>>();
            primary2secondary2elements.put(primary, secondary2elements);
        }
        if ((elements = secondary2elements.get(secondary)) == null) {
            elements = new ArrayList<Element>();
            secondary2elements.put(secondary, elements);
        }
        if ((id = this.cursor.getAttribute("id")).length() == 0) {
            id = "" + ++this.idSequence;
            this.cursor.setAttribute("id", id);
        }
        if (!elements.contains(this.cursor)) {
            elements.add(this.cursor);
        }
        return this;
    }

    private String trimIndexTerm(String term) {
        int comma;
        if (term == null) {
            return "";
        }
        int bracket = term.indexOf(40);
        if (bracket >= 0) {
            term = term.substring(0, bracket);
        }
        if ((comma = term.indexOf(40)) >= 0) {
            term = term.substring(0, comma);
        }
        return term.trim();
    }

    public Document addText(String text) {
        return this.addText(text, "");
    }

    public Document addText(String text, String atts) {
        this.text(text, atts);
        return this;
    }

    public Document addImage(File file, String atts) {
        if (file == null || !file.exists()) {
            return this;
        }
        Dimension2D dim = new ImageSniffer(file).getDimensionInInches();
        if (dim == null) {
            return this;
        }
        if (dim.getWidth() > dim.getHeight()) {
            if (dim.getWidth() > 1.0) {
                atts = "width=1in,content-width=scale-to-fit," + atts;
            }
        } else if (dim.getHeight() > 1.0) {
            atts = "height=1in,content-height=scale-to-fit," + atts;
        }
        this.push("external-graphic", "src=" + file.getAbsolutePath() + "," + atts);
        List<Element> elements = this.file2elements.get(file);
        if (elements == null) {
            elements = new ArrayList<Element>(3);
            this.file2elements.put(file, elements);
        }
        elements.add(this.cursor);
        this.pop();
        this.addText(" ");
        return this;
    }

    protected File[] getImages() {
        Set<File> files = this.file2elements.keySet();
        return files.toArray(new File[files.size()]);
    }

    protected void setImage(File file, String value) {
        List<Element> nodes = this.file2elements.get(file);
        for (Element external : nodes) {
            external.setAttribute("src", value);
        }
    }

    public Document nextParagraph() {
        return this.nextParagraph("");
    }

    public Document nextParagraph(String format) {
        if (this.cursor.getFirstChild() != null) {
            this.pop().push("block", format);
        } else {
            this.attributes(this.cursor, format);
        }
        return this;
    }

    public Document startList() {
        return this.startList("");
    }

    public Document startList(String format) {
        this.pop();
        this.push("list-block", "provisional-distance-between-starts=0.6em, provisional-label-separation=0pt," + format);
        this.nextListItem();
        return this;
    }

    public Document nextListItem() {
        return this.nextListItem("");
    }

    public Document nextListItem(String format) {
        Element list = this.peek("list-block", "nextListItem() is not applicable outside list block");
        if (list.getChildNodes().getLength() == 1 && this.cursor.getFirstChild() == null && this.cursor.getPreviousSibling() == null && this.cursor.getParentNode().getLocalName().equals("list-item-body")) {
            list.removeChild(list.getFirstChild());
        }
        this.cursor = list;
        String label = this.attribute("genj:label", format);
        if (label != null) {
            String dist = list.getAttribute("provisional-distance-between-starts");
            if (dist.endsWith("em")) {
                float len = (float)label.length() * 0.6f;
                if (Float.parseFloat(dist.substring(0, dist.length() - 2)) < len) {
                    list.setAttribute("provisional-distance-between-starts", len + "em");
                }
            }
        } else {
            label = "\u2219";
        }
        this.push("list-item");
        this.push("list-item-label", "end-indent=label-end()");
        this.push("block");
        this.text(label, "");
        this.pop();
        this.pop();
        this.push("list-item-body", "start-indent=body-start()");
        this.push("block");
        return this;
    }

    public Document endList() {
        this.pop("list-block", "endList() is not applicable outside list-block").pop();
        this.push("block", "");
        return this;
    }

    public Document startTable() {
        return this.startTable("width=100%,border=0.5pt solid black");
    }

    public Document startTable(String format) {
        format = "table-layout=fixed," + format;
        this.push("table", format);
        Element table = this.cursor;
        if ("true".equals(this.attribute("genj:csv", format))) {
            this.containsCSV = true;
            this.cursor.setAttributeNS(NS_GENJ, "genj:csv", "true");
            String prefix = this.attribute("genj:csvprefix", format);
            if (prefix != null) {
                this.cursor.setAttributeNS(NS_GENJ, "genj:csvprefix", prefix);
            }
        }
        if (format.indexOf("genj:header=true") >= 0) {
            this.push("table-header");
            this.push("table-row", "color=#ffffff,background-color=#c0c0c0,font-weight=bold");
        } else {
            this.push("table-body");
            this.push("table-row");
        }
        this.push("table-cell", "border=" + table.getAttribute("border"));
        this.push("block");
        return this;
    }

    public Document addTableColumn(String atts) {
        Node before;
        Element save = this.cursor;
        this.pop("table", "addTableColumn() is not applicable outside enclosing table");
        for (before = this.cursor.getFirstChild(); before != null && before.getNodeName().equals("table-column"); before = before.getNextSibling()) {
        }
        this.push("table-column", atts, before);
        this.cursor = save;
        return this;
    }

    public Document nextTableCell() {
        return this.nextTableCell("");
    }

    public Document nextTableCell(String atts) {
        Element cell = this.peek("table-cell", "nextTableCell() is not applicable outside enclosing table");
        if (cell.getPreviousSibling() == null && this.cursor == cell.getFirstChild() && !this.cursor.hasChildNodes()) {
            this.attributes(cell, atts);
            this.push("inline", "").pop();
            return this;
        }
        Element row = this.peek("table-row", "nextTableCell() is not applicable outside enclosing table row");
        int cells = row.getElementsByTagName("table-cell").getLength();
        Element table = this.peek("table", "nextTableCell() is not applicable outside enclosing table");
        int cols = table.getElementsByTagName("table-column").getLength();
        if (cols > 0 && cells == cols) {
            return this.nextTableRow();
        }
        this.pop("table-row", "nextTableCell() is not applicable outside enclosing table row");
        this.push("table-cell", "border=" + table.getAttribute("border") + "," + atts);
        this.push("block");
        return this;
    }

    public Document nextTableRow() {
        return this.nextTableRow("");
    }

    public Document nextTableRow(String atts) {
        Element cell = this.peek("table-cell", "nextTableRow() is not applicable outside enclosing table");
        if (cell.getPreviousSibling() == null && this.cursor == cell.getFirstChild() && !this.cursor.hasChildNodes()) {
            this.attributes((Element)cell.getParentNode(), atts);
            return this;
        }
        this.pop("table", "nextTableRow() is not applicable outside enclosing table");
        Element table = this.cursor;
        if (table.getLastChild().getNodeName().equals("table-body")) {
            this.cursor = (Element)table.getLastChild();
        } else {
            this.push("table-body");
        }
        this.push("table-row", atts);
        this.push("table-cell", "border=" + table.getAttribute("border"));
        this.push("block");
        return this;
    }

    public Document endTable() {
        this.pop("table", "endTable() is not applicable outside enclosing table").pop();
        return this;
    }

    public Document nextPage() {
        this.pop();
        this.push("block", "page-break-before=always");
        return this;
    }

    public Document addAnchor(String id) {
        if (id.startsWith("_")) {
            throw new IllegalArgumentException("underscore is reserved for internal IDs");
        }
        if (this.cursor.getAttribute("id").length() == 0) {
            this.cursor.setAttribute("id", id);
        } else {
            this.push("block", "id=" + id).pop();
        }
        return this;
    }

    public Document addExternalLink(String text, String id) {
        this.push("basic-link", "external-destination=" + id);
        this.text(text, "");
        this.pop();
        return this;
    }

    public Document addLink(String text, String id) {
        this.push("basic-link", "internal-destination=" + id);
        this.text(text, "");
        this.pop();
        return this;
    }

    private Document indexes() {
        for (String index : this.index2primary2secondary2elements.keySet()) {
            Map<String, Map<String, List<Element>>> primary2secondary2elements = this.index2primary2secondary2elements.get(index);
            this.nextPage();
            this.startSection(index);
            this.push("block", "start-indent=1cm");
            for (String primary : primary2secondary2elements.keySet()) {
                Map<String, List<Element>> secondary2elements = primary2secondary2elements.get(primary);
                this.push("block", "");
                this.text(primary + " ", "");
                for (String secondary : secondary2elements.keySet()) {
                    List<Element> elements = secondary2elements.get(secondary);
                    if (secondary.length() > 0) {
                        this.push("block", "start-indent=2cm");
                        this.text(secondary + " ", "");
                    }
                    for (int e = 0; e < elements.size(); ++e) {
                        if (e > 0) {
                            this.text(", ", "");
                        }
                        Element element = elements.get(e);
                        String id = element.getAttribute("id");
                        this.push("basic-link", "internal-destination=" + id);
                        this.push("page-number-citation", "ref-id=" + id);
                        this.cursor.setAttributeNS(NS_GENJ, "genj:citation", Integer.toString(e + 1));
                        this.pop();
                        this.pop();
                    }
                    if (secondary.length() <= 0) continue;
                    this.pop();
                }
                this.pop();
            }
            this.pop();
        }
        return this;
    }

    private Document toc() {
        if (this.toc.isEmpty()) {
            return this;
        }
        Element old = this.cursor;
        this.pop("flow", "can't create TOC without enclosing flow");
        this.push("block", "", this.cursor.getFirstChild());
        this.push("block", FORMAT_SECTION_LARGER);
        this.text(RESOURCES.getString("toc"), "");
        this.pop();
        this.addAnchor("toc");
        for (TOCEntry entry : this.toc) {
            this.push("block", "start-indent=1cm,end-indent=1cm,text-indent=0cm,text-align=left");
            this.nextParagraph("space-after=0.2cm");
            this.addLink(entry.text, entry.id);
            this.push("leader", "leader-pattern=dots").pop();
            this.push("page-number-citation", "ref-id=" + entry.id).pop();
            this.pop();
        }
        this.cursor = old;
        return this;
    }

    private Document push(String name) {
        return this.push(name, "");
    }

    private Document push(String name, String attributes) {
        return this.push(name, attributes, null);
    }

    private Document push(String name, String attributes, Node before) {
        Element elem = this.doc.createElementNS(NS_XSLFO, name);
        if (before != null) {
            this.cursor.insertBefore(elem, before);
        } else {
            this.cursor.appendChild(elem);
        }
        this.cursor = elem;
        return this.attributes(elem, attributes);
    }

    private Document attributes(Element elem, String format) {
        Matcher m = REGEX_ATTR.matcher(format);
        while (m.find()) {
            String key = m.group(1).trim();
            if (key.indexOf(58) >= 0) continue;
            String val = m.group(2).trim();
            elem.setAttribute(key, val);
        }
        return this;
    }

    private String attribute(String key, String format) {
        Matcher m = REGEX_ATTR.matcher(format);
        while (m.find()) {
            if (!m.group(1).trim().equals(key)) continue;
            return m.group(2).trim();
        }
        return null;
    }

    private Document text(String text, String atts) {
        if (text.length() == 0) {
            return this;
        }
        Text txt = this.doc.createTextNode(text);
        if (atts.length() > 0) {
            this.push("inline", atts);
            this.cursor.appendChild(txt);
            this.pop();
        } else {
            this.cursor.appendChild(txt);
        }
        return this;
    }

    private Document pop() {
        this.cursor = (Element)this.cursor.getParentNode();
        return this;
    }

    private Document pop(String qname, String error) {
        this.cursor = this.peek(qname, error);
        return this;
    }

    private Element peek(String qname, String error) {
        Node loop = this.cursor;
        while (loop instanceof Element) {
            if (loop.getLocalName().equals(qname)) {
                return loop;
            }
            loop = loop.getParentNode();
        }
        throw new IllegalArgumentException(error);
    }

    private class TOCEntry {
        String id;
        String text;

        private TOCEntry(String id, String text) {
            this.id = id;
            this.text = text;
        }
    }
}

