/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.geo;

import ancestris.api.place.Place;
import ancestris.api.place.PlaceFactory;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.modules.geo.GeoInternetSearch;
import ancestris.modules.geo.GeoListTopComponent;
import ancestris.modules.geo.GeoNodeObject;
import ancestris.modules.geo.GeoPlacesListener;
import ancestris.modules.geo.GeoPlugin;
import ancestris.modules.geo.PlaceDisplayFormatPanel;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomMetaListener;
import genj.gedcom.Property;
import genj.gedcom.PropertyLatitude;
import genj.gedcom.PropertyLongitude;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyPlace;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.swing.JComponent;
import org.jxmapviewer.viewer.GeoPosition;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class GeoPlacesList
implements GedcomMetaListener {
    private static final String NO_DATE = "01-01-1900";
    private static final String FORCE_REFRESH_DATE = "03-05-2015";
    public static String TYPEOFCHANGE_GEDCOM = "gedcom";
    public static String TYPEOFCHANGE_COORDINATES = "coord";
    public static String TYPEOFCHANGE_NAME = "name";
    private static SortedMap<Gedcom, GeoPlacesList> instances;
    private final Gedcom gedcom;
    private GeoNodeObject[] geoNodes;
    private final List<GeoPlacesListener> listeners = new ArrayList<GeoPlacesListener>(10);
    private boolean stopListening = false;
    private boolean updateRequired = false;
    private PropertyPlace copiedPlace = null;
    private GeoPosition copiedPosition = null;

    public GeoPlacesList(Gedcom gedcom) {
        this.gedcom = gedcom;
        this.geoNodes = null;
        AncestrisPlugin.register((Object)((Object)new GeoPlugin()));
    }

    public static synchronized GeoPlacesList getInstance(Gedcom gedcom) {
        if (instances == null) {
            instances = new TreeMap<Gedcom, GeoPlacesList>();
        }
        if (gedcom == null) {
            return null;
        }
        GeoPlacesList gpl = (GeoPlacesList)instances.get(gedcom);
        if (gpl == null) {
            gpl = new GeoPlacesList(gedcom);
            instances.put(gedcom, gpl);
            gedcom.addGedcomListener((GedcomListener)gpl);
        }
        return gpl;
    }

    public static void remove(Gedcom gedcom) {
        if (gedcom == null || instances == null) {
            return;
        }
        GeoPlacesList gpl = (GeoPlacesList)instances.get(gedcom);
        if (gpl == null) {
            return;
        }
        gedcom.removeGedcomListener((GedcomListener)gpl);
        instances.remove(gedcom);
    }

    public Gedcom getGedcom() {
        return this.gedcom;
    }

    public GeoNodeObject[] getNodes() {
        return this.geoNodes;
    }

    public Map<Place, Set<Property>> getPlaces(boolean withInfo, Callable okWhenDone, Callable cancelWhenDone) {
        boolean pleaseSearch = false;
        if (this.geoNodes == null) {
            pleaseSearch = true;
        } else if (withInfo) {
            int count = 0;
            for (GeoNodeObject node : this.geoNodes) {
                if (node.isEvent || !node.areCoordinatesUnknown() && !node.isMissingLocalInformation()) continue;
                ++count;
            }
            if (count > this.geoNodes.length / 2) {
                pleaseSearch = true;
            }
        }
        if (pleaseSearch) {
            Callable okCallback = okWhenDone;
            if (okCallback == null) {
                okCallback = new Callable(){

                    public Object call() throws Exception {
                        DialogManager.create((String)NbBundle.getMessage(GeoInternetSearch.class, (String)"TITL_SearchCompleted"), (String)NbBundle.getMessage(GeoInternetSearch.class, (String)"TEXT_SearchCompleted")).setOptionType(10).show();
                        return null;
                    }
                };
            }
            this.launchPlacesSearch(0, true, true, okCallback, cancelWhenDone);
            return null;
        }
        HashMap<Place, Set<Property>> map = new HashMap<Place, Set<Property>>();
        Place place = null;
        for (GeoNodeObject node : this.geoNodes) {
            if (node.isEvent || node.areCoordinatesUnknown() || (place = node.getPlace()) == null) continue;
            HashSet<Property> events = (HashSet<Property>)map.get(place);
            if (events == null) {
                events = new HashSet<Property>();
                map.put(place, events);
            }
            events.addAll(node.getEventsProperties());
        }
        return map;
    }

    public synchronized void launchPlacesSearch(final int internetSearchType, final boolean checkCoordinates, final boolean checkLocalMissing, final Callable okWhenDone, final Callable cancelWhenDone) {
        final List placesProps = this.gedcom.getPropertiesByClass(PropertyPlace.class);
        if (placesProps.isEmpty()) {
            DialogManager.create((String)NbBundle.getMessage(GeoInternetSearch.class, (String)"ANOMALY_Title"), (String)NbBundle.getMessage(GeoInternetSearch.class, (String)"TXT_SearchPlacesNone")).setDialogId("geo.refresh.noplace").setOptionType(10).show();
            return;
        }
        String paramDate = NbPreferences.forModule(PlaceFactory.class).get("##Version Date##", NO_DATE);
        if (!paramDate.equals(NO_DATE)) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
                Date versionDate = formatter.parse(paramDate);
                Date fromValidDate = formatter.parse(FORCE_REFRESH_DATE);
                if (versionDate.before(fromValidDate)) {
                    NbPreferences.forModule(PlaceFactory.class).clear();
                    NbPreferences.forModule(PlaceFactory.class).put("##Version Date##", FORCE_REFRESH_DATE);
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        final GeoPlacesList gpl = this;
        GeoInternetSearch gis = new GeoInternetSearch(this, placesProps){

            @Override
            public void callback() {
                if (internetSearchType == 0 && (checkCoordinates || checkLocalMissing)) {
                    boolean reforce = false;
                    String msg = "";
                    if (GeoPlacesList.this.getNodes() == null) {
                        msg = NbBundle.getMessage(GeoInternetSearch.class, (String)"TXT_SearchPlacesAborted");
                    } else if (GeoPlacesList.this.getNodes().length > 0) {
                        int countCoordinatesUnknown = 0;
                        int countLocalPlaceMissing = 0;
                        for (GeoNodeObject node : GeoPlacesList.this.getNodes()) {
                            if (node.areCoordinatesUnknown()) {
                                ++countCoordinatesUnknown;
                            }
                            if (!node.isMissingLocalInformation()) continue;
                            ++countLocalPlaceMissing;
                        }
                        if (checkCoordinates) {
                            if (countCoordinatesUnknown == GeoPlacesList.this.getNodes().length) {
                                msg = NbBundle.getMessage(GeoInternetSearch.class, (String)"TXT_SearchPlacesNoCoord");
                            } else if (countCoordinatesUnknown * 100 / GeoPlacesList.this.getNodes().length > 50) {
                                msg = NbBundle.getMessage(GeoInternetSearch.class, (String)"TXT_SearchPlacesMissingCoord");
                            }
                        }
                        if (checkLocalMissing) {
                            if (countLocalPlaceMissing == GeoPlacesList.this.getNodes().length) {
                                msg = NbBundle.getMessage(GeoInternetSearch.class, (String)"TXT_SearchPlacesNoLocal", (Object)GeoPlacesList.this.gedcom.getDisplayName());
                            } else if (countLocalPlaceMissing * 100 / GeoPlacesList.this.getNodes().length > 50) {
                                msg = NbBundle.getMessage(GeoInternetSearch.class, (String)"TXT_SearchPlacesMissingLocal", (Object)GeoPlacesList.this.gedcom.getDisplayName());
                            }
                        }
                    }
                    if (!msg.isEmpty()) {
                        Object o = DialogManager.create((String)NbBundle.getMessage(GeoInternetSearch.class, (String)"ANOMALY_Title"), (String)msg).setDialogId("geo.refresh.coord").setOptionType(0).show();
                        if (o.equals(DialogManager.OK_OPTION)) {
                            reforce = true;
                        } else if (cancelWhenDone != null) {
                            try {
                                cancelWhenDone.call();
                                return;
                            }
                            catch (Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                    if (reforce) {
                        GeoInternetSearch gis2 = new GeoInternetSearch(gpl, placesProps){

                            @Override
                            public void callback() {
                                if (okWhenDone != null) {
                                    try {
                                        okWhenDone.call();
                                    }
                                    catch (Exception ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                }
                            }
                        };
                        gis2.executeSearch(GeoPlacesList.this.gedcom, 2);
                    } else if (okWhenDone != null) {
                        try {
                            okWhenDone.call();
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
        };
        gis.executeSearch(this.gedcom, internetSearchType);
    }

    public void setPlaces(GeoNodeObject[] result) {
        this.geoNodes = result;
        this.notifyListeners(TYPEOFCHANGE_GEDCOM);
        this.startListening();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGeoPlacesListener(GeoPlacesListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener can't be null");
        }
        List<GeoPlacesListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.add(listener)) {
                throw new IllegalArgumentException("can't add gedcom listener " + listener + "twice");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGeoPlacesListener(GeoPlacesListener listener) {
        List<GeoPlacesListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        if (this.updateRequired) {
            return;
        }
        this.checkReloadPlaces((Property)entity);
    }

    public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
        if (this.updateRequired) {
            return;
        }
        this.checkReloadPlaces((Property)entity);
    }

    public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
        if (this.updateRequired) {
            return;
        }
        this.checkReloadPlaces(property);
    }

    public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
        if (this.updateRequired) {
            return;
        }
        this.checkReloadPlaces(property);
    }

    public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
        if (this.updateRequired) {
            return;
        }
        this.checkReloadPlaces(property);
    }

    public void gedcomHeaderChanged(Gedcom gedcom) {
    }

    public void gedcomWriteLockAcquired(Gedcom gedcom) {
    }

    public void gedcomBeforeUnitOfWork(Gedcom gedcom) {
    }

    public void gedcomAfterUnitOfWork(Gedcom gedcom) {
    }

    public void gedcomWriteLockReleased(Gedcom gedcom) {
        this.reloadPlaces();
    }

    private void checkReloadPlaces(Property property) {
        List tmpList = property.getProperties(PropertyPlace.class);
        if (property instanceof PropertyPlace || !tmpList.isEmpty()) {
            this.updateRequired = true;
        } else if (property instanceof PropertyName && !property.getEntity().getProperties(PropertyPlace.class).isEmpty()) {
            this.updateRequired = true;
        }
    }

    public void reloadPlaces() {
        if (!this.stopListening && this.updateRequired) {
            this.stopListening();
            this.launchPlacesSearch(0, false, false, null, null);
            this.updateRequired = false;
        }
    }

    public void stopListening() {
        this.stopListening = true;
    }

    public void startListening() {
        this.stopListening = false;
    }

    public void notifyListeners(String change) {
        GeoPlacesListener[] gpls;
        for (GeoPlacesListener gpl : gpls = this.listeners.toArray(new GeoPlacesListener[this.listeners.size()])) {
            try {
                gpl.geoPlacesChanged(this, change);
            }
            catch (Throwable t) {
                System.out.println("exception in geoplaceslist listener " + gpl + t);
            }
        }
    }

    public void refreshPlaceCoord() {
        this.notifyListeners(TYPEOFCHANGE_COORDINATES);
    }

    public void refreshPlaceName() {
        this.notifyListeners(TYPEOFCHANGE_NAME);
    }

    public boolean setPlaceDisplayFormat(PropertyPlace place) {
        boolean changed = false;
        String displayFormat = this.getGedcom().getPlaceDisplayFormat();
        PlaceDisplayFormatPanel fdfPanel = new PlaceDisplayFormatPanel(place);
        Object o = DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"TITL_SetPlaceDisplayFormat"), (JComponent)fdfPanel).setMessageType(-1).setOptionType(2).show();
        if (o == DialogManager.OK_OPTION) {
            String newPlaceDisplayFormat = fdfPanel.getDisplayFormat();
            this.gedcom.setPlaceDisplayFormat(newPlaceDisplayFormat);
            changed = true;
        }
        return changed;
    }

    public String getPlaceKey(PropertyPlace place) {
        return this.getPlaceDisplayFormat(place) + "[" + this.getMapString(place) + "]";
    }

    public String getPlaceDisplayFormat(PropertyPlace place) {
        String str = "";
        if (place == null || (str = place.format(null)).isEmpty()) {
            return NbBundle.getMessage(GeoListTopComponent.class, (String)"GeoEmpty");
        }
        if (str.equals(",[]")) {
            return "";
        }
        str = str.replaceAll("\\(\\)", "");
        str = str.replaceAll("\\[\\]", "");
        str = str.replaceAll("\\{\\}", "");
        str = str.replaceAll("<html>", "");
        str = str.replaceAll("</html>", "");
        return str;
    }

    public String getMapString(PropertyPlace place) {
        String ret = "";
        PropertyLatitude prop = place.getLatitude(true);
        if (prop != null) {
            ret = ret + prop.getDisplayValue() + " ";
        }
        if ((prop = place.getLongitude(true)) != null) {
            ret = ret + prop.getDisplayValue();
        }
        return ret;
    }

    public void setMapCoord(PropertyPlace placeSource, List<PropertyPlace> propPlaces) {
        PropertyLatitude latitudeSource = placeSource.getLatitude(false);
        PropertyLongitude longitudeSource = placeSource.getLongitude(false);
        String latitudeSourceStr = latitudeSource == null ? "" : latitudeSource.getValue();
        String longitudeSourceStr = longitudeSource == null ? "" : longitudeSource.getValue();
        for (PropertyPlace pp : propPlaces) {
            pp.setValue(placeSource.getValue());
            pp.setCoordinates(latitudeSourceStr, longitudeSourceStr);
        }
    }

    public void setCopiedPlace(PropertyPlace place, GeoPosition geoPoint) {
        this.copiedPlace = place;
        this.copiedPosition = geoPoint;
    }

    public PropertyPlace getCopiedPlace() {
        return this.copiedPlace;
    }

    public GeoPosition getCopiedPosition() {
        return this.copiedPosition;
    }
}

