/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.api.imports.ImportFix;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.FixesWindow;
import ancestris.modules.imports.gedcom.ImportGramps;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.openide.util.NbBundle;

public class ImportGeneanet
extends Import {
    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importgeneanet_name();
    }

    protected String getImportComment() {
        return Bundle.importgeneanet_note();
    }

    public void showDetails(Context context, boolean extract) {
        new FixesWindow(this.summary, context, this.fixes).displayFixes(extract);
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        this.incrementProgress();
        this.incrementProgress();
        return ret |= this.removeDoubleAssociations(gedcom);
    }

    private boolean removeDoubleAssociations(Gedcom gedcom) {
        boolean fixed = false;
        ArrayList list = new ArrayList();
        gedcom.getIndis().forEach(entity -> this.getPropertiesRecursively(list, "ASSO", (Property)entity));
        HashMap<String, PropertyAssociation> mapL = new HashMap<String, PropertyAssociation>();
        for (Property prop : list) {
            if (prop instanceof PropertyAssociation) {
                PropertyAssociation pa = (PropertyAssociation)prop;
                String origine = pa.getEntity().getId();
                String destination = pa.getTargetEntity().getId();
                String key = origine + " -;- " + destination;
                if (mapL.containsKey(key)) {
                    PropertyAssociation po = (PropertyAssociation)mapL.get(key);
                    Property relaO = po.getProperty("RELA", false);
                    if (!relaO.getValue().contains("@")) {
                        Entity ent = po.getEntity();
                        this.fixes.add(new ImportFix(ent.getId(), "duplicateAssociations.1", po.getPath(true).getShortName(), "", po.getValue(), ""));
                        fixed = true;
                        ent.delProperty((Property)po);
                        mapL.remove(key);
                        mapL.put(key, pa);
                        continue;
                    }
                    Property relaA = pa.getProperty("RELA", false);
                    if (relaA.getValue().contains("@")) continue;
                    Entity ent = pa.getEntity();
                    this.fixes.add(new ImportFix(ent.getId(), "duplicateAssociations.1", pa.getPath(true).getShortName(), "", pa.getValue(), ""));
                    fixed = true;
                    ent.delProperty((Property)pa);
                    continue;
                }
                mapL.put(key, pa);
                continue;
            }
            LOG.log(Level.WARNING, "The following association property is not of type PropertyAssociation: " + prop);
        }
        return fixed;
    }

    public boolean fixOther(Gedcom gedcom) {
        boolean hasErrors = false;
        if (gedcom.getGrammar().equals(Grammar.V551)) {
            List fileList = gedcom.getPropertiesByClass(PropertyFile.class);
            Property obje = null;
            Property form = null;
            for (Property file : fileList) {
                obje = file.getParent();
                form = obje.getProperty("FORM");
                if (form != null) {
                    if (file.getProperty("FORM") == null) {
                        file.addProperty("FORM", form.getValue());
                    }
                    obje.delProperty(form);
                    this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixMediaForm", (Object)file.toString()));
                    hasErrors = true;
                    continue;
                }
                if (file.getProperty("FORM") != null) continue;
                String value = file.getValue();
                String ext = "";
                if (value.startsWith("http")) {
                    ext = FileChooserBuilder.getExtension((String)value);
                    if (ext == null || "".equals(ext)) {
                        ext = "web";
                    }
                } else {
                    ext = FileChooserBuilder.getExtension((String)value);
                }
                if (ext == null) {
                    ext = "none";
                }
                file.addProperty("FORM", ext);
                this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixMediaForm", (Object)file.toString()));
                hasErrors = true;
            }
        }
        return hasErrors;
    }
}

