/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.PropertyDate;
import genj.gedcom.TagPath;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.report.Report;

public class ReportAges
extends Report {
    public boolean reportBaptismAge = true;
    public boolean reportConfirmationAge = true;
    public boolean reportMarriageAge = true;
    public boolean reportAgeAtDivorce = true;
    public boolean reportAgeAtChildBirth = true;
    public boolean reportAgeAtEmigration = true;
    public boolean reportAgeAtImmigration = true;
    public boolean reportAgeAtNaturalization = true;
    public boolean reportAgeAtDeath = true;
    public boolean reportAgeSinceBirth = true;
    public boolean reportAgeSinceDeath = true;
    private static final String AGE = Gedcom.getName((String)"AGE");

    public void start(Indi indi) {
        this.analyzeIndi(indi);
    }

    private boolean analyzeEvent(boolean header, Indi indi, String tag) {
        PropertyDate prop = (PropertyDate)indi.getProperty(new TagPath("INDI:" + tag + ":DATE"));
        if (prop == null || !prop.isValid()) {
            return false;
        }
        if (header) {
            this.println(this.getIndent(2) + Gedcom.getName((String)tag) + ':');
        }
        this.println(this.getIndent(3) + prop.getDisplayValue());
        Delta age = indi.getAge(prop.getStart());
        this.printAge(age, 4);
        this.println();
        return true;
    }

    private void analyzeIndi(Indi indi) {
        PointInTime now;
        PropertyDate death;
        Indi[] children;
        String text;
        int i;
        Fam[] fams;
        Delta age = null;
        this.println(indi);
        PropertyDate birth = indi.getBirthDate();
        if (birth == null || !birth.isValid()) {
            this.println(this.OPTIONS.getBirthSymbol() + this.translate("noData"));
            return;
        }
        this.println(this.OPTIONS.getBirthSymbol() + birth);
        this.println();
        if (this.reportBaptismAge) {
            this.analyzeEvent(true, indi, "BAPM");
            this.analyzeEvent(true, indi, "BAPL");
            this.analyzeEvent(true, indi, "CHR");
            this.analyzeEvent(true, indi, "CHRA");
        }
        if (this.reportConfirmationAge) {
            this.analyzeEvent(true, indi, "CONF");
        }
        if (this.reportMarriageAge && (fams = indi.getFamiliesWhereSpouse()).length > 0) {
            this.println(this.getIndent(2) + Gedcom.getName((String)"MARR") + ":");
            for (i = 0; i < fams.length; ++i) {
                Fam fam = fams[i];
                text = this.getIndent(3) + this.OPTIONS.getMarriageSymbol() + " " + fam + ": ";
                if (fam.getMarriageDate() == null) {
                    this.println(text + this.translate("noData"));
                    continue;
                }
                this.println(text + fam.getMarriageDate());
                age = indi.getAge(fam.getMarriageDate().getStart());
                this.printAge(age, 4);
            }
            this.println();
        }
        if (this.reportAgeAtDivorce && (fams = indi.getFamiliesWhereSpouse()).length > 0) {
            boolean found = false;
            for (int i2 = 0; i2 < fams.length; ++i2) {
                Fam fam = fams[i2];
                if (fam.getDivorceDate() == null) continue;
                if (!found) {
                    this.println(this.getIndent(2) + Gedcom.getName((String)"DIV") + ":");
                    found = true;
                }
                this.println(this.getIndent(3) + this.OPTIONS.getDivorceSymbol() + " " + fam + ": " + fam.getDivorceDate());
                age = indi.getAge(fam.getDivorceDate().getStart());
                this.printAge(age, 4);
            }
            if (found) {
                this.println();
            }
        }
        if (this.reportAgeAtChildBirth && (children = indi.getChildren()).length > 0) {
            this.println(this.getIndent(2) + this.translate("childBirths") + ":");
            for (i = 0; i < children.length; ++i) {
                Indi child = children[i];
                text = this.getIndent(3) + this.OPTIONS.getBirthSymbol() + child + ": ";
                PropertyDate cbirth = child.getBirthDate();
                if (cbirth == null) {
                    this.println(text + this.translate("noData"));
                    continue;
                }
                this.println(text + cbirth);
                age = indi.getAge(cbirth.getStart());
                this.printAge(age, 4);
            }
            this.println();
        }
        if (this.reportAgeAtEmigration) {
            this.analyzeEvent(true, indi, "EMIG");
        }
        if (this.reportAgeAtImmigration) {
            this.analyzeEvent(true, indi, "IMMI");
        }
        if (this.reportAgeAtNaturalization) {
            this.analyzeEvent(true, indi, "NATU");
        }
        if (this.reportAgeAtDeath && (death = indi.getDeathDate()) != null) {
            this.println(this.getIndent(2) + Gedcom.getName((String)"DEAT") + ":");
            this.println(this.getIndent(3) + this.OPTIONS.getDeathSymbol() + death);
            age = indi.getAge(indi.getDeathDate().getStart());
            this.printAge(age, 4);
            this.println();
        }
        if (this.reportAgeSinceBirth && (age = indi.getAge(now = PointInTime.getNow())) != null) {
            this.println(this.getIndent(2) + this.translate("sinceBirth", new Object[]{now}) + ":");
            this.printAge(age, 4);
            this.println();
        }
        if (this.reportAgeSinceDeath) {
            now = PointInTime.getNow();
            PropertyDate death2 = indi.getDeathDate();
            if (death2 != null && (age = death2.getAnniversary()) != null) {
                this.println(this.getIndent(2) + this.translate("sinceDeath", new Object[]{now}) + ":");
                this.printAge(age, 4);
                this.println();
            }
        }
    }

    private void printAge(Delta age, int indent) {
        if (age == null) {
            this.println(this.getIndent(indent) + this.translate("noData"));
        } else {
            this.println(this.getIndent(indent) + AGE + ": " + age);
        }
    }
}

