/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import ancestris.core.TextOptions;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class ReportForYEd
extends Report {
    public boolean showOccupation = true;
    public Events events = new Events();
    public Images images = new Images();
    public Links links = new Links();
    public Filter filter = new Filter();
    public Gender gender = new Gender();
    private final String XML_LINK_CONTAINER = this.getString("LinkContainer");
    private final String XML_POPUP_CONTAINER = this.getString("PopUpContainer");
    private final String XML_FAMILY = this.getString("FamilyNode");
    private final String XML_INDI = this.getString("IndiNode");
    private final String XML_EDGE = this.getString("Edge");
    private final String XML_HEAD = this.getString("XmlHead");
    private final String XML_TAIL = this.getString("XmlTail");
    private static final String[] INDI_COLORS = ReportForYEd.createIndiColors();
    private static final TextOptions OPTIONS = TextOptions.getInstance();
    private int edgeCount = 0;
    private File reportFile;
    private static final PointInTime pit = new PointInTime(1, 1, 2200);

    public void start(Gedcom gedcom) throws IOException {
        String value;
        if (!this.filter.active) {
            this.generateReport(gedcom.getFamilies(), gedcom.getIndis());
            return;
        }
        HashSet<Indi> indis = new HashSet<Indi>();
        HashSet<Fam> fams = new HashSet<Fam>();
        for (Fam fam : gedcom.getFamilies()) {
            value = fam.getPropertyValue(this.filter.tag);
            if (value == null || !value.contains(this.filter.content)) continue;
            fams.add(fam);
            indis.add(fam.getHusband());
            indis.add(fam.getWife());
            if (this.filter.descendants) {
                this.collectDecendants(indis, fams, fam.getHusband());
                this.collectDecendants(indis, fams, fam.getWife());
            }
            if (!this.filter.ancestors) continue;
            this.collectAncestors(indis, fams, fam.getHusband());
            this.collectAncestors(indis, fams, fam.getWife());
        }
        for (Indi indi : gedcom.getIndis()) {
            value = indi.getPropertyValue(this.filter.tag);
            if (value == null || !value.contains(this.filter.content)) continue;
            indis.add(indi);
            for (Fam fam : indi.getFamiliesWhereSpouse()) {
                fams.add(fam);
            }
            if (this.filter.descendants) {
                this.collectDecendants(indis, fams, indi);
            }
            if (!this.filter.descendants) continue;
            this.collectAncestors(indis, fams, indi);
        }
        indis.remove(null);
        this.generateReport(fams, indis);
    }

    public void start(Indi indi) throws IOException {
        HashSet<Indi> indis = new HashSet<Indi>();
        HashSet<Fam> fams = new HashSet<Fam>();
        this.buildCollections(indi, indis, fams);
        this.generateReport(fams, indis);
    }

    public void start(Fam fam) throws IOException {
        HashSet<Indi> indis = new HashSet<Indi>();
        HashSet<Fam> fams = new HashSet<Fam>();
        this.buildCollections(fam.getHusband(), indis, fams);
        this.buildCollections(fam.getWife(), indis, fams);
        this.generateReport(fams, indis);
    }

    private void buildCollections(Indi indi, Collection<Indi> indis, Collection<Fam> fams) throws FileNotFoundException, IOException {
        this.collectAncestors(indis, fams, indi);
        this.collectDecendants(indis, fams, indi);
    }

    private void collectAncestors(Collection<Indi> indis, Collection<Fam> fams, Indi indi) {
        if (indi == null) {
            return;
        }
        indis.add(indi);
        for (Fam fam : indi.getFamiliesWhereChild()) {
            fams.add(fam);
            this.collectAncestors(indis, fams, fam.getHusband());
            this.collectAncestors(indis, fams, fam.getWife());
        }
    }

    private void collectDecendants(Collection<Indi> indis, Collection<Fam> fams, Indi indi) {
        if (indi == null) {
            return;
        }
        indis.add(indi);
        for (Fam fam : indi.getFamiliesWhereSpouse()) {
            indis.add(fam.getHusband());
            indis.add(fam.getWife());
            fams.add(fam);
            for (Indi child : fam.getChildren()) {
                this.collectDecendants(indis, fams, child);
            }
        }
    }

    private void generateReport(Collection<Fam> families, Collection<Indi> indis) throws FileNotFoundException, IOException {
        this.println(MessageFormat.format("{0} persons {1} families", indis.size(), families.size()));
        List<Indi> sortedIndis = this.sortByAge(indis);
        Writer out = this.createWriter();
        if (out == null) {
            return;
        }
        this.println("creating: " + this.reportFile.getAbsoluteFile());
        out.write(this.XML_HEAD + "\n");
        for (Indi indi : sortedIndis) {
            out.write(this.createNode(indi) + "\n");
        }
        for (Fam fam : families) {
            out.write(this.createNode(fam) + "\n");
        }
        for (Indi indi : sortedIndis) {
            out.write(this.createIndiToFam(indi, families) + "\n");
            out.write(this.createFamToIndi(indi, families) + "\n");
        }
        out.write(this.XML_TAIL + "\n");
        out.flush();
        out.close();
        this.println("ready");
    }

    private List<Indi> sortByAge(Collection<Indi> indis) {
        ArrayList<Indi> sortedIndis = new ArrayList<Indi>(indis);
        Collections.sort(sortedIndis, new Comparator<Indi>(){

            @Override
            public int compare(Indi i1, Indi i2) {
                Delta p2;
                Delta p1 = i1.getAge(pit);
                if (p1 == (p2 = i2.getAge(pit))) {
                    return 0;
                }
                if (p1 == null) {
                    return 1;
                }
                if (p2 == null) {
                    return -1;
                }
                return -p1.compareTo(p2);
            }
        });
        return sortedIndis;
    }

    private static String[] createIndiColors() {
        String[] result = new String[3];
        result[1] = "#CCCCFF";
        result[2] = "#FF99CC";
        result[0] = "#CCCCCC";
        return result;
    }

    private String createIndiToFam(Indi indi, Collection<Fam> families) {
        String s = "";
        for (Fam fam : indi.getFamiliesWhereSpouse()) {
            if (!families.contains(fam)) continue;
            s = s + MessageFormat.format(this.XML_EDGE, this.edgeCount++, indi.getId(), fam.getId());
        }
        return s;
    }

    private String createFamToIndi(Indi indi, Collection<Fam> families) {
        String s = "";
        for (Fam fam : indi.getFamiliesWhereChild()) {
            if (!families.contains(fam)) continue;
            s = s + MessageFormat.format(this.XML_EDGE, this.edgeCount++, fam.getId(), indi.getId());
        }
        return s;
    }

    private String createNode(Fam family) {
        String id = family.getId();
        String label = this.createLabel(family);
        String height = label.contains("<html>") ? "42.0" : "27.0";
        return MessageFormat.format(this.XML_FAMILY, id, this.escape(label), this.links.format(id, this.links.family), this.createPopUpContainer(label), height);
    }

    private String createNode(Indi indi) {
        String id = indi.getId();
        String label = this.createLabel(indi);
        return MessageFormat.format(this.XML_INDI, id, this.escape(label), this.links.format(id, this.links.indi), INDI_COLORS[indi.getSex()], this.createPopUpContainer(label));
    }

    private String createLabel(Fam family) {
        String image = this.images.format((Entity)family, this.images.famImage);
        String mariage = this.events.format(ReportForYEd.OPTIONS.getMarriageSymbol(), (PropertyEvent)family.getProperty("MARR"));
        String divorce = this.events.format(ReportForYEd.OPTIONS.getDivorceSymbol(), (PropertyEvent)family.getProperty("DIV"));
        if (mariage.equals("") && divorce.equals("") && image == null) {
            return "";
        }
        String format = image != null ? "<html><table><tr><td><p>{0}<br>{1}</p></td><td>{2}</td></tr></table></body></html>" : (divorce.equals("") || mariage.equals("") ? "{0}{1}" : "<html><body>{0}<br>{1}</body></html>");
        return this.wrap(format, mariage, divorce, image);
    }

    private String createLabel(Indi indi) {
        String image = this.images.format((Entity)indi, this.images.indiImage);
        String sex = this.gender.format(indi);
        String name = indi.getPropertyDisplayValue("NAME");
        String occu = indi.getPropertyDisplayValue("OCCU");
        String birth = this.events.format(ReportForYEd.OPTIONS.getBirthSymbol(), (PropertyEvent)indi.getProperty("BIRT"));
        String death = this.events.format(ReportForYEd.OPTIONS.getDeathSymbol(), (PropertyEvent)indi.getProperty("DEAT"));
        String format = image != null ? "<html><table><tr><td>{5}<p>{0}<br>{1}<br>{2}<br>{3}</p></td><td>{4}</td></tr></table></body></html>" : (this.showOccupation && occu != null && !occu.trim().equals("") ? "<html><body>{5}<p>{0}<br>{1}<br>{2}<br>{3}</p></body></html>" : (!birth.equals("") || !death.equals("") ? "<html><body>{5}<p>{0}<br>{1}<br>{2}</p></body></html>" : (!sex.equals("") ? "<html><body>{5}<p>{0}</p></body></html>" : "{0}")));
        return this.wrap(format, name, birth, death, occu, image, sex);
    }

    private String wrap(String format, Object ... args) {
        return MessageFormat.format(format, args).replaceAll("'", "\"");
    }

    private String escape(String content) {
        return content.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;");
    }

    private String createPopUpContainer(String content) {
        if (content == null) {
            return "";
        }
        return MessageFormat.format(this.XML_POPUP_CONTAINER, content);
    }

    private String getString(String key) {
        return this.getResources().getString(key);
    }

    private Writer createWriter() throws FileNotFoundException {
        String extension = "graphml";
        this.reportFile = this.getFileFromUser(this.translate("name"), this.translate("save"), true, "graphml");
        if (this.reportFile == null) {
            return null;
        }
        if (!this.reportFile.getName().toLowerCase().endsWith(".graphml")) {
            this.reportFile = new File(this.reportFile.getPath() + "." + "graphml");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.reportFile);
        OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF8"));
        return new BufferedWriter(streamWriter);
    }

    public class Links {
        public String indi;
        public String family;

        public Links() {
            this.indi = ReportForYEd.this.translate("indiUrlDefault");
            this.family = ReportForYEd.this.translate("familyUrlDefault");
        }

        private String format(String id, String urlFormat) {
            if (urlFormat == null) {
                return "";
            }
            String link = MessageFormat.format(urlFormat, id);
            return MessageFormat.format(ReportForYEd.this.XML_LINK_CONTAINER, link);
        }
    }

    public class Filter {
        public String tag = "_YED";
        public String content = "";
        public boolean active = true;
        public boolean descendants = true;
        public boolean ancestors = true;
    }

    public class Images {
        public String famImage;
        public String indiImage;
        public String imageExtensions;

        public Images() {
            this.famImage = ReportForYEd.this.translate("imageSnippetDefault");
            this.indiImage = ReportForYEd.this.translate("imageSnippetDefault");
            this.imageExtensions = "jpg jpeg gif png";
        }

        private String format(Entity entity, String htmlFormat) {
            Property property;
            if (htmlFormat == null || htmlFormat.equals("")) {
                return null;
            }
            Property property2 = property = entity instanceof Indi ? entity.getPropertyByPath("INDI:OBJE:FILE") : entity.getPropertyByPath("FAM:OBJE:FILE");
            if (property == null) {
                return null;
            }
            String value = property.getValue();
            if (value == null || value.equals("")) {
                return null;
            }
            String extension = value.toLowerCase().replaceAll(".*\\.", "");
            if (this.imageExtensions.contains(extension)) {
                return MessageFormat.format(htmlFormat, value);
            }
            return null;
        }
    }

    public class Gender {
        public String unknown = "";
        public String male = "\u2642";
        public String female = "\u2640";
        private final String[] snippets = new String[3];

        public Gender() {
            this.snippets[0] = this.unknown;
            this.snippets[1] = this.male;
            this.snippets[2] = this.female;
        }

        private String format(Indi indi) {
            return this.snippets[indi.getSex()];
        }
    }

    public class Events {
        public boolean showDates = true;
        public boolean showPlaces = true;
        public String place_display_format = "";

        private String format(String symbol, PropertyEvent event) {
            if (event == null || !this.showDates && !this.showPlaces) {
                return "";
            }
            PropertyDate date = event.getDate(true);
            Property place = event.getProperty("PLAC");
            if (date == null && place == null) {
                return "";
            }
            String string = (date == null || !this.showDates ? "" : date.getDisplayValue()) + " " + (place == null || !this.showPlaces ? "" : place.format(this.place_display_format).replaceAll("^(,|(, ))*", "").trim());
            if (string.trim().equals("")) {
                return "";
            }
            return symbol + " " + string;
        }
    }
}

