/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import ancestris.reports.ReportRelatives;
import ancestris.util.swing.DialogManager;
import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.io.input.FileInput;
import genj.report.Report;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

public class ReportSummaryOfRecords
extends Report {
    private static final TagPath PATH2IMAGES = new TagPath("INDI:OBJE:FILE");
    public int generatePlaceIndex = 0;
    public String[] generatePlaceIndexs = new String[]{this.translate("place.index.none"), this.translate("place.index.one"), this.translate("place.index.each")};
    private int maxImagesPerRecord = 4;
    public boolean includeIds = true;
    public boolean sortProperties = false;
    public String filterProperties = "CHAN";

    public int getMaxImagesPerRecord() {
        return this.maxImagesPerRecord;
    }

    public void setMaxImagesPerRecord(int set) {
        this.maxImagesPerRecord = Math.max(0, set);
    }

    public Document start(Gedcom gedcom) {
        Indi indi;
        Document doc = new Document(this.translate("title", new Object[]{gedcom.getName()}));
        doc.addText(this.translate("outputHeader") + ": " + gedcom.getName());
        Pattern tagFilter = null;
        try {
            if (this.filterProperties.length() > 0) {
                tagFilter = Pattern.compile(this.filterProperties);
            }
        }
        catch (IllegalArgumentException e) {
            this.println("Filter for properties is not a valid regular expression (" + e.getMessage() + ")");
        }
        ArrayList<Indi> searchResult = this.getSearchEntities(gedcom);
        if (searchResult.isEmpty() && (indi = this.getActiveIndi(gedcom)) != null) {
            List<Indi> relatives = new ReportRelatives().getRelatives(indi);
            searchResult = new ArrayList<Indi>(relatives);
        }
        if (searchResult.size() > 1000 && DialogManager.OK_OPTION != DialogManager.create((String)this.translate("TITL_SizeWarning"), (String)this.translate("MSG_SizeWarning", new Object[]{searchResult.size()})).setMessageType(2).setOptionType(2).setDialogId("report.SummaryOfRecords").show()) {
            return doc;
        }
        this.exportEntities(searchResult.toArray(new Entity[searchResult.size()]), doc, tagFilter);
        doc.nextPage();
        return doc;
    }

    private void exportEntities(Entity[] ents, Document doc, Pattern tagFilter) {
        for (int e = 0; e < ents.length; ++e) {
            this.exportEntity(ents[e], doc, tagFilter);
        }
    }

    private void exportEntity(Entity ent, Document doc, Pattern tagFilter) {
        this.println(this.translate("exporting", new Object[]{ent.toString()}));
        doc.startSection(ent.toString(this.includeIds), ent.getAnchor());
        doc.startTable("width=100%");
        doc.addTableColumn("column-width=80%");
        doc.addTableColumn("column-width=20%");
        this.exportProperties((Property)ent, doc, tagFilter, 0);
        doc.nextTableCell();
        Property[] files = ent.getProperties(PATH2IMAGES);
        for (int f = 0; f < files.length && f < this.maxImagesPerRecord; ++f) {
            PropertyFile file = (PropertyFile)files[f];
            Optional input = file.getInput();
            if (!input.isPresent() || !(input.get() instanceof FileInput)) continue;
            doc.addImage(((FileInput)input.get()).getFile(), "");
        }
        doc.endTable();
    }

    private void exportProperties(Property of, Document doc, Pattern tagFilter, int level) {
        if (of.getNoOfProperties() == 0) {
            return;
        }
        doc.startList();
        Property[] props = of.getProperties();
        if (this.sortProperties) {
            Arrays.sort(props, new Comparator<Property>(){

                @Override
                public int compare(Property p1, Property p2) {
                    return Gedcom.getName((String)p1.getTag()).compareTo(Gedcom.getName((String)p2.getTag()));
                }
            });
        }
        for (int i = 0; i < props.length; ++i) {
            PropertyXRef xref;
            Property prop = props[i];
            if (tagFilter != null && tagFilter.matcher(prop.getTag()).matches() || prop instanceof PropertyXRef && ((xref = (PropertyXRef)prop).isTransient() || !(xref.getTargetEntity() instanceof Indi) && !(xref.getTargetEntity() instanceof Fam) && !(xref.getTargetEntity() instanceof Note))) continue;
            doc.nextListItem();
            if (prop instanceof PropertyName) {
                PropertyName name = (PropertyName)prop;
                doc.addIndexTerm(this.translate("index.names"), name.getLastName(), name.getFirstName());
            }
            if (this.generatePlaceIndex > 0 && prop instanceof PropertyPlace) {
                String index = this.generatePlaceIndex == 1 ? this.translate("index.places") : this.translate("index.places.of", new Object[]{prop.getParent().getPropertyName()});
                doc.addIndexTerm(index, ((PropertyPlace)prop).getCity());
            }
            String format = "";
            if (level == 0) {
                format = "font-weight=bold";
            }
            if (level == 1) {
                format = "font-style=italic";
            }
            doc.addText(Gedcom.getName((String)prop.getTag()), format);
            doc.addText(" ");
            this.exportPropertyValue(prop, doc);
            this.exportProperties(prop, doc, tagFilter, level + 1);
        }
        doc.endList();
    }

    private void exportPropertyValue(Property prop, Document doc) {
        if (prop instanceof PropertyXRef) {
            PropertyXRef xref = (PropertyXRef)prop;
            Entity ent = xref.getTargetEntity();
            doc.addLink(ent.toString(this.includeIds), ent.getAnchor());
            return;
        }
        if (prop instanceof MultiLineProperty) {
            MultiLineProperty.Iterator lines = ((MultiLineProperty)prop).getLineIterator();
            do {
                doc.addText(lines.getValue());
            } while (lines.next());
            return;
        }
        String value = prop instanceof PropertyName ? ((PropertyName)prop).getDisplayValue() : prop.getDisplayValue();
        doc.addText(value);
    }
}

