/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import ancestris.api.editor.AncestrisEditor;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.modules.editors.gedcom.GedcomTopComponent;
import ancestris.view.SelectionDispatcher;
import genj.edit.actions.CreateParent;
import genj.edit.actions.CreateSpouse;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class GedcomEditorAction
extends AncestrisEditor {
    private ImageIcon editorIcon = new ImageIcon(GedcomEditorAction.class.getResource("Editor.png"));

    public boolean canEdit(Property property) {
        return true;
    }

    public boolean isActive() {
        return true;
    }

    public Property edit(Property property, boolean isNew) {
        Context contextToOpen = property == null ? (Context)Utilities.actionsGlobalContext().lookup(Context.class) : new Context(property);
        if (contextToOpen != null) {
            GedcomTopComponent editTopComponent = this.getCurrentEditorTopComponent(contextToOpen);
            if (editTopComponent != null) {
                SelectionDispatcher.fireSelection((Context)contextToOpen);
                editTopComponent.requestActive();
            } else {
                editTopComponent = new GedcomTopComponent();
                editTopComponent.init(contextToOpen);
                editTopComponent.open();
                editTopComponent.requestActive();
            }
        }
        return null;
    }

    public Property add(Property parent) {
        return null;
    }

    public String getName(boolean canonical) {
        if (canonical) {
            return ((Object)((Object)this)).getClass().getCanonicalName();
        }
        return NbBundle.getMessage(GedcomTopComponent.class, (String)"OpenIDE-Module-Name");
    }

    public ImageIcon getIcon() {
        return this.editorIcon;
    }

    public String toString() {
        return this.getName(false);
    }

    public Action getCreateParentAction(Indi indi, int sex) {
        return new CreateParent((Entity)indi, sex);
    }

    public Action getCreateSpouseAction(Indi indi) {
        return new CreateSpouse(indi);
    }

    private GedcomTopComponent getCurrentEditorTopComponent(Context context) {
        GedcomTopComponent ret = null;
        for (GedcomTopComponent editTopComponent : (List)AncestrisPlugin.lookupAll(GedcomTopComponent.class)) {
            Context tmpContext = editTopComponent.getContext();
            if (tmpContext == null || tmpContext.getGedcom() != context.getGedcom()) continue;
            return editTopComponent;
        }
        return ret;
    }
}

