/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.document.view;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.resources.Images;
import ancestris.modules.document.view.AbstractDocumentView;
import ancestris.util.swing.FileChooserBuilder;
import ancestris.view.SelectionDispatcher;
import genj.fo.Document;
import genj.fo.Format;
import genj.fo.HTMLFormat;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class FopDocumentView
extends AbstractDocumentView {
    private File tempfile = null;
    private Document document = null;
    private Preferences preferences = null;
    private JEditorPane editorPane = new JEditorPane();
    private Runnable runnable = null;

    public FopDocumentView(Context context, String title, String tooltip) {
        super(context, title, tooltip);
        this.editorPane.setEditable(false);
        this.editorPane.setName(title);
        this.setView(this.editorPane);
        this.setToolbarActions(new Action[]{new ActionSave()});
    }

    public void displayDocument(Document doc, Preferences preferences) {
        HTMLFormat htmlFormatter = new HTMLFormat();
        this.document = doc;
        this.preferences = preferences;
        try {
            this.tempfile = File.createTempFile("name", ".html");
            htmlFormatter.format(this.document, this.tempfile);
            this.editorPane.setPage(this.tempfile.toURI().toURL());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.editorPane.addHyperlinkListener(new Hyperactive());
    }

    @Override
    protected void closeNotify() {
        if (this.tempfile != null) {
            this.tempfile.delete();
            super.closeNotify();
        }
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public void executeOnClose(Runnable runnable) {
        this.runnable = runnable;
    }

    private static class Hyperactive
    implements HyperlinkListener {
        private Hyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    String description = e.getDescription();
                    if (description.contains("#INDI" + Entity.ID_DELIMITER_IN_ANCHOR) || description.contains("#FAM" + Entity.ID_DELIMITER_IN_ANCHOR) || description.contains("#SOUR" + Entity.ID_DELIMITER_IN_ANCHOR) || description.contains("#NOTE" + Entity.ID_DELIMITER_IN_ANCHOR) || description.contains("#REPO" + Entity.ID_DELIMITER_IN_ANCHOR) || description.contains("#OBJE" + Entity.ID_DELIMITER_IN_ANCHOR) || description.contains("#SUBM" + Entity.ID_DELIMITER_IN_ANCHOR) || description.contains("#HEAD" + Entity.ID_DELIMITER_IN_ANCHOR) || description.startsWith("#") && description.contains(Entity.ID_DELIMITER_IN_ANCHOR)) {
                        Gedcom myGedcom;
                        Context context = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
                        if (context != null && (myGedcom = context.getGedcom()) != null) {
                            int idxID = description.indexOf(Entity.ID_DELIMITER_IN_ANCHOR) + 1;
                            String tag = description.substring(1, idxID - 1);
                            String currentId = description.substring(idxID);
                            Entity entity = null;
                            if (currentId != null && !currentId.isEmpty()) {
                                entity = tag != null && !tag.isEmpty() ? myGedcom.getEntity(tag, currentId) : myGedcom.getEntity(currentId);
                            } else if (tag != null && !tag.isEmpty()) {
                                entity = myGedcom.getFirstEntity(tag);
                            }
                            if (entity != null) {
                                SelectionDispatcher.fireSelection((Context)new Context(entity));
                            }
                        }
                    } else {
                        try {
                            pane.setPage(e.getURL());
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private class ActionSave
    extends AbstractAncestrisAction {
        protected ActionSave() {
            this.setImage((Icon)Images.imgSave);
            this.setTip(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITL_SaveDocument", (Object)""));
        }

        public void actionPerformed(ActionEvent event) {
            File f = new File(FopDocumentView.this.document.getTitle());
            FileChooserBuilder fcb = new FileChooserBuilder(FopDocumentView.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITL_SaveDocument", (Object)FopDocumentView.this.document.getTitle())).setApproveText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"OK_Button")).setDefaultExtension(FileChooserBuilder.getPdfFilter().getExtensions()[0]).addFileFilter((FileFilter)FileChooserBuilder.getPdfFilter()).addFileFilter((FileFilter)FileChooserBuilder.getHtmlFilter()).addFileFilter((FileFilter)FileChooserBuilder.getCSVFilter()).setAcceptAllFileFilterUsed(false).setDefaultDirAsReportDirectory().setSelectedFile(f).setFileHiding(true);
            File file = fcb.showSaveDialog();
            if (file == null) {
                return;
            }
            Format formatter = Format.getFormatFromExtension((String)FileChooserBuilder.getExtension((String)file.getName()));
            try {
                file.getParentFile().mkdirs();
                formatter.format(FopDocumentView.this.document, file);
                String fileName = file.getCanonicalPath();
                if (!fileName.equals("")) {
                    FopDocumentView.this.preferences.put("documentFilename", fileName);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

