/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.editors.genealogyeditor.panels.IndividualsTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.NoteCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.SourceCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.utilities.PropertyTag2Name;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyRelationship;
import genj.util.swing.ChoiceWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AssociationEditorPanel
extends JPanel {
    private PropertyAssociation mAssociation;
    private Entity mIndividual;
    private String mEventTag = "";
    private Indi mAssociatedIndividual;
    private boolean mRelationModified = false;
    private final ChangeListner changeListner = new ChangeListner();
    private static final String[] INDIVIDUAL_EVENT_TAGS = new String[]{"", PropertyTag2Name.getTagName("BIRT"), PropertyTag2Name.getTagName("CHR"), PropertyTag2Name.getTagName("DEAT"), PropertyTag2Name.getTagName("BURI"), PropertyTag2Name.getTagName("CREM"), PropertyTag2Name.getTagName("ADOP"), PropertyTag2Name.getTagName("BAPM"), PropertyTag2Name.getTagName("BARM"), PropertyTag2Name.getTagName("BASM"), PropertyTag2Name.getTagName("BLES"), PropertyTag2Name.getTagName("CHRA"), PropertyTag2Name.getTagName("CONF"), PropertyTag2Name.getTagName("FCOM"), PropertyTag2Name.getTagName("ORDN"), PropertyTag2Name.getTagName("NATU"), PropertyTag2Name.getTagName("EMIG"), PropertyTag2Name.getTagName("IMMI"), PropertyTag2Name.getTagName("CENS"), PropertyTag2Name.getTagName("PROB"), PropertyTag2Name.getTagName("WILL"), PropertyTag2Name.getTagName("GRAD"), PropertyTag2Name.getTagName("RETI"), PropertyTag2Name.getTagName("EVEN"), PropertyTag2Name.getTagName("CAST"), PropertyTag2Name.getTagName("DSCR"), PropertyTag2Name.getTagName("EDUC"), PropertyTag2Name.getTagName("IDNO"), PropertyTag2Name.getTagName("NATI"), PropertyTag2Name.getTagName("NCHI"), PropertyTag2Name.getTagName("NMR"), PropertyTag2Name.getTagName("OCCU"), PropertyTag2Name.getTagName("PROP"), PropertyTag2Name.getTagName("RELI"), PropertyTag2Name.getTagName("RESI"), PropertyTag2Name.getTagName("SSN"), PropertyTag2Name.getTagName("TITL")};
    private final DefaultComboBoxModel<String> mEventsModel = new DefaultComboBoxModel<String>(INDIVIDUAL_EVENT_TAGS);
    private JTabbedPane associationTabbedPane;
    private JComboBox<String> eventTypeComboBox;
    private JLabel jLabel1;
    private JButton linkToIndividualButton;
    private NoteCitationsTablePanel noteCitationsTablePanel;
    private JPanel notesPanel;
    private JLabel referenceIndividualLabel;
    private JTextField referenceIndividualTextField;
    private ChoiceWidget relationChoiceWidget;
    private JLabel relationLabel;
    private SourceCitationsTablePanel sourceCitationsTablePanel;
    private JPanel sourcesPanel;

    public AssociationEditorPanel() {
        this.initComponents();
        this.relationChoiceWidget.addChangeListener((ChangeListener)this.changeListner);
    }

    private void initComponents() {
        this.referenceIndividualLabel = new JLabel();
        this.referenceIndividualTextField = new JTextField();
        this.linkToIndividualButton = new JButton();
        this.relationLabel = new JLabel();
        this.associationTabbedPane = new JTabbedPane();
        this.notesPanel = new JPanel();
        this.noteCitationsTablePanel = new NoteCitationsTablePanel();
        this.sourcesPanel = new JPanel();
        this.sourceCitationsTablePanel = new SourceCitationsTablePanel();
        this.relationChoiceWidget = new ChoiceWidget();
        this.eventTypeComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.referenceIndividualLabel, (String)NbBundle.getMessage(AssociationEditorPanel.class, (String)"AssociationEditorPanel.referenceIndividualLabel.text"));
        this.referenceIndividualTextField.setEditable(false);
        this.referenceIndividualTextField.setText(NbBundle.getMessage(AssociationEditorPanel.class, (String)"AssociationEditorPanel.referenceIndividualTextField.text"));
        this.linkToIndividualButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/link_add.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.linkToIndividualButton, (String)MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("AssociationEditorPanel.linkToIndividualButton.text"), new Object[0]));
        this.linkToIndividualButton.setFocusable(false);
        this.linkToIndividualButton.setHorizontalTextPosition(0);
        this.linkToIndividualButton.setMaximumSize(new Dimension(26, 26));
        this.linkToIndividualButton.setMinimumSize(new Dimension(26, 26));
        this.linkToIndividualButton.setPreferredSize(new Dimension(26, 26));
        this.linkToIndividualButton.setVerticalTextPosition(3);
        this.linkToIndividualButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationEditorPanel.this.linkToIndividualButtonActionPerformed(evt);
            }
        });
        this.relationLabel.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.relationLabel, (String)NbBundle.getMessage(AssociationEditorPanel.class, (String)"AssociationEditorPanel.relationLabel.text"));
        GroupLayout notesPanelLayout = new GroupLayout(this.notesPanel);
        this.notesPanel.setLayout(notesPanelLayout);
        notesPanelLayout.setHorizontalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, notesPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.noteCitationsTablePanel, -1, -1, Short.MAX_VALUE)));
        notesPanelLayout.setVerticalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, notesPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.noteCitationsTablePanel, -1, 162, Short.MAX_VALUE)));
        this.associationTabbedPane.addTab(NbBundle.getMessage(AssociationEditorPanel.class, (String)"AssociationEditorPanel.notesPanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/note.png")), this.notesPanel);
        GroupLayout sourcesPanelLayout = new GroupLayout(this.sourcesPanel);
        this.sourcesPanel.setLayout(sourcesPanelLayout);
        sourcesPanelLayout.setHorizontalGroup(sourcesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, sourcesPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.sourceCitationsTablePanel, -1, -1, Short.MAX_VALUE)));
        sourcesPanelLayout.setVerticalGroup(sourcesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, sourcesPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.sourceCitationsTablePanel, -1, 162, Short.MAX_VALUE)));
        this.associationTabbedPane.addTab(NbBundle.getMessage(AssociationEditorPanel.class, (String)"AssociationEditorPanel.sourcesPanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/source.png")), this.sourcesPanel);
        this.eventTypeComboBox.setModel(this.mEventsModel);
        this.eventTypeComboBox.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("AssociationEditorPanel.eventTypeComboBox.toolTipText"), new Object[0]));
        this.eventTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationEditorPanel.this.eventTypeComboBoxActionPerformed(evt);
            }
        });
        this.jLabel1.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AssociationEditorPanel.class, (String)"AssociationEditorPanel.jLabel1.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.associationTabbedPane, -1, 549, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.referenceIndividualLabel, -1, -1, Short.MAX_VALUE).addComponent(this.relationLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.linkToIndividualButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.referenceIndividualTextField)).addComponent((Component)this.relationChoiceWidget, -1, -1, Short.MAX_VALUE).addComponent(this.eventTypeComboBox, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.eventTypeComboBox, -2, 28, -2).addComponent(this.jLabel1)).addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.referenceIndividualLabel).addComponent(this.linkToIndividualButton, -2, 25, -2).addComponent(this.referenceIndividualTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.relationLabel).addComponent((Component)this.relationChoiceWidget, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.associationTabbedPane).addContainerGap()));
    }

    private void linkToIndividualButtonActionPerformed(ActionEvent evt) {
        IndividualsTablePanel individualsTablePanel = new IndividualsTablePanel();
        ArrayList<Indi> individualsList = new ArrayList<Indi>(this.mIndividual.getGedcom().getIndis());
        individualsTablePanel.set((Property)this.mAssociation, individualsList);
        individualsTablePanel.setToolBarVisible(false);
        DialogManager.ADialog individualsTableDialog = new DialogManager.ADialog(NbBundle.getMessage(IndividualsTablePanel.class, (String)"individualsTableDialog.title.select.husband"), (JComponent)individualsTablePanel);
        individualsTableDialog.setDialogId(IndividualsTablePanel.class.getName());
        if (individualsTableDialog.show() == DialogDescriptor.OK_OPTION) {
            this.mAssociatedIndividual = individualsTablePanel.getSelectedIndividual();
            this.referenceIndividualTextField.setText(this.mAssociatedIndividual.getName());
            this.referenceIndividualTextField.setVisible(true);
            this.linkToIndividualButton.setVisible(false);
            this.mRelationModified = true;
        }
    }

    private void eventTypeComboBoxActionPerformed(ActionEvent evt) {
        String eventName = this.eventTypeComboBox.getSelectedItem().toString();
        this.mEventTag = PropertyTag2Name.getPropertyTag(eventName);
    }

    void set(Entity individual, PropertyAssociation association, Property event) {
        this.mIndividual = individual;
        if (event != null) {
            this.mEventTag = event.getTag();
            this.eventTypeComboBox.setEnabled(false);
        }
        this.eventTypeComboBox.setSelectedItem(PropertyTag2Name.getTagName(this.mEventTag));
        this.relationChoiceWidget.setValues(this.mIndividual.getGedcom().getReferenceSet("RELA").getKeys());
        this.changeListner.mute();
        this.mAssociation = association;
        Entity targetEntity = association.getTargetEntity();
        if (targetEntity != null) {
            this.linkToIndividualButton.setVisible(false);
            this.referenceIndividualTextField.setText(((Indi)targetEntity).getName());
            this.referenceIndividualTextField.setVisible(true);
        } else {
            this.referenceIndividualTextField.setVisible(false);
        }
        PropertyRelationship propertyRelationship = (PropertyRelationship)association.getProperty("RELA", false);
        if (propertyRelationship != null) {
            this.relationChoiceWidget.setText(propertyRelationship.getDisplayValue());
        }
        this.noteCitationsTablePanel.set((Property)association, Arrays.asList(association.getProperties("NOTE")));
        this.sourceCitationsTablePanel.set((Property)association, Arrays.asList(association.getProperties("SOUR")));
        this.changeListner.unmute();
    }

    PropertyAssociation commit() {
        if (this.mRelationModified) {
            PropertyRelationship propertyRelationship;
            if (this.mAssociatedIndividual != null) {
                this.mAssociation.setValue('@' + this.mAssociatedIndividual.getId() + '@');
                try {
                    this.mAssociation.link();
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if ((propertyRelationship = (PropertyRelationship)this.mAssociation.getProperty("RELA", false)) == null) {
                this.mAssociation.addProperty("RELA", this.relationChoiceWidget.getText() + (!this.mEventTag.isEmpty() ? "@INDI:" + this.mEventTag : ""));
            } else {
                propertyRelationship.setValue(this.relationChoiceWidget.getText());
            }
        }
        return this.mAssociation;
    }

    private class ChangeListner
    implements ChangeListener {
        private boolean mute = false;

        private ChangeListner() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            if (!this.mute) {
                AssociationEditorPanel.this.mRelationModified = true;
            }
        }

        public void mute() {
            this.mute = true;
        }

        public void unmute() {
            this.mute = false;
        }
    }
}

