/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.editors.genealogyeditor.AriesTopComponent;
import ancestris.modules.editors.genealogyeditor.editors.SourceEditor;
import ancestris.modules.editors.genealogyeditor.models.SourcesTableModel;
import ancestris.modules.editors.genealogyeditor.table.EditorTable;
import ancestris.modules.editors.genealogyeditor.utilities.AriesFilterPanel;
import ancestris.modules.editors.genealogyeditor.utilities.FilterToolBar;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Source;
import genj.gedcom.UnitOfWork;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.PatternSyntaxException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.openide.util.Exceptions;

public class SourcesTablePanel
extends JPanel
implements AriesFilterPanel {
    private final Gedcom mGedcom;
    private final SourcesTableModel mSourcesTableModel = new SourcesTableModel();
    private Source mSource;
    private final TableRowSorter<TableModel> sourceTableSorter;
    private JButton addSourceButton;
    private JButton deleteSourceButton;
    private JButton editSourceButton;
    private FilterToolBar filterToolBar;
    private JToolBar jToolBar1;
    private EditorTable sourcesTable;
    private JScrollPane sourcesTableScrollPane;
    private JToolBar sourcesToolBar;

    public SourcesTablePanel(Gedcom gedcom) {
        this.mGedcom = gedcom;
        this.initComponents();
        this.sourcesTable.setID(SourcesTablePanel.class.getName());
        this.mSourcesTableModel.addAll(gedcom.getEntities("SOUR"));
        this.sourceTableSorter = new TableRowSorter<TableModel>(this.sourcesTable.getModel());
        this.sourcesTable.setRowSorter(this.sourceTableSorter);
        if (this.mSourcesTableModel.getRowCount() > 0) {
            this.editSourceButton.setEnabled(true);
            this.deleteSourceButton.setEnabled(true);
        } else {
            this.editSourceButton.setEnabled(false);
            this.deleteSourceButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.sourcesToolBar = new JToolBar();
        this.addSourceButton = new JButton();
        this.editSourceButton = new JButton();
        this.deleteSourceButton = new JButton();
        this.filterToolBar = new FilterToolBar(this);
        this.sourcesTableScrollPane = new JScrollPane();
        this.sourcesTable = new EditorTable();
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.sourcesToolBar.setFloatable(false);
        this.sourcesToolBar.setRollover(true);
        this.addSourceButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        this.addSourceButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("SourcesTablePanel.addSourceButton.toolTipText"), new Object[0]));
        this.addSourceButton.setFocusable(false);
        this.addSourceButton.setHorizontalTextPosition(0);
        this.addSourceButton.setVerticalTextPosition(3);
        this.addSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourcesTablePanel.this.addSourceButtonActionPerformed(evt);
            }
        });
        this.sourcesToolBar.add(this.addSourceButton);
        this.editSourceButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit.png")));
        this.editSourceButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("SourcesTablePanel.editSourceButton.toolTipText"), new Object[0]));
        this.editSourceButton.setFocusable(false);
        this.editSourceButton.setHorizontalTextPosition(0);
        this.editSourceButton.setVerticalTextPosition(3);
        this.editSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourcesTablePanel.this.editSourceButtonActionPerformed(evt);
            }
        });
        this.sourcesToolBar.add(this.editSourceButton);
        this.deleteSourceButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.deleteSourceButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("SourcesTablePanel.deleteSourceButton.toolTipText"), new Object[0]));
        this.deleteSourceButton.setFocusable(false);
        this.deleteSourceButton.setHorizontalTextPosition(0);
        this.deleteSourceButton.setVerticalTextPosition(3);
        this.deleteSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourcesTablePanel.this.deleteSourceButtonActionPerformed(evt);
            }
        });
        this.sourcesToolBar.add(this.deleteSourceButton);
        this.jToolBar1.add(this.sourcesToolBar);
        this.jToolBar1.add(this.filterToolBar);
        this.sourcesTable.setModel(this.mSourcesTableModel);
        this.sourcesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SourcesTablePanel.this.sourcesTableMouseClicked(evt);
            }
        });
        this.sourcesTableScrollPane.setViewportView(this.sourcesTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourcesTableScrollPane, -1, 539, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, -1, -2).addGap(5, 5, 5).addComponent(this.sourcesTableScrollPane, -1, 153, Short.MAX_VALUE)));
    }

    private void addSourceButtonActionPerformed(ActionEvent evt) {
        int undoNb = this.mGedcom.getUndoNb();
        try {
            this.mGedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    SourcesTablePanel.this.mSource = (Source)gedcom.createEntity("SOUR");
                }
            });
            SourceEditor sourceEditor = new SourceEditor();
            sourceEditor.setContext(new Context((Entity)this.mSource));
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(this.mGedcom);
            atc.getOpenEditors().add(sourceEditor);
            if (sourceEditor.showPanel()) {
                this.mSourcesTableModel.add(this.mSource);
                this.editSourceButton.setEnabled(true);
                this.deleteSourceButton.setEnabled(true);
            } else {
                while (this.mGedcom.getUndoNb() > undoNb && this.mGedcom.canUndo()) {
                    this.mGedcom.undoUnitOfWork(false);
                }
            }
            atc.getOpenEditors().remove((Object)sourceEditor);
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void editSourceButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.sourcesTable.getSelectedRow();
        if (selectedRow != -1) {
            int rowIndex = this.sourcesTable.convertRowIndexToModel(selectedRow);
            int undoNb = this.mGedcom.getUndoNb();
            Source source = this.mSourcesTableModel.getValueAt(rowIndex);
            SourceEditor sourceEditor = new SourceEditor();
            sourceEditor.setContext(new Context((Entity)source));
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(this.mGedcom);
            atc.getOpenEditors().add(sourceEditor);
            if (sourceEditor.showPanel()) {
                this.mSourcesTableModel.add(source);
            } else {
                while (this.mGedcom.getUndoNb() > undoNb && this.mGedcom.canUndo()) {
                    this.mGedcom.undoUnitOfWork(false);
                }
            }
            atc.getOpenEditors().remove((Object)sourceEditor);
        }
    }

    private void deleteSourceButtonActionPerformed(ActionEvent evt) {
        final int selectedRow = this.sourcesTable.getSelectedRow();
        if (selectedRow != -1) {
            try {
                this.mGedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        int rowIndex = SourcesTablePanel.this.sourcesTable.convertRowIndexToModel(selectedRow);
                        SourcesTablePanel.this.mGedcom.deleteEntity((Entity)SourcesTablePanel.this.mSourcesTableModel.remove(rowIndex));
                    }
                });
                if (this.mSourcesTableModel.getRowCount() <= 0) {
                    this.editSourceButton.setEnabled(false);
                    this.deleteSourceButton.setEnabled(false);
                }
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void sourcesTableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            int selectedRow = this.sourcesTable.getSelectedRow();
            int undoNb = this.mGedcom.getUndoNb();
            if (selectedRow != -1) {
                int rowIndex = this.sourcesTable.convertRowIndexToModel(selectedRow);
                SourceEditor sourceEditor = new SourceEditor();
                Source source = this.mSourcesTableModel.getValueAt(rowIndex);
                sourceEditor.setContext(new Context((Entity)source));
                AriesTopComponent atc = AriesTopComponent.findEditorWindow(this.mGedcom);
                atc.getOpenEditors().add(sourceEditor);
                if (!sourceEditor.showPanel()) {
                    while (this.mGedcom.getUndoNb() > undoNb && this.mGedcom.canUndo()) {
                        this.mGedcom.undoUnitOfWork(false);
                    }
                }
                atc.getOpenEditors().remove((Object)sourceEditor);
            }
        }
    }

    public Source getSelectedSource() {
        int selectedRow = this.sourcesTable.getSelectedRow();
        if (selectedRow != -1) {
            int rowIndex = this.sourcesTable.convertRowIndexToModel(selectedRow);
            return this.mSourcesTableModel.getValueAt(rowIndex);
        }
        return null;
    }

    public void setToolBarVisible(boolean b) {
        this.sourcesToolBar.setVisible(b);
    }

    @Override
    public ComboBoxModel<String> getComboBoxModel() {
        return new DefaultComboBoxModel<String>(this.mSourcesTableModel.getColumnsName());
    }

    @Override
    public void filter(int index, String searchFilter) {
        RowFilter rf;
        try {
            rf = RowFilter.regexFilter("(?i)" + searchFilter, index);
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.sourceTableSorter.setRowFilter(rf);
    }
}

