/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.j2dviewer.renderer.shape.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import org.graphstream.ui.geom.Point2;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.geom.Vector2;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.j2dviewer.Backend;
import org.graphstream.ui.j2dviewer.Camera;
import org.graphstream.ui.j2dviewer.renderer.ConnectorSkeleton;
import org.graphstream.ui.j2dviewer.renderer.Skeleton;
import org.graphstream.ui.j2dviewer.renderer.shape.Connector$class;
import org.graphstream.ui.j2dviewer.renderer.shape.Decorable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.HasSkel$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.AreaConnectorShape;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.AreaConnectorShape$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ConnectorShape$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Fillable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.IconAndText;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Shadowable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeDecor;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapePaint;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeStroke;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShowCubics;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShowCubics$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Strokable$class;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\u0001\u0003\u0001E\u0011\u0011B\u00117pENC\u0017\r]3\u000b\u0005\r!\u0011!B:xS:<'BA\u0003\u0007\u0003\u0015\u0019\b.\u00199f\u0015\t9\u0001\"\u0001\u0005sK:$WM]3s\u0015\tI!\"A\u0005ke\u00114\u0018.Z<fe*\u00111\u0002D\u0001\u0003k&T!!\u0004\b\u0002\u0017\u001d\u0014\u0018\r\u001d5tiJ,\u0017-\u001c\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0005\r\u001d!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u0011\u0011DG\u0007\u0002\u0005%\u00111D\u0001\u0002\u0013\u0003J,\u0017mQ8o]\u0016\u001cGo\u001c:TQ\u0006\u0004X\r\u0005\u0002\u001a;%\u0011aD\u0001\u0002\u000b'\"|woQ;cS\u000e\u001c\b\"\u0002\u0011\u0001\t\u0003\t\u0013A\u0002\u001fj]&$h\bF\u0001#!\tI\u0002\u0001C\u0004%\u0001\u0001\u0007I\u0011C\u0013\u0002\u0011QDWm\u00155ba\u0016,\u0012A\n\t\u0003OEr!\u0001K\u0018\u000e\u0003%R!AK\u0016\u0002\t\u001d,w.\u001c\u0006\u0003Y5\n1!Y<u\u0015\u0005q\u0013\u0001\u00026bm\u0006L!\u0001M\u0015\u0002\rA\u000bG\u000f\u001b\u001aE\u0013\t\u00114G\u0001\u0004E_V\u0014G.\u001a\u0006\u0003a%Bq!\u000e\u0001A\u0002\u0013Ea'\u0001\u0007uQ\u0016\u001c\u0006.\u00199f?\u0012*\u0017\u000f\u0006\u00028uA\u00111\u0003O\u0005\u0003sQ\u0011A!\u00168ji\"91\bNA\u0001\u0002\u00041\u0013a\u0001=%c!1Q\b\u0001Q!\n\u0019\n\u0011\u0002\u001e5f'\"\f\u0007/\u001a\u0011\t\u000b}\u0002A\u0011\u0003!\u0002\t5\f7.\u001a\u000b\u0004o\u0005;\u0005\"\u0002\"?\u0001\u0004\u0019\u0015a\u00012dWB\u0011A)R\u0007\u0002\u0011%\u0011a\t\u0003\u0002\b\u0005\u0006\u001c7.\u001a8e\u0011\u0015Ae\b1\u0001J\u0003\u0019\u0019\u0017-\\3sCB\u0011AIS\u0005\u0003\u0017\"\u0011aaQ1nKJ\f\u0007\"B \u0001\t#iECB\u001cO\u001fN+v\u000bC\u0003I\u0019\u0002\u0007\u0011\nC\u0003Q\u0019\u0002\u0007\u0011+A\u0002t_b\u0004\"a\u0005*\n\u0005I\"\u0002\"\u0002+M\u0001\u0004\t\u0016aA:ps\")a\u000b\u0014a\u0001#\u0006\u00191o\u001e=\t\u000bac\u0005\u0019A)\u0002\u0007M<\u0018\u0010C\u0003[\u0001\u0011E1,\u0001\u0006nC.,wJ\u001c'j]\u0016$ba\u000e/^=~\u0003\u0007\"\u0002%Z\u0001\u0004I\u0005\"\u0002)Z\u0001\u0004\t\u0006\"\u0002+Z\u0001\u0004\t\u0006\"\u0002,Z\u0001\u0004\t\u0006\"\u0002-Z\u0001\u0004\t\u0006\"\u00022\u0001\t#\u0019\u0017AD7bW\u0016|e\u000eU8ms2Lg.\u001a\u000b\u0007o\u0011,gm\u001a5\t\u000b!\u000b\u0007\u0019A%\t\u000bA\u000b\u0007\u0019A)\t\u000bQ\u000b\u0007\u0019A)\t\u000bY\u000b\u0007\u0019A)\t\u000ba\u000b\u0007\u0019A)\t\u000b)\u0004A\u0011C6\u0002\u00175\f7.Z(o\u0007V\u0014h/\u001a\u000b\u0007o1lgn\u001c9\t\u000b!K\u0007\u0019A%\t\u000bAK\u0007\u0019A)\t\u000bQK\u0007\u0019A)\t\u000bYK\u0007\u0019A)\t\u000baK\u0007\u0019A)\t\u000bI\u0004A\u0011C:\u0002\u00135\f7.Z'vYRLGCB\u001cukZ<\b\u0010C\u0003Ic\u0002\u0007\u0011\nC\u0003Qc\u0002\u0007\u0011\u000bC\u0003Uc\u0002\u0007\u0011\u000bC\u0003Wc\u0002\u0007\u0011\u000bC\u0003Yc\u0002\u0007\u0011\u000bC\u0003{\u0001\u0011E10\u0001\u0005nC.,Gj\\8q)\u001d9D0 @\u0000\u0003\u0003AQ\u0001S=A\u0002%CQ\u0001U=A\u0002ECQ\u0001V=A\u0002ECQAV=A\u0002ECQ\u0001W=A\u0002ECq!!\u0002\u0001\t#\t9!\u0001\u0006nC.,7\u000b[1e_^$RaNA\u0005\u0003\u0017AaAQA\u0002\u0001\u0004\u0019\u0005B\u0002%\u0002\u0004\u0001\u0007\u0011\nC\u0004\u0002\u0010\u0001!\t!!\u0005\u0002\u0019I,g\u000eZ3s'\"\fGm\\<\u0015\u0013]\n\u0019\"!\u0006\u0002\u0018\u0005\u001d\u0002B\u0002\"\u0002\u000e\u0001\u00071\t\u0003\u0004I\u0003\u001b\u0001\r!\u0013\u0005\t\u00033\ti\u00011\u0001\u0002\u001c\u00059Q\r\\3nK:$\b\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005\"\"\u0001\u0007he\u0006\u0004\b.[2He\u0006\u0004\b.\u0003\u0003\u0002&\u0005}!AD$sCBD\u0017nY#mK6,g\u000e\u001e\u0005\t\u0003S\ti\u00011\u0001\u0002,\u0005!1o[3m!\u0011\ti#a\f\u000e\u0003\u0019I1!!\r\u0007\u0005!\u00196.\u001a7fi>t\u0007bBA\u001b\u0001\u0011\u0005\u0011qG\u0001\u0007e\u0016tG-\u001a:\u0015\u0013]\nI$a\u000f\u0002>\u0005}\u0002B\u0002\"\u00024\u0001\u00071\t\u0003\u0004I\u0003g\u0001\r!\u0013\u0005\t\u00033\t\u0019\u00041\u0001\u0002\u001c!A\u0011\u0011FA\u001a\u0001\u0004\tY\u0003")
public class BlobShape
implements AreaConnectorShape,
ShowCubics {
    private Path2D.Double theShape;
    private boolean showControlPolygon;
    private ShapePaint shadowPaint;
    private final Point2 theShadowWidth;
    private final Point2 theShadowOff;
    private Color strokeColor;
    private ShapeStroke theStroke;
    private double theStrokeWidth;
    private ShapePaint fillPaint;
    private double theFillPercent;
    private Color theFillColor;
    private boolean plainFast;
    private String text;
    private ShapeDecor theDecor;
    private GraphicEdge theEdge;
    private double theSize;
    private Point2 theTargetSize;
    private Point2 theSourceSize;
    private boolean isDirected;
    private ConnectorSkeleton skel;

    @Override
    public boolean showControlPolygon() {
        return this.showControlPolygon;
    }

    @Override
    @TraitSetter
    public void showControlPolygon_$eq(boolean x$1) {
        this.showControlPolygon = x$1;
    }

    @Override
    public void showCtrlPoints(Graphics2D g, Camera camera, ConnectorSkeleton skel) {
        ShowCubics$class.showCtrlPoints(this, g, camera, skel);
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$AreaConnectorShape$$super$configureForGroup(Backend bck, Style style, Camera camera) {
        ConnectorShape$class.configureForGroup(this, bck, style, camera);
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$AreaConnectorShape$$super$configureForElement(Backend bck, GraphicElement element, Skeleton skel, Camera camera) {
        ConnectorShape$class.configureForElement(this, bck, element, skel, camera);
    }

    @Override
    public void configureForGroup(Backend bck, Style style, Camera camera) {
        AreaConnectorShape$class.configureForGroup(this, bck, style, camera);
    }

    @Override
    public void configureForElement(Backend bck, GraphicElement element, Skeleton skel, Camera camera) {
        AreaConnectorShape$class.configureForElement(this, bck, element, skel, camera);
    }

    @Override
    public ShapePaint shadowPaint() {
        return this.shadowPaint;
    }

    @Override
    public void shadowPaint_$eq(ShapePaint x$1) {
        this.shadowPaint = x$1;
    }

    @Override
    public Point2 theShadowWidth() {
        return this.theShadowWidth;
    }

    @Override
    public Point2 theShadowOff() {
        return this.theShadowOff;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$Shadowable$_setter_$theShadowWidth_$eq(Point2 x$1) {
        this.theShadowWidth = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$Shadowable$_setter_$theShadowOff_$eq(Point2 x$1) {
        this.theShadowOff = x$1;
    }

    @Override
    public void shadowWidth(double width, double height) {
        Shadowable$class.shadowWidth(this, width, height);
    }

    @Override
    public void shadowOffset(double xoff, double yoff) {
        Shadowable$class.shadowOffset(this, xoff, yoff);
    }

    @Override
    public void cast(Graphics2D g, Shape shape) {
        Shadowable$class.cast(this, g, shape);
    }

    @Override
    public void configureShadowableForGroup(Style style, Camera camera) {
        Shadowable$class.configureShadowableForGroup(this, style, camera);
    }

    @Override
    public Color strokeColor() {
        return this.strokeColor;
    }

    @Override
    public void strokeColor_$eq(Color x$1) {
        this.strokeColor = x$1;
    }

    @Override
    public ShapeStroke theStroke() {
        return this.theStroke;
    }

    @Override
    public void theStroke_$eq(ShapeStroke x$1) {
        this.theStroke = x$1;
    }

    @Override
    public double theStrokeWidth() {
        return this.theStrokeWidth;
    }

    @Override
    public void theStrokeWidth_$eq(double x$1) {
        this.theStrokeWidth = x$1;
    }

    @Override
    public void stroke(Graphics2D g, Shape shape) {
        Strokable$class.stroke(this, g, shape);
    }

    @Override
    public void configureStrokableForGroup(Style style, Camera camera) {
        Strokable$class.configureStrokableForGroup(this, style, camera);
    }

    @Override
    public ShapePaint fillPaint() {
        return this.fillPaint;
    }

    @Override
    public void fillPaint_$eq(ShapePaint x$1) {
        this.fillPaint = x$1;
    }

    @Override
    public double theFillPercent() {
        return this.theFillPercent;
    }

    @Override
    public void theFillPercent_$eq(double x$1) {
        this.theFillPercent = x$1;
    }

    @Override
    public Color theFillColor() {
        return this.theFillColor;
    }

    @Override
    public void theFillColor_$eq(Color x$1) {
        this.theFillColor = x$1;
    }

    @Override
    public boolean plainFast() {
        return this.plainFast;
    }

    @Override
    public void plainFast_$eq(boolean x$1) {
        this.plainFast = x$1;
    }

    @Override
    public void fill(Graphics2D g, double dynColor, Color optColor, Shape shape, Camera camera) {
        Fillable$class.fill(this, g, dynColor, optColor, shape, camera);
    }

    @Override
    public void fill(Graphics2D g, Shape shape, Camera camera) {
        Fillable$class.fill(this, g, shape, camera);
    }

    @Override
    public void configureFillableForGroup(Backend bck, Style style, Camera camera) {
        Fillable$class.configureFillableForGroup(this, bck, style, camera);
    }

    @Override
    public void configureFillableForElement(Style style, Camera camera, GraphicElement element) {
        Fillable$class.configureFillableForElement(this, style, camera, element);
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    @TraitSetter
    public void text_$eq(String x$1) {
        this.text = x$1;
    }

    @Override
    public ShapeDecor theDecor() {
        return this.theDecor;
    }

    @Override
    @TraitSetter
    public void theDecor_$eq(ShapeDecor x$1) {
        this.theDecor = x$1;
    }

    @Override
    public void decorArea(Backend backend, Camera camera, IconAndText iconAndText, GraphicElement element, Shape shape) {
        Decorable$class.decorArea(this, backend, camera, iconAndText, element, shape);
    }

    @Override
    public void decorConnector(Backend backend, Camera camera, IconAndText iconAndText, GraphicElement element, Shape shape) {
        Decorable$class.decorConnector(this, backend, camera, iconAndText, element, shape);
    }

    @Override
    public void configureDecorableForGroup(Style style, Camera camera) {
        Decorable$class.configureDecorableForGroup(this, style, camera);
    }

    @Override
    public void configureDecorableForElement(Backend backend, Camera camera, GraphicElement element, Skeleton skel) {
        Decorable$class.configureDecorableForElement(this, backend, camera, element, skel);
    }

    @Override
    public GraphicEdge theEdge() {
        return this.theEdge;
    }

    @Override
    @TraitSetter
    public void theEdge_$eq(GraphicEdge x$1) {
        this.theEdge = x$1;
    }

    @Override
    public double theSize() {
        return this.theSize;
    }

    @Override
    @TraitSetter
    public void theSize_$eq(double x$1) {
        this.theSize = x$1;
    }

    @Override
    public Point2 theTargetSize() {
        return this.theTargetSize;
    }

    @Override
    @TraitSetter
    public void theTargetSize_$eq(Point2 x$1) {
        this.theTargetSize = x$1;
    }

    @Override
    public Point2 theSourceSize() {
        return this.theSourceSize;
    }

    @Override
    @TraitSetter
    public void theSourceSize_$eq(Point2 x$1) {
        this.theSourceSize = x$1;
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    @TraitSetter
    public void isDirected_$eq(boolean x$1) {
        this.isDirected = x$1;
    }

    @Override
    public Point3 fromPos() {
        return Connector$class.fromPos(this);
    }

    @Override
    public Point3 byPos1() {
        return Connector$class.byPos1(this);
    }

    @Override
    public Point3 byPos2() {
        return Connector$class.byPos2(this);
    }

    @Override
    public Point3 toPos() {
        return Connector$class.toPos(this);
    }

    @Override
    public void configureConnectorForGroup(Style style, Camera camera) {
        Connector$class.configureConnectorForGroup(this, style, camera);
    }

    @Override
    public void configureConnectorForElement(Camera camera, GraphicEdge element, ConnectorSkeleton skel) {
        Connector$class.configureConnectorForElement(this, camera, element, skel);
    }

    @Override
    public ConnectorSkeleton skel() {
        return this.skel;
    }

    @Override
    @TraitSetter
    public void skel_$eq(ConnectorSkeleton x$1) {
        this.skel = x$1;
    }

    public Path2D.Double theShape() {
        return this.theShape;
    }

    public void theShape_$eq(Path2D.Double x$1) {
        this.theShape = x$1;
    }

    @Override
    public void make(Backend bck, Camera camera) {
        this.make(camera, 0.0, 0.0, 0.0, 0.0);
    }

    public void make(Camera camera, double sox, double soy, double swx, double swy) {
        if (this.skel().isCurve()) {
            this.makeOnCurve(camera, sox, soy, swx, swy);
        } else if (this.skel().isPoly()) {
            this.makeOnPolyline(camera, sox, soy, swx, swy);
        } else {
            this.makeOnLine(camera, sox, soy, swx, swy);
        }
    }

    public void makeOnLine(Camera camera, double sox, double soy, double swx, double swy) {
        double fromx = this.skel().from().x + sox;
        double fromy = this.skel().from().y + soy;
        double tox = this.skel().to().x + sox;
        double toy = this.skel().to().y + soy;
        Vector2 dir = new Vector2(tox - fromx, toy - fromy);
        Vector2 perp1 = new Vector2(dir.y(), -dir.x());
        perp1.normalize();
        Vector2 perp2 = new Vector2(perp1.x(), perp1.y());
        Vector2 perpm = new Vector2(perp1.x(), perp1.y());
        double srcsz = package$.MODULE$.min(this.theSourceSize().x, this.theSourceSize().y);
        double trgsz = package$.MODULE$.min(this.theTargetSize().x, this.theTargetSize().y);
        perp1.scalarMult((srcsz + swx) / 2.0);
        perpm.scalarMult((this.theSize() + swx) / 2.0);
        if (this.isDirected()) {
            perp2.scalarMult((this.theSize() + swx) / 2.0);
        } else {
            perp2.scalarMult((trgsz + swx) / 2.0);
        }
        float t1 = 5.0f;
        float t2 = 2.3f;
        float m = 1.0f;
        this.theShape().reset();
        this.theShape().moveTo(fromx + perp1.x(), fromy + perp1.y());
        this.theShape().quadTo(fromx + dir.x() / (double)t1 + perpm.x() * (double)m, fromy + dir.y() / (double)t1 + perpm.y() * (double)m, fromx + dir.x() / (double)t2 + perpm.x(), fromy + dir.y() / (double)t2 + perpm.y());
        this.theShape().lineTo(tox - dir.x() / (double)t2 + perpm.x(), toy - dir.y() / (double)t2 + perpm.y());
        this.theShape().quadTo(tox - dir.x() / (double)t1 + perpm.x() * (double)m, toy - dir.y() / (double)t1 + perpm.y() * (double)m, tox + perp2.x(), toy + perp2.y());
        this.theShape().lineTo(tox - perp2.x(), toy - perp2.y());
        this.theShape().quadTo(tox - dir.x() / (double)t1 - perpm.x() * (double)m, toy - dir.y() / (double)t1 - perpm.y() * (double)m, tox - dir.x() / (double)t2 - perpm.x(), toy - dir.y() / (double)t2 - perpm.y());
        this.theShape().lineTo(fromx + dir.x() / (double)t2 - perpm.x(), fromy + dir.y() / (double)t2 - perpm.y());
        this.theShape().quadTo(fromx + dir.x() / (double)t1 - perpm.x() * (double)m, fromy + dir.y() / (double)t1 - perpm.y() * (double)m, fromx - perp1.x(), fromy - perp1.y());
        this.theShape().closePath();
    }

    public void makeOnPolyline(Camera camera, double sox, double soy, double swx, double swy) {
        this.makeOnLine(camera, sox, soy, swx, swy);
    }

    public void makeOnCurve(Camera camera, double sox, double soy, double swx, double swy) {
        if (this.skel().isLoop()) {
            this.makeLoop(camera, sox, soy, swx, swy);
        } else {
            this.makeMulti(camera, sox, soy, swx, swy);
        }
    }

    public void makeMulti(Camera camera, double sox, double soy, double swx, double swy) {
        double fromx = this.skel().apply((int)0).x + sox;
        double fromy = this.skel().apply((int)0).y + soy;
        double tox = this.skel().apply((int)3).x + sox;
        double toy = this.skel().apply((int)3).y + soy;
        double c1x = this.skel().apply((int)1).x + sox;
        double c1y = this.skel().apply((int)1).y + soy;
        double c2x = this.skel().apply((int)2).x + sox;
        double c2y = this.skel().apply((int)2).y + soy;
        double srcsz = package$.MODULE$.min(this.theSourceSize().x, this.theSourceSize().y);
        double trgsz = package$.MODULE$.min(this.theTargetSize().x, this.theTargetSize().y);
        Vector2 maindir = new Vector2(c2x - c1x, c2y - c1y);
        Vector2 perp1 = new Vector2(maindir.y(), -maindir.x());
        perp1.normalize();
        Vector2 perp2 = new Vector2(perp1.x(), perp1.y());
        Vector2 perpm = new Vector2(perp1.x(), perp1.y());
        float t = 5.0f;
        perp1.scalarMult((srcsz + swx) / 2.0);
        perpm.scalarMult((this.theSize() + swx) / 2.0);
        if (this.isDirected()) {
            perp2.scalarMult((this.theSize() + swx) / 2.0);
        } else {
            perp2.scalarMult((trgsz + swx) / 2.0);
        }
        this.theShape().reset();
        this.theShape().moveTo(fromx + perp1.x(), fromy + perp1.y());
        this.theShape().quadTo(c1x + perpm.x(), c1y + perpm.y(), c1x + maindir.x() / (double)t + perpm.x(), c1y + maindir.y() / (double)t + perpm.y());
        this.theShape().lineTo(c2x - maindir.x() / (double)t + perpm.x(), c2y - maindir.y() / (double)t + perpm.y());
        this.theShape().quadTo(c2x + perpm.x(), c2y + perpm.y(), tox + perp2.x(), toy + perp2.y());
        this.theShape().lineTo(tox - perp2.x(), toy - perp2.y());
        this.theShape().quadTo(c2x - perpm.x(), c2y - perpm.y(), c2x - maindir.x() / (double)t - perpm.x(), c2y - maindir.y() / (double)t - perpm.y());
        this.theShape().lineTo(c1x + maindir.x() / (double)t - perpm.x(), c1y + maindir.y() / (double)t - perpm.y());
        this.theShape().quadTo(c1x - perpm.x(), c1y - perpm.y(), fromx - perp1.x(), fromy - perp1.y());
        this.theShape().closePath();
    }

    public void makeLoop(Camera camera, double sox, double soy, double swx, double swy) {
        double fromx = this.skel().apply((int)0).x + sox;
        double fromy = this.skel().apply((int)0).y + soy;
        double tox = this.skel().apply((int)3).x + sox;
        double toy = this.skel().apply((int)3).y + soy;
        double c1x = this.skel().apply((int)1).x + sox;
        double c1y = this.skel().apply((int)1).y + soy;
        double c2x = this.skel().apply((int)2).x + sox;
        double c2y = this.skel().apply((int)2).y + soy;
        double srcsz = package$.MODULE$.min(this.theSourceSize().x, this.theSourceSize().y);
        Vector2 dirFrom = new Vector2(c1x - fromx, c1y - fromy);
        Vector2 dirTo = new Vector2(tox - c2x, toy - c2y);
        Vector2 mainDir = new Vector2(c2x - c1x, c2y - c1y);
        Vector2 perpFrom = new Vector2(dirFrom.y(), -dirFrom.x());
        perpFrom.normalize();
        Vector2 mid1 = new Vector2(dirFrom);
        mid1.sub(mainDir);
        mid1.normalize();
        Vector2 mid2 = new Vector2(mainDir);
        mid2.sub(dirTo);
        mid2.normalize();
        perpFrom.scalarMult((srcsz + swx) * (double)0.3f);
        if (this.isDirected()) {
            mid1.scalarMult((this.theSize() + swx) * 4.0);
            mid2.scalarMult((this.theSize() + swx) * 2.0);
        } else {
            mid1.scalarMult((this.theSize() + swx) * 4.0);
            mid2.scalarMult((this.theSize() + swx) * 4.0);
        }
        this.theShape().reset();
        this.theShape().moveTo(fromx + perpFrom.x(), fromy + perpFrom.y());
        if (this.isDirected()) {
            this.theShape().curveTo(c1x + mid1.x(), c1y + mid1.y(), c2x + mid2.x(), c2y + mid2.y(), tox, toy);
            this.theShape().curveTo(c2x - mid2.x(), c2y - mid2.y(), c1x - mid1.x(), c1y - mid1.y(), fromx - perpFrom.x(), fromy - perpFrom.y());
        } else {
            Vector2 perpTo = new Vector2(dirTo.y(), -dirTo.x());
            perpTo.normalize();
            perpTo.scalarMult((srcsz + swx) * (double)0.3f);
            this.theShape().curveTo(c1x + mid1.x(), c1y + mid1.y(), c2x + mid2.x(), c2y + mid2.y(), tox + perpTo.x(), toy + perpTo.y());
            this.theShape().lineTo(tox - perpTo.x(), toy - perpTo.y());
            this.theShape().curveTo(c2x - mid2.x(), c2y - mid2.y(), c1x - mid1.x(), c1y - mid1.y(), fromx - perpFrom.x(), fromy - perpFrom.y());
        }
        this.theShape().closePath();
    }

    @Override
    public void makeShadow(Backend bck, Camera camera) {
        this.make(camera, this.theShadowOff().x, this.theShadowOff().y, this.theShadowWidth().x, this.theShadowWidth().y);
    }

    @Override
    public void renderShadow(Backend bck, Camera camera, GraphicElement element, Skeleton skel) {
        this.makeShadow(bck, camera);
        this.cast(bck.graphics2D(), this.theShape());
    }

    @Override
    public void render(Backend bck, Camera camera, GraphicElement element, Skeleton skel) {
        Graphics2D g = bck.graphics2D();
        this.make(bck, camera);
        this.stroke(g, this.theShape());
        this.fill(g, this.theShape(), camera);
        this.decorConnector(bck, camera, skel.iconAndText(), element, this.theShape());
        if (this.showControlPolygon()) {
            Color c = g.getColor();
            Stroke s2 = g.getStroke();
            g.setStroke(new BasicStroke((float)camera.metrics().px1));
            g.setColor(Color.red);
            g.draw(this.theShape());
            g.setStroke(s2);
            g.setColor(c);
            this.showCtrlPoints(g, camera, (ConnectorSkeleton)skel);
        }
    }

    public BlobShape() {
        HasSkel$class.$init$(this);
        Connector$class.$init$(this);
        Decorable$class.$init$(this);
        ConnectorShape$class.$init$(this);
        Fillable$class.$init$(this);
        Strokable$class.$init$(this);
        Shadowable$class.$init$(this);
        AreaConnectorShape$class.$init$(this);
        ShowCubics$class.$init$(this);
        this.theShape = new Path2D.Double();
    }
}

