/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.util;

import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.j2dviewer.Camera;
import org.graphstream.ui.j2dviewer.renderer.AreaSkeleton;
import org.graphstream.ui.j2dviewer.renderer.ConnectorSkeleton;
import org.graphstream.ui.j2dviewer.renderer.Skeleton$;
import scala.math.package$;

public final class ShapeUtil$ {
    public static final ShapeUtil$ MODULE$;

    static {
        new ShapeUtil$();
    }

    public double evalTargetRadius2D(GraphicEdge edge, Camera camera) {
        ConnectorSkeleton eskel = (ConnectorSkeleton)edge.getAttribute(Skeleton$.MODULE$.attributeName());
        if (eskel != null) {
            return this.evalTargetRadius2D((Style)edge.to.getStyle(), (AreaSkeleton)edge.to.getAttribute(Skeleton$.MODULE$.attributeName()), new Point3(eskel.from().x, eskel.from().y, eskel.from().z), new Point3(eskel.to().x, eskel.to().y, eskel.to().z), camera);
        }
        throw new RuntimeException("no skeleton on edge ??");
    }

    public double evalTargetRadius2D(Point3 from2, Point3 to2, GraphicNode node, Camera camera) {
        return this.evalTargetRadius2D((Style)node.getStyle(), (AreaSkeleton)node.getAttribute(Skeleton$.MODULE$.attributeName()), from2, null, null, to2, camera);
    }

    public double evalTargetRadius2D(Style style, AreaSkeleton skeleton, Point3 p0, Point3 p3, Camera camera) {
        return this.evalTargetRadius2D(style, skeleton, p0, null, null, p3, camera);
    }

    public double evalTargetRadius2D(GraphicEdge edge, Point3 p0, Point3 p1, Point3 p2, Point3 p3, Camera camera) {
        return this.evalTargetRadius2D((Style)edge.to.getStyle(), (AreaSkeleton)edge.to.getAttribute(Skeleton$.MODULE$.attributeName()), p0, p1, p2, p3, camera);
    }

    public double evalTargetRadius2D(Style style, AreaSkeleton skeleton, Point3 p0, Point3 p1, Point3 p2, Point3 p3, Camera camera) {
        double d;
        double s2;
        double w = 0.0;
        double h = 0.0;
        StyleConstants.StrokeMode strokeMode = style.getStrokeMode();
        StyleConstants.StrokeMode strokeMode2 = StyleConstants.StrokeMode.NONE;
        double d2 = !(strokeMode != null ? !strokeMode.equals(strokeMode2) : strokeMode2 != null) ? 0.0 : (s2 = camera.metrics().lengthToGu(style.getStrokeWidth()));
        if (skeleton == null) {
            w = camera.metrics().lengthToGu(style.getSize(), 0);
            h = style.getSize().size() > 1 ? camera.metrics().lengthToGu(style.getSize(), 1) : w;
        } else {
            w = skeleton.theSize().x;
            h = skeleton.theSize().y;
        }
        StyleConstants.Shape shape = style.getShape();
        StyleConstants.Shape shape2 = StyleConstants.Shape.CIRCLE;
        StyleConstants.Shape shape3 = shape;
        if (!(shape2 != null ? !shape2.equals(shape3) : shape3 != null)) {
            d = this.evalEllipseRadius2D(p0, p1, p2, p3, w, h, s2);
        } else {
            StyleConstants.Shape shape4 = StyleConstants.Shape.DIAMOND;
            StyleConstants.Shape shape5 = shape;
            if (!(shape4 != null ? !shape4.equals(shape5) : shape5 != null)) {
                d = this.evalEllipseRadius2D(p0, p1, p2, p3, w, h, s2);
            } else {
                StyleConstants.Shape shape6 = StyleConstants.Shape.CROSS;
                StyleConstants.Shape shape7 = shape;
                if (!(shape6 != null ? !shape6.equals(shape7) : shape7 != null)) {
                    d = this.evalEllipseRadius2D(p0, p1, p2, p3, w, h, s2);
                } else {
                    StyleConstants.Shape shape8 = StyleConstants.Shape.TRIANGLE;
                    StyleConstants.Shape shape9 = shape;
                    if (!(shape8 != null ? !shape8.equals(shape9) : shape9 != null)) {
                        d = this.evalEllipseRadius2D(p0, p1, p2, p3, w, h, s2);
                    } else {
                        StyleConstants.Shape shape10 = StyleConstants.Shape.TEXT_CIRCLE;
                        StyleConstants.Shape shape11 = shape;
                        if (!(shape10 != null ? !shape10.equals(shape11) : shape11 != null)) {
                            d = this.evalEllipseRadius2D(p0, p1, p2, p3, w, h, s2);
                        } else {
                            StyleConstants.Shape shape12 = StyleConstants.Shape.TEXT_DIAMOND;
                            StyleConstants.Shape shape13 = shape;
                            if (!(shape12 != null ? !shape12.equals(shape13) : shape13 != null)) {
                                d = this.evalEllipseRadius2D(p0, p1, p2, p3, w, h, s2);
                            } else {
                                StyleConstants.Shape shape14 = StyleConstants.Shape.BOX;
                                StyleConstants.Shape shape15 = shape;
                                if (!(shape14 != null ? !shape14.equals(shape15) : shape15 != null)) {
                                    d = this.evalBoxRadius2D(p0, p1, p2, p3, w / (double)2 + s2, h / (double)2 + s2);
                                } else {
                                    StyleConstants.Shape shape16 = StyleConstants.Shape.ROUNDED_BOX;
                                    StyleConstants.Shape shape17 = shape;
                                    if (!(shape16 != null ? !shape16.equals(shape17) : shape17 != null)) {
                                        d = this.evalBoxRadius2D(p0, p1, p2, p3, w / (double)2 + s2, h / (double)2 + s2);
                                    } else {
                                        StyleConstants.Shape shape18 = StyleConstants.Shape.TEXT_BOX;
                                        StyleConstants.Shape shape19 = shape;
                                        if (!(shape18 != null ? !shape18.equals(shape19) : shape19 != null)) {
                                            d = this.evalBoxRadius2D(p0, p1, p2, p3, w / (double)2 + s2, h / (double)2 + s2);
                                        } else {
                                            StyleConstants.Shape shape20 = StyleConstants.Shape.JCOMPONENT;
                                            StyleConstants.Shape shape21 = shape;
                                            d = !(shape20 != null ? !shape20.equals(shape21) : shape21 != null) ? this.evalBoxRadius2D(p0, p1, p2, p3, w / (double)2 + s2, h / (double)2 + s2) : this.evalBoxRadius2D(p0, p1, p2, p3, w / (double)2 + s2, h / (double)2 + s2);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return d;
    }

    public double evalEllipseRadius2D(Point3 p0, Point3 p1, Point3 p2, Point3 p3, double w, double h, double s2) {
        return w == h ? w / (double)2 + s2 : this.evalEllipseRadius2D(p0, p1, p2, p3, w / (double)2 + s2, h / (double)2 + s2);
    }

    public double evalEllipseRadius2D(Point3 p0, Point3 p1, Point3 p2, Point3 p3, double w, double h) {
        double d;
        if (w == h) {
            d = w / (double)2;
        } else {
            double dx = 0.0;
            double dy = 0.0;
            if (p1 == null || p2 == null) {
                dx = p3.x - p0.x;
                dy = p3.y - p0.y;
            } else {
                dx = p3.x - p2.x;
                dy = p3.y - p2.y;
            }
            double d2 = package$.MODULE$.sqrt(dx * dx + (dy *= w / h) * dy);
            double a = dx / d2;
            a = package$.MODULE$.acos(a);
            dx = package$.MODULE$.cos(a) * w;
            dy = package$.MODULE$.sin(a) * h;
            d = package$.MODULE$.sqrt(dx * dx + dy * dy);
        }
        return d;
    }

    public double evalBoxRadius2D(Point3 p0, Point3 p1, Point3 p2, Point3 p3, double w, double h) {
        double d;
        double da = w / package$.MODULE$.sqrt(w * w + h * h);
        da = da < 0.0 ? -da : da;
        double dx = 0.0;
        double dy = 0.0;
        if (p1 == null || p2 == null) {
            dx = p3.x - p0.x;
            dy = p3.y - p0.y;
        } else {
            dx = p3.x - p2.x;
            dy = p3.y - p2.y;
        }
        double d2 = package$.MODULE$.sqrt(dx * dx + dy * dy);
        double a = dx / d2;
        double d3 = a = a < 0.0 ? -a : a;
        if (da < a) {
            d = w / a;
        } else {
            a = dy / d2;
            a = a < 0.0 ? -a : a;
            d = h / a;
        }
        return d;
    }

    public boolean isPointIn(GraphicElement elt, Point3 p, double w, double h) {
        boolean bl;
        StyleConstants.ShapeKind shapeKind = elt.getStyle().getShape().kind;
        StyleConstants.ShapeKind shapeKind2 = StyleConstants.ShapeKind.RECTANGULAR;
        StyleConstants.ShapeKind shapeKind3 = shapeKind;
        if (!(shapeKind2 != null ? !shapeKind2.equals(shapeKind3) : shapeKind3 != null)) {
            bl = this.isPointIn2DBox(p, elt.getX(), elt.getY(), w, h);
        } else {
            StyleConstants.ShapeKind shapeKind4 = StyleConstants.ShapeKind.ELLIPSOID;
            StyleConstants.ShapeKind shapeKind5 = shapeKind;
            bl = !(shapeKind4 != null ? !shapeKind4.equals(shapeKind5) : shapeKind5 != null) ? this.isPointIn2DEllipse(p, elt.getX(), elt.getY(), w, h) : false;
        }
        return bl;
    }

    public boolean isPointIn2DBox(Point3 p, double x, double y, double w, double h) {
        double w2 = w / (double)2;
        double h2 = h / (double)2;
        return p.x > x - w2 && p.x < x + w2 && p.y > y - h2 && p.y < y + h2;
    }

    public boolean isPointIn2DEllipse(Point3 p, double x, double y, double w, double h) {
        double xx = p.x - x;
        double w2 = w / (double)2;
        double yy = p.y - y;
        double h2 = h / (double)2;
        return xx * xx / (w2 * w2) + yy * yy / (h2 * h2) < 1.0;
    }

    private ShapeUtil$() {
        MODULE$ = this;
    }
}

