/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.familygroups;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.modules.document.view.FopDocumentView;
import ancestris.modules.familygroups.Bundle;
import ancestris.modules.familygroups.FamilyGroupsPlugin;
import genj.fo.Document;
import genj.gedcom.Context;
import java.awt.event.ActionEvent;
import java.util.prefs.Preferences;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class OpenFamilyGroupsAction
extends AbstractAncestrisContextAction {
    Preferences modulePreferences = NbPreferences.forModule(FamilyGroupsPlugin.class);

    public OpenFamilyGroupsAction() {
        this.setImage("ancestris/modules/familygroups/FamilyGroups.png");
        this.setText(NbBundle.getMessage(OpenFamilyGroupsAction.class, (String)"CTL_FamilyGroupsAction"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        Context contextToOpen = this.getContext();
        if (contextToOpen != null) {
            if (this.modulePreferences.getInt("minGroupSize", -1) == -1) {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(FamilyGroupsPlugin.class, (String)"OpenFamilyGroupsAction.setParameters"), 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                OptionsDisplayer.getDefault().open("Extensions/FamilyGroups");
            } else {
                final FamilyGroupsPlugin fgp = new FamilyGroupsPlugin();
                Document doc = fgp.start(contextToOpen.getGedcom());
                if (doc != null) {
                    FopDocumentView window = new FopDocumentView(contextToOpen, Bundle.title_short(), Bundle.title(contextToOpen.getGedcom().getName()));
                    window.executeOnClose(new Runnable(){

                        @Override
                        public void run() {
                            fgp.stop();
                        }
                    });
                    window.displayDocument(doc, this.modulePreferences);
                }
            }
        }
    }
}

