/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare.communication;

import ancestris.modules.gedcomcompare.GedcomCompareTopComponent;
import ancestris.modules.gedcomcompare.communication.UserProfile;
import ancestris.modules.gedcomcompare.tools.ConnectedUserFrame;
import ancestris.modules.gedcomcompare.tools.STMapCapsule;
import ancestris.modules.gedcomcompare.tools.STMapEventsCapsule;
import ancestris.usage.Constants;
import ancestris.util.swing.DialogManager;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Comm
implements Constants {
    private GedcomCompareTopComponent owner;
    private static final Logger LOG = Logger.getLogger("ancestris.gedcomcompare");
    private int COMM_PORT = 5448;
    private static String COMM_CHARSET = "UTF-8";
    private int COMM_TIMEOUT = 1000;
    private boolean isCommError = false;
    private String serverIP = "";
    public static int PING_DELAY = 60;
    private static DatagramSocket socket = null;
    public static int COMM_PREF = 8;
    public static int COMM_NBST = 10;
    private static String CMD_GETMB = "/compare-get-users.php?";
    private static String TAG_MEMBER = "user";
    private static String TAG_PSEUDO = "pseudo";
    private static String TAG_IPADDR = "ipaddress";
    private static String TAG_PORTAD = "portaddress";
    private static String TAG_PIPADD = "pipaddress";
    private static String TAG_PPORTA = "pportaddress";
    private static String TAG_PRIVAT = "private";
    private static String TAG_NBINDS = "NbIndis";
    private static String TAG_NBFAMS = "NbFams";
    private static String TAG_NBSTS = "NbSTs";
    private static String TAG_NBEVS = "NbEvens";
    public static String[] TAG_STS = new String[]{"ST01", "ST02", "ST03", "ST04", "ST05", "ST06", "ST07", "ST08", "ST09", "ST10"};
    private static String TAG_STATS_OVER = "stats_overlap";
    private static String TAG_STATS_CINA = "stats_citynames";
    private static String TAG_STATS_EVEN = "stats_events";
    private int COMM_PACKET_SIZE = 1400;
    private double COMM_COMPRESSING_FACTOR = 3.0;
    private String FMT_IDX = "%03d";
    private int COMM_CMD_PFX_SIZE = 2;
    private int COMM_CMD_SIZE = 5;
    private int COMM_PACKET_NB = 1000;
    private static String STR_DELIMITER = " ";
    private int REQUEST_TIMEOUT = 3;
    private int COMM_NB_FAILS = 4;
    private int COMM_RESPONSE_DELAY = 50;
    private boolean isBusy = false;
    private static String CMD_REGIS = "REGIS";
    private static String CMD_REGOK = "REGOK";
    private static String CMD_REGKO = "REGKO";
    private static String CMD_UNREG = "UNREG";
    private static String CMD_UNROK = "UNROK";
    private static String CMD_UNRKO = "UNRKO";
    private static String CMD_CONCT = "CONCT";
    private static String CMD_PINGG = "PINGG";
    private static String CMD_PONGG = "PONGG";
    private static String CMD_STATS = "STATS";
    private static String CMD_GMCxx = "GM";
    private static String CMD_TMCxx = "TM";
    private static String CMD_GMExx = "GE";
    private static String CMD_TMExx = "TE";
    private static String CMD_GPFxx = "GP";
    private static String CMD_TPFxx = "TP";
    private CommStreamObject csoMapCapsule = new CommStreamObject();
    private CommStreamObject csoMapEventsCapsule = new CommStreamObject();
    private CommStreamObject csoProfile = new CommStreamObject();
    private volatile boolean sharing;
    private Thread listeningThread;
    private Thread pingingThread;
    private boolean communicationInProgress = false;
    private ConnectedUserFrame userInProgress = null;
    private boolean expectMoreResponse = false;
    private Set<ExpectedResponse> expectedResponses = null;

    public Comm(GedcomCompareTopComponent tstc) {
        this.owner = tstc;
    }

    public List<User> getConnectedUsers(boolean quiet) {
        ArrayList<User> users = new ArrayList<User>();
        String outputString = this.getQueryResult("http://serv01.ancestris.org" + CMD_GETMB + "user=treeshare01&pw=DhZP8imP", quiet);
        if (outputString == null) {
            return null;
        }
        if (outputString.isEmpty()) {
            return users;
        }
        NodeList nodeList = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(outputString));
            Document doc = db.parse(is);
            doc.getDocumentElement().normalize();
            nodeList = doc.getElementsByTagName(TAG_MEMBER);
        }
        catch (Exception ex) {
            this.displayErrorMessage("ERR_ParsingConnectedUsers", null, "getConnectedUsers", ex, true);
        }
        for (int temp = 0; nodeList != null && temp < nodeList.getLength(); ++temp) {
            Node node = nodeList.item(temp);
            if (node.getNodeType() != 1) continue;
            Element member = (Element)node;
            UserProfile userProfile = new UserProfile();
            userProfile.pseudo = StringEscapeUtils.unescapeHtml((String)member.getElementsByTagName(TAG_PSEUDO).item(0).getTextContent());
            userProfile.ipAddress = member.getElementsByTagName(TAG_IPADDR).item(0).getTextContent();
            userProfile.portAddress = member.getElementsByTagName(TAG_PORTAD).item(0).getTextContent();
            userProfile.pipAddress = member.getElementsByTagName(TAG_PIPADD).item(0).getTextContent();
            userProfile.pportAddress = member.getElementsByTagName(TAG_PPORTA).item(0).getTextContent();
            userProfile.usePrivateIP = false;
            userProfile.privacy = member.getElementsByTagName(TAG_PRIVAT).item(0).getTextContent();
            String f_NbIndis = member.getElementsByTagName(TAG_NBINDS).item(0).getTextContent();
            String f_NbFamilies = member.getElementsByTagName(TAG_NBFAMS).item(0).getTextContent();
            String f_NbSTs = member.getElementsByTagName(TAG_NBSTS).item(0).getTextContent();
            String f_NbEvens = member.getElementsByTagName(TAG_NBEVS).item(0).getTextContent();
            String[] f_STs = new String[TAG_STS.length];
            for (int i = 0; i < TAG_STS.length; ++i) {
                f_STs[i] = member.getElementsByTagName(TAG_STS[i]).item(0).getTextContent();
            }
            String stats_Over = member.getElementsByTagName(TAG_STATS_OVER).item(0).getTextContent();
            String stats_CiNa = member.getElementsByTagName(TAG_STATS_CINA).item(0).getTextContent();
            String stats_Even = member.getElementsByTagName(TAG_STATS_EVEN).item(0).getTextContent();
            if (userProfile.pseudo.equals(this.owner.getPreferredPseudo())) continue;
            users.add(new User(userProfile, f_NbIndis, f_NbFamilies, f_NbSTs, f_NbEvens, f_STs, stats_Over, stats_CiNa, stats_Even));
        }
        return users;
    }

    private String getQueryResult(String url, boolean quiet) {
        String ret = "";
        String log = "Connecting to url=[" + url.substring(24, 46) + "]";
        try {
            String responseString = "";
            URL data = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)data.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((responseString = in.readLine()) != null) {
                ret = ret + responseString;
            }
            in.close();
            connection.disconnect();
            this.isCommError = false;
        }
        catch (UnknownHostException ex) {
            this.displayErrorMessage(this.owner.isSharingOn() ? "ERR_UnknownHostExceptionON" : "ERR_UnknownHostException", log, "getQueryResult", ex, !quiet);
            ret = null;
        }
        catch (SocketException ex) {
            this.displayErrorMessage("ERR_SocketException", log, "getQueryResult", ex, !quiet);
            ret = null;
        }
        catch (IOException ex) {
            this.displayErrorMessage("ERR_IOException", log, "getQueryResult", ex, !quiet);
            ret = null;
        }
        catch (Exception ex) {
            this.displayErrorMessage("ERR_Exception", log, "getQueryResult", ex, !quiet);
            ret = null;
        }
        return ret;
    }

    public void resetPrivacy() {
        this.csoMapEventsCapsule.sentPackets = null;
    }

    public void resetMap() {
        this.csoMapCapsule.sentPackets = null;
        this.csoMapEventsCapsule.sentPackets = null;
    }

    public void resetProfile() {
        this.csoProfile.sentPackets = null;
    }

    public void setCommunicationInProgress(boolean inProgress) {
        this.communicationInProgress = inProgress;
    }

    public boolean registerMe(String pseudo, String[] data) {
        LOG.log(Level.FINE, "***");
        LOG.log(Level.FINE, "Communication packet size is " + this.COMM_PACKET_SIZE);
        this.isCommError = false;
        try {
            socket = new DatagramSocket();
            String content = pseudo + " " + Comm.getLocalHostLANAddress().getHostAddress() + " " + socket.getLocalPort() + " " + String.join((CharSequence)" ", data);
            boolean ret = this.sendCommand(CMD_REGIS, content, null, "serv01.ancestris.org", this.COMM_PORT);
            if (!ret) {
                return false;
            }
            byte[] bytesReceived = new byte[512];
            DatagramPacket packetReceived = new DatagramPacket(bytesReceived, bytesReceived.length);
            socket.setSoTimeout(this.COMM_TIMEOUT);
            socket.receive(packetReceived);
            this.serverIP = packetReceived.getAddress().getHostAddress();
            String reply = StringEscapeUtils.unescapeHtml((String)new String(bytesReceived).split("\u0000")[0]);
            if (reply.substring(0, this.COMM_CMD_SIZE).equals(CMD_REGOK)) {
                LOG.log(Level.FINE, "...(REGOK) Registered " + pseudo + " on the Ancestris server.");
                this.owner.getConsole().println("\n\n", false);
                this.owner.getConsole().println(NbBundle.getMessage(this.getClass(), (String)"MSG_SharingModeIsON", (Object)pseudo), true);
                socket.setSoTimeout(0);
            } else if (reply.substring(0, this.COMM_CMD_SIZE).equals(CMD_REGKO)) {
                String err = reply.substring(this.COMM_CMD_SIZE);
                LOG.log(Level.FINE, "...(REGKO) Could not register " + pseudo + " on the Ancestris server. Error : " + err);
                if (err.startsWith("Duplicate entry")) {
                    err = NbBundle.getMessage(Comm.class, (String)"ERR_DuplicatePseudo");
                }
                DialogManager.create((String)NbBundle.getMessage(Comm.class, (String)"MSG_Registration"), (String)err).setMessageType(2).show();
                return false;
            }
        }
        catch (IOException ex) {
            String log = "...(TIMEOUT) Could not register " + pseudo + " on the Ancestris server.";
            this.displayErrorMessage("ERR_SharingON", log, "registerMe", ex, true);
            return false;
        }
        this.startListeningToFriends();
        return true;
    }

    public boolean unregisterMe(String pseudo) {
        String log = "...(TIMEOUT) Could not unregister " + pseudo + " from the Ancestris server.";
        try {
            boolean ret = this.sendCommand(CMD_UNREG, pseudo, null, "serv01.ancestris.org", this.COMM_PORT);
            if (!ret) {
                this.stopListeningToFriends();
                return false;
            }
            for (int s = 0; this.sharing && s < 200; ++s) {
                TimeUnit.MILLISECONDS.sleep(20L);
            }
            if (this.sharing) {
                this.displayErrorMessage("ERR_ServerNotResponding", log, "unregisterMe", null, true);
                this.stopListeningToFriends();
                return false;
            }
        }
        catch (Exception ex) {
            this.displayErrorMessage("ERR_SharingOFF", log, "unregisterMe", ex, true);
            this.stopListeningToFriends();
            return false;
        }
        if (socket != null) {
            socket.close();
        }
        LOG.log(Level.FINE, "...(UNREGOK) Unregistered " + pseudo + " from the Ancestris server.");
        this.owner.getConsole().println(NbBundle.getMessage(this.getClass(), (String)"MSG_SharingModeIsOFF", (Object)pseudo) + "\n\n", true);
        this.stopListeningToFriends();
        return true;
    }

    private boolean startListeningToFriends() {
        this.sharing = true;
        this.listeningThread = new Thread(){

            @Override
            public void run() {
                Comm.this.listen();
            }
        };
        this.listeningThread.setName("GedcomCompare thread : loop to wait for Ancestris connections");
        this.listeningThread.start();
        this.pingingThread = new Thread(){

            @Override
            public void run() {
                Comm.this.ping();
            }
        };
        this.pingingThread.setName("GedcomCompare thread : loop to stay alive with server");
        this.pingingThread.start();
        return true;
    }

    private void ping() {
        while (this.sharing) {
            this.sendPing();
            try {
                TimeUnit.SECONDS.sleep(PING_DELAY);
            }
            catch (InterruptedException ex) {
                this.displayErrorMessage("ERR_InterruptedException", null, "ping", ex, false);
            }
        }
    }

    public void sendPing() {
        if (this.sharing) {
            this.sendCommand(CMD_PONGG, this.owner.getRegisteredPseudo(false), null, "serv01.ancestris.org", this.COMM_PORT);
        }
    }

    private boolean stopListeningToFriends() {
        this.sharing = false;
        LOG.log(Level.INFO, "Stopped thread listening to incoming calls");
        return true;
    }

    public boolean getMapCapsule(STMapCapsule myMap, ConnectedUserFrame user) {
        boolean ret = false;
        this.owner.updateConnectedUsers(true);
        this.csoMapCapsule.setPackets(this.buildPacketsOfObject(myMap));
        if (this.putPackets(user, CMD_TMCxx, this.csoMapCapsule.getPackets())) {
            this.communicationInProgress = true;
            this.csoMapCapsule.reset();
            ret = this.getPackets(user, CMD_GMCxx, null);
        }
        this.communicationInProgress = false;
        return ret;
    }

    public boolean getMapEventsCapsule(STMapEventsCapsule myMapEvents, ConnectedUserFrame user) {
        boolean ret = false;
        this.owner.updateConnectedUsers(true);
        this.csoMapEventsCapsule.setPackets(this.buildPacketsOfObject(myMapEvents));
        if (this.putPackets(user, CMD_TMExx, this.csoMapEventsCapsule.getPackets())) {
            this.communicationInProgress = true;
            this.csoMapEventsCapsule.reset();
            ret = this.getPackets(user, CMD_GMExx, null);
        }
        this.communicationInProgress = false;
        return ret;
    }

    public boolean getUserProfile(UserProfile myProfile, ConnectedUserFrame user) {
        boolean ret = false;
        this.communicationInProgress = true;
        this.csoProfile.setPackets(this.buildPacketsOfObject(myProfile));
        if (this.putPackets(user, CMD_TPFxx, this.csoProfile.getPackets())) {
            this.communicationInProgress = true;
            this.csoProfile.reset();
            ret = this.getPackets(user, CMD_GPFxx, null);
        }
        this.communicationInProgress = false;
        return ret;
    }

    public void sendStats(String values) {
        if (this.sharing && !this.isBusy) {
            this.sendCommand(CMD_STATS, this.owner.getRegisteredPseudo(false) + " " + values, null, "serv01.ancestris.org", this.COMM_PORT);
        }
    }

    public void listen() {
        String command = null;
        String sender = "";
        String senderAddress = null;
        String senderIP = null;
        int senderPort = 0;
        byte[] bytesReceived = new byte[this.COMM_PACKET_SIZE * 7];
        byte[] contentMemberBytes = null;
        String contentMemberStr = null;
        byte[] contentObj = null;
        String member = null;
        ConnectedUserFrame aMember = null;
        LOG.log(Level.FINE, "Listening to all incoming calls indefinitely.......");
        this.expectedResponses = new HashSet<ExpectedResponse>();
        try {
            while (this.sharing) {
                String msg;
                String code;
                this.isBusy = false;
                DatagramPacket packetReceived = new DatagramPacket(bytesReceived, bytesReceived.length);
                socket.setSoTimeout(0);
                socket.receive(packetReceived);
                this.isBusy = true;
                senderIP = packetReceived.getAddress().getHostAddress();
                senderPort = packetReceived.getPort();
                senderAddress = senderIP + ":" + senderPort;
                sender = this.serverIP.equals(senderIP) ? "Server" : senderIP + ":" + senderPort;
                command = new String(Arrays.copyOfRange(bytesReceived, 0, this.COMM_CMD_SIZE));
                contentMemberBytes = this.extractBytes(Arrays.copyOfRange(bytesReceived, this.COMM_CMD_SIZE, bytesReceived.length), STR_DELIMITER.getBytes()[0]);
                contentMemberStr = new String(contentMemberBytes);
                member = StringEscapeUtils.unescapeHtml((String)contentMemberStr);
                LOG.log(Level.FINE, "...Incoming " + command + " command received with string '" + member + "' from " + sender + " with packet of size (" + packetReceived.getLength() + " bytes).");
                if (command.equals(CMD_UNROK)) {
                    this.sharing = false;
                    continue;
                }
                if (command.equals(CMD_UNRKO)) {
                    String err = new String(bytesReceived).substring(this.COMM_CMD_SIZE);
                    LOG.log(Level.FINE, "......Could not unregister " + this.owner.getRegisteredPseudo(false) + " from the Ancestris server. Error : " + err);
                    DialogManager.create((String)NbBundle.getMessage(Comm.class, (String)"MSG_Unregistration"), (String)err).setMessageType(0).show();
                    continue;
                }
                if (command.equals(CMD_CONCT)) {
                    this.owner.updateConnectedUsers(true);
                    aMember = this.owner.getUser(member);
                    if (aMember != null) {
                        LOG.log(Level.FINE, "......Attempt to connect to member '" + member + "' at " + aMember.getxIPAddress() + ":" + Integer.valueOf(aMember.getxPortAddress()));
                    }
                    if (aMember == null) {
                        LOG.log(Level.FINE, "......Member '" + member + "' is not in the list of members.");
                        continue;
                    }
                    if (aMember.isIncluded()) {
                        this.sendCommand(CMD_PINGG, this.owner.getRegisteredPseudo() + STR_DELIMITER, null, aMember.getxIPAddress(), Integer.valueOf(aMember.getxPortAddress()));
                        if (!aMember.getpIPAddress().isEmpty() && Integer.valueOf(aMember.getpPortAddress()) != 0) {
                            this.sendCommand(CMD_PINGG, this.owner.getRegisteredPseudo() + STR_DELIMITER, null, aMember.getpIPAddress(), Integer.valueOf(aMember.getpPortAddress()));
                        }
                        LOG.log(Level.FINE, "......Member " + member + " is allowed. Connection attempt sent with PINGG to user.");
                        continue;
                    }
                    LOG.log(Level.FINE, "......Member " + member + " is NOT allowed. I did not reply.");
                    continue;
                }
                String userError = "00";
                aMember = this.owner.getUser(member);
                if (aMember == null) {
                    this.owner.updateConnectedUsers(true);
                    aMember = this.owner.getUser(member);
                }
                if (aMember == null) {
                    userError = "01 User unknown";
                    LOG.log(Level.FINE, "......Calling member '" + member + "' is not in the list of members (" + userError + ").");
                } else if (!aMember.isIncluded()) {
                    userError = "02 User not included";
                    LOG.log(Level.FINE, "......Member '" + member + "' is NOT included. Do not reply (" + userError + ").");
                } else if (!this.isSameAddress(senderAddress, aMember)) {
                    userError = "03 User address mismatch";
                    LOG.log(Level.FINE, "......Member '" + member + "' address does not match the one I know. Do not reply (" + userError + ").");
                    this.owner.updateConnectedUsers(true);
                }
                contentObj = Arrays.copyOfRange(bytesReceived, this.COMM_CMD_SIZE + contentMemberBytes.length + STR_DELIMITER.length(), bytesReceived.length);
                if (contentObj == null || contentObj.length == 0) {
                    userError = "04 User packet is empty";
                    LOG.log(Level.FINE, "......Member " + member + " has sent an empty packet. Break process (" + userError + ").");
                }
                if (command.equals(CMD_PINGG) || !userError.equals("00")) {
                    code = userError.substring(0, 2);
                    msg = NbBundle.getMessage(this.getClass(), (String)"MSG_ReceivingConnection", (Object)member, (Object)NbBundle.getMessage(this.getClass(), (String)("ERR_CODE_" + code)));
                    LOG.log(Level.FINE, "......handling PINGG : " + msg);
                    this.owner.getConsole().println(msg, true);
                    this.sendCommand(CMD_PONGG, this.owner.getRegisteredPseudo() + STR_DELIMITER + code + STR_DELIMITER, null, senderIP, senderPort);
                    this.expectMoreResponse = false;
                    continue;
                }
                if (command.equals(CMD_PONGG)) {
                    LOG.log(Level.FINE, "......handling PONGG command from user " + member + ".");
                    code = new String(bytesReceived).substring(this.COMM_CMD_SIZE + contentMemberBytes.length + 1, this.COMM_CMD_SIZE + contentMemberBytes.length + 3).trim();
                    if (code.isEmpty() || !code.startsWith("0")) {
                        code = "00";
                    }
                    if ("00".equals(code)) {
                        msg = NbBundle.getMessage(this.getClass(), (String)"MSG_SuccessConnection", (Object)member, (Object)code);
                        LOG.log(Level.FINE, "......" + msg);
                        if (this.userInProgress == null) {
                            aMember.addConnection();
                        }
                        this.expectMoreResponse = false;
                        continue;
                    }
                    msg = NbBundle.getMessage(this.getClass(), (String)"ERR_FailedConnection", (Object)member, (Object)NbBundle.getMessage(this.getClass(), (String)("ERR_CODE_" + code)));
                    LOG.log(Level.FINE, "......" + msg);
                    this.owner.getConsole().printError(msg, true);
                    this.expectMoreResponse = true;
                    continue;
                }
                ExpectedResponse response = new ExpectedResponse(aMember, command);
                if (command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_GMCxx)) {
                    if (this.csoMapCapsule.isEmpty()) {
                        this.csoMapCapsule.setPackets(this.buildPacketsOfObject(this.owner.getMapCapsule()));
                    }
                    this.processReceiveCommandGet(command, CMD_GMCxx, CMD_TMCxx, member, senderIP, senderPort, this.csoMapCapsule);
                    continue;
                }
                if (command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_TMCxx)) {
                    this.processReceiveCommandTake(command, CMD_TMCxx, member, this.csoMapCapsule, contentObj, response);
                    if (!this.csoMapCapsule.isComplete()) continue;
                    this.owner.updateUser(aMember, (STMapCapsule)this.unwrapObject(this.csoMapCapsule.getStream()));
                    continue;
                }
                if (command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_GMExx)) {
                    if (this.csoMapEventsCapsule.isEmpty()) {
                        this.csoMapEventsCapsule.setPackets(this.buildPacketsOfObject(this.owner.getMapEventsCapsule(aMember)));
                    }
                    this.processReceiveCommandGet(command, CMD_GMExx, CMD_TMExx, member, senderIP, senderPort, this.csoMapEventsCapsule);
                    continue;
                }
                if (command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_TMExx)) {
                    this.processReceiveCommandTake(command, CMD_TMExx, member, this.csoMapEventsCapsule, contentObj, response);
                    if (!this.csoMapEventsCapsule.isComplete()) continue;
                    this.owner.updateUser(aMember, (STMapEventsCapsule)this.unwrapObject(this.csoMapEventsCapsule.getStream()));
                    continue;
                }
                if (command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_GPFxx)) {
                    if (this.csoProfile.isEmpty()) {
                        this.csoProfile.setPackets(this.buildPacketsOfObject(this.owner.getMyProfile()));
                    }
                    this.processReceiveCommandGet(command, CMD_GPFxx, CMD_TPFxx, member, senderIP, senderPort, this.csoProfile);
                    continue;
                }
                if (!command.substring(0, this.COMM_CMD_PFX_SIZE).equals(CMD_TPFxx)) continue;
                this.processReceiveCommandTake(command, CMD_TPFxx, member, this.csoProfile, contentObj, response);
                if (!this.csoProfile.isComplete()) continue;
                this.owner.updateUser(aMember, (UserProfile)this.unwrapObject(this.csoProfile.getStream()));
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            this.displayErrorMessage("ERR_ReceivingMsg", null, "listen", ex, true);
        }
    }

    private void processReceiveCommandGet(String command, String commandGet, String commandBack, String member, String senderIP, int senderPort, CommStreamObject stream) {
        LOG.log(Level.FINE, "......handling " + commandGet + " command from user " + member + ".");
        Integer iPacket = Integer.valueOf(command.substring(this.COMM_CMD_PFX_SIZE, this.COMM_CMD_SIZE));
        String commandIndexed = commandBack + String.format(this.FMT_IDX, iPacket);
        byte[] set = (byte[])stream.sentPackets.get(iPacket);
        try {
            TimeUnit.MILLISECONDS.sleep(this.COMM_RESPONSE_DELAY);
        }
        catch (InterruptedException ex) {
            this.displayErrorMessage("ERR_ProcessingReceivedMsgGet", null, "processReceiveCommandGet", ex, true);
            return;
        }
        if (set == null) {
            commandIndexed = commandBack + String.format(this.FMT_IDX, this.COMM_PACKET_NB - 1);
            this.sendCommand(commandIndexed, this.owner.getRegisteredPseudo() + STR_DELIMITER, null, senderIP, senderPort);
        } else {
            this.sendCommand(commandIndexed, this.owner.getRegisteredPseudo() + STR_DELIMITER, set, senderIP, senderPort);
        }
    }

    private void processReceiveCommandTake(String command, String commandPut, String member, CommStreamObject stream, byte[] contentObj, ExpectedResponse response) {
        LOG.log(Level.FINE, "......handling " + commandPut + " command from user " + member + ".");
        stream.setComplete(false);
        Integer iPacket = Integer.valueOf(command.substring(this.COMM_CMD_PFX_SIZE, this.COMM_CMD_SIZE));
        if (iPacket == 0) {
            stream.init();
            LOG.log(Level.FINE, ".........iPacket=0 : initializing stream " + stream + " and storing packet 0.");
            try {
                stream.write((byte[])this.unwrapObject(contentObj));
            }
            catch (IOException ex) {
                this.displayErrorMessage("ERR_ProcessingReceivedMsgTake", null, "processReceiveCommandTake1", ex, true);
                return;
            }
        }
        if (iPacket == this.COMM_PACKET_NB - 1) {
            LOG.log(Level.FINE, ".........iPacket=" + iPacket + " (last) : Closing stream " + stream + " and updating user.");
            stream.setComplete(true);
        } else {
            LOG.log(Level.FINE, ".........iPacket=" + iPacket + " : storing packet to stream " + stream + " .");
            try {
                stream.write((byte[])this.unwrapObject(contentObj));
            }
            catch (IOException ex) {
                this.displayErrorMessage("ERR_ProcessingReceivedMsgTake", null, "processReceiveCommandTake2", ex, true);
                return;
            }
        }
        ExpectedResponse er = this.getExpectedResponse(response);
        if (er != null) {
            LOG.log(Level.FINE, ".........A response was expected and received, Clear it.");
            this.expectedResponses.remove(er);
        }
    }

    private byte[] extractBytes(byte[] content, byte delimiter) {
        byte[] ret = null;
        for (int i = 0; i < content.length; ++i) {
            byte b = content[i];
            if (b != delimiter && b != 0) continue;
            ret = Arrays.copyOfRange(content, 0, i);
            return ret;
        }
        ret = content;
        return ret;
    }

    private boolean connectToUser(ConnectedUserFrame user) {
        this.userInProgress = user;
        String log = "Connect to user=" + user != null ? user.getName() : "null";
        try {
            this.sendCommand(CMD_CONCT, user.getName(), null, "serv01.ancestris.org", this.COMM_PORT);
            this.expectMoreResponse = true;
            for (int s = 0; this.expectMoreResponse && s < this.REQUEST_TIMEOUT * 100; ++s) {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            if (this.expectMoreResponse) {
                this.expectMoreResponse = false;
                String msg = NbBundle.getMessage(this.getClass(), (String)"ERR_UserLeft", (Object)user.getName(), (Object)this.REQUEST_TIMEOUT);
                LOG.log(Level.FINE, "...(TIMEOUT) " + msg);
                this.owner.getConsole().printError(msg, true);
                return false;
            }
            TimeUnit.MILLISECONDS.sleep(500L);
            this.userInProgress = null;
        }
        catch (Exception ex) {
            this.displayErrorMessage("ERR_ConnectException", log, "connectToUser", ex, true);
            return false;
        }
        String msg = NbBundle.getMessage(this.getClass(), (String)"MSG_SuccessConnection", (Object)(user.getName() + " (" + user.getNbIndis() + "/" + user.getNbFams() + ")."), (Object)"OK");
        LOG.log(Level.FINE, "...(SUCCESS) " + msg);
        this.owner.getConsole().println(msg, true);
        return true;
    }

    public boolean getPackets(ConnectedUserFrame user, String command, Object object) {
        boolean returnStatus = false;
        if (socket == null || socket.isClosed()) {
            return returnStatus;
        }
        if (!this.communicationInProgress && !this.connectToUser(user)) {
            return returnStatus;
        }
        int iPacket = 0;
        boolean retry = true;
        int nbNoResponses = 0;
        LOG.log(Level.FINE, "Asking a GET to user " + user.getName() + " with command " + command);
        while (iPacket < this.COMM_PACKET_NB && nbNoResponses < this.COMM_NB_FAILS) {
            String commandIndexed = command + String.format(this.FMT_IDX, iPacket);
            try {
                this.sendCommand(commandIndexed, this.owner.getRegisteredPseudo() + STR_DELIMITER, iPacket == 0 ? object : null, user.getIPAddress(), Integer.valueOf(user.getPortAddress()));
                ExpectedResponse exResp = new ExpectedResponse(user, commandIndexed);
                this.expectedResponses.add(exResp);
                for (int s = 0; this.expectedResponses.contains(exResp) && s < this.REQUEST_TIMEOUT * 100; ++s) {
                    TimeUnit.MILLISECONDS.sleep(10L);
                }
                if (this.expectedResponses.contains(exResp)) {
                    ++nbNoResponses;
                    if (retry) {
                        LOG.log(Level.FINE, "...(TIMEOUT) No response from " + user.getName() + " after " + this.REQUEST_TIMEOUT + "s timeout. Retrying once...");
                        retry = false;
                        continue;
                    }
                    LOG.log(Level.FINE, "...(TIMEOUT) No response from " + user.getName() + " after " + this.REQUEST_TIMEOUT + "s timeout. Skip");
                    retry = true;
                    ++iPacket;
                    continue;
                }
                nbNoResponses = 0;
                retry = true;
                ++iPacket;
                if (command.equals(CMD_GMCxx) && this.csoMapCapsule.receivedStreamEOF) {
                    returnStatus = true;
                    break;
                }
                if (command.equals(CMD_GMExx) && this.csoMapEventsCapsule.receivedStreamEOF) {
                    returnStatus = true;
                    break;
                }
                if (!command.equals(CMD_GPFxx) || !this.csoProfile.receivedStreamEOF) continue;
                returnStatus = true;
                break;
            }
            catch (Exception ex) {
                this.displayErrorMessage("ERR_CallException", "Error getting packets", "getPackets", ex, true);
                return returnStatus;
            }
        }
        LOG.log(Level.FINE, "...(END) Returned call from member " + user.getName() + " after " + iPacket + " packets");
        return returnStatus;
    }

    public boolean putPackets(ConnectedUserFrame user, String command, Map<Integer, byte[]> packets) {
        int iPacket;
        boolean returnStatus = false;
        if (socket == null || socket.isClosed()) {
            return returnStatus;
        }
        if (!this.communicationInProgress && !this.connectToUser(user)) {
            return returnStatus;
        }
        String senderIP = user.getIPAddress();
        int senderPort = Integer.valueOf(user.getPortAddress());
        LOG.log(Level.FINE, "Asking a PUT to user " + user.getName() + " with command " + command);
        for (iPacket = 0; iPacket < this.COMM_PACKET_NB; ++iPacket) {
            String commandIndexed = command + String.format(this.FMT_IDX, iPacket);
            byte[] set = packets.get(iPacket);
            if (set == null) {
                commandIndexed = command + String.format(this.FMT_IDX, this.COMM_PACKET_NB - 1);
                this.sendCommand(commandIndexed, this.owner.getRegisteredPseudo() + STR_DELIMITER, null, senderIP, senderPort);
                returnStatus = true;
                break;
            }
            this.sendCommand(commandIndexed, this.owner.getRegisteredPseudo() + STR_DELIMITER, set, senderIP, senderPort);
            try {
                TimeUnit.MILLISECONDS.sleep(this.COMM_RESPONSE_DELAY);
                continue;
            }
            catch (InterruptedException ex) {
                this.displayErrorMessage("ERR_PutException", "Error putting packets", "putPackets", ex, true);
                return returnStatus;
            }
        }
        LOG.log(Level.FINE, "...(END) Enf of put to member " + user.getName() + " with " + iPacket + " packets");
        return returnStatus;
    }

    private boolean sendCommand(String command, String string, Object object, String ipAddress, int portAddress) {
        int s;
        byte[] msgBytes = null;
        String contentStr = command + string;
        byte[] contentBytes = contentStr.getBytes(Charset.forName(COMM_CHARSET));
        msgBytes = object == null ? contentBytes : this.getWrappedObject(contentBytes, object);
        if (msgBytes == null) {
            LOG.log(Level.FINE, "Sending command " + command + " using string '" + string + "' => Cannot wrap message. Abort communication.");
            return false;
        }
        if (!command.equals(CMD_PONGG)) {
            String dest = ipAddress + ":" + portAddress;
            if ("serv01.ancestris.org".equals(ipAddress)) {
                dest = "Server (" + ipAddress + ")";
            }
            LOG.log(Level.FINE, "Sending command " + command + " using string '" + string + "' and object of size (" + msgBytes.length + " bytes) to " + dest);
        }
        if ((s = msgBytes.length) > this.COMM_PACKET_SIZE) {
            Set testSet;
            LOG.log(Level.FINE, "./!\\ Object of size (" + s + " bytes) is larger than maximum packet size of " + this.COMM_PACKET_SIZE);
            boolean abort = true;
            if (object instanceof Set && (testSet = (Set)object).iterator().next() instanceof String) {
                abort = false;
            }
            if (!abort) {
                Set set = (Set)object;
                HashSet<String> subSet = new HashSet<String>();
                int factor = 2 * s / this.COMM_PACKET_SIZE + 3;
                int limit = set.size() / factor;
                int index = 0;
                byte[] tmpBytes = null;
                for (String str : set) {
                    subSet.add(str);
                    if (index > limit) {
                        tmpBytes = this.getWrappedObject(contentBytes, subSet);
                        s = tmpBytes.length;
                        if (s >= this.COMM_PACKET_SIZE) {
                            LOG.log(Level.FINE, ".You are the caller : number of common names has been truncated to first " + (limit - 10) + " names instead of " + set.size() + ".");
                            LOG.log(Level.FINE, ".Packet size is now (" + msgBytes.length + ") bytes.");
                            break;
                        }
                        msgBytes = tmpBytes;
                        limit += 10;
                    }
                    ++index;
                }
            } else {
                LOG.log(Level.FINE, ".You are the receiver : compression factor is currently set to " + this.COMM_COMPRESSING_FACTOR + " and should be increased by the developpers.");
                LOG.log(Level.FINE, ".=> Abort communication.");
                return false;
            }
        }
        return this.sendObject(msgBytes, ipAddress, portAddress);
    }

    private byte[] getWrappedObject(byte[] contentBytes, Object object) {
        byte[] ret = null;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            byteStream.write(contentBytes);
            byteStream.write(this.wrapObject(object));
            ret = byteStream.toByteArray();
        }
        catch (IOException ex) {
            this.displayErrorMessage("ERR_WrappedException", null, "getWrappedObject", ex, true);
        }
        return ret;
    }

    private byte[] wrapObject(Object object) {
        byte[] bytes = null;
        try {
            ByteArrayOutputStream contentStream = new ByteArrayOutputStream();
            GZIPOutputStream gz = new GZIPOutputStream(contentStream);
            ObjectOutputStream os = new ObjectOutputStream(gz);
            os.flush();
            os.writeObject(object);
            os.flush();
            gz.close();
            bytes = contentStream.toByteArray();
        }
        catch (IOException ex) {
            this.displayErrorMessage("ERR_WrapException", null, "wrapObject", ex, true);
        }
        return bytes;
    }

    private Object unwrapObject(byte[] content) {
        Object object = null;
        if (content == null || content.length == 0) {
            return null;
        }
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(content);
            ObjectInputStream is = new ObjectInputStream(new GZIPInputStream(byteStream));
            object = is.readObject();
            is.close();
        }
        catch (Exception ex) {
            String log = "Receiving message. Packet size was probably larger than the maximum packet size and therefore has been truncated, or packets have different sizes between the sender and the receiver. Please update your version of Ancestris or contact the Ancestris support.";
            this.displayErrorMessage("ERR_UnwrapException", log, "unwrapObject", ex, true);
        }
        return object;
    }

    private boolean sendObject(byte[] bytesSent, String ipAddress, int portAddress) {
        try {
            DatagramPacket packetSent = new DatagramPacket(bytesSent, bytesSent.length, InetAddress.getByName(ipAddress), portAddress);
            socket.send(packetSent);
        }
        catch (IOException ex) {
            this.displayErrorMessage("ERR_UnknownHostException", "Could not send object to " + ipAddress + ":" + portAddress, "sendObject", ex, true);
            return false;
        }
        return true;
    }

    private Map<Integer, byte[]> buildPacketsOfObject(Object capsule) {
        HashMap<Integer, byte[]> packets = new HashMap<Integer, byte[]>();
        byte[] masterPacket = this.wrapObject(capsule);
        int nbResized = 1024;
        int nbPackets = Math.min(this.COMM_PACKET_NB, masterPacket.length / nbResized) + 1;
        Integer i = 0;
        while (i < nbPackets) {
            if (i < nbPackets - 1) {
                packets.put(i, Arrays.copyOfRange(masterPacket, i * nbResized, (i + 1) * nbResized));
            } else {
                packets.put(i, Arrays.copyOfRange(masterPacket, i * nbResized, masterPacket.length));
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return packets;
    }

    private ExpectedResponse getExpectedResponse(ExpectedResponse response) {
        boolean sameMember = false;
        for (ExpectedResponse er : this.expectedResponses) {
            boolean bl = sameMember = response.fromMember.getName().equals(er.fromMember.getName()) && response.fromMember.getxIPAddress().equals(er.fromMember.getxIPAddress()) && response.fromMember.getxPortAddress().equals(er.fromMember.getxPortAddress());
            if (sameMember && response.forCommand.equals(er.forCommand)) {
                return er;
            }
            if (!sameMember) continue;
            String prefix1 = response.forCommand.substring(0, this.COMM_CMD_PFX_SIZE);
            String prefix2 = er.forCommand.substring(0, this.COMM_CMD_PFX_SIZE);
            Integer iPacket = Integer.valueOf(response.forCommand.substring(this.COMM_CMD_PFX_SIZE, this.COMM_CMD_SIZE));
            if (!prefix1.equals(prefix2) || iPacket != this.COMM_PACKET_NB - 1) continue;
            return er;
        }
        return null;
    }

    public void clearUserCommunication(ConnectedUserFrame member) {
        HashSet<ExpectedResponse> listToRemove = new HashSet<ExpectedResponse>();
        for (ExpectedResponse er : this.expectedResponses) {
            if (!member.getName().equals(er.fromMember.getName()) || !member.getIPAddress().equals(er.fromMember.getIPAddress()) || !member.getPortAddress().equals(er.fromMember.getPortAddress())) continue;
            listToRemove.add(er);
        }
        if (!listToRemove.isEmpty()) {
            this.expectedResponses.removeAll(listToRemove);
        }
    }

    private boolean isSameAddress(String senderAddress, ConnectedUserFrame aMember) {
        if (!aMember.isActive()) {
            LOG.log(Level.FINE, ".........member was not active (probably disconnected then reconnected). Reactivate it and memorize new address.");
            aMember.setActive(true);
            aMember.setIPAddress(senderAddress);
            return true;
        }
        if (senderAddress.equals(aMember.getxIPAddress() + ":" + aMember.getxPortAddress())) {
            return true;
        }
        if (senderAddress.equals(aMember.getpIPAddress() + ":" + aMember.getpPortAddress())) {
            if (this.userInProgress != null) {
                this.userInProgress.setUsePrivateIP(true);
            }
            return true;
        }
        LOG.log(Level.FINE, ".........address mismatch : senderAddress=" + senderAddress + " - IPAddress=" + aMember.getxIPAddress() + ":" + aMember.getxPortAddress() + " - IPpAddress=" + aMember.getpIPAddress() + ":" + aMember.getpPortAddress());
        return false;
    }

    private void displayErrorMessage(String bundle_err, String log_msg, String location, Exception ex, boolean display) {
        final String title = NbBundle.getMessage(GedcomCompareTopComponent.class, (String)"OpenIDE-Module-Name") + " - " + NbBundle.getMessage(Comm.class, (String)"TTL_CommunicationError");
        String exception_msg = ex != null && ex.getMessage() != null ? ex.getMessage().replace("serv01.ancestris.org", "www.ancestris.server") : "";
        final String msg = NbBundle.getMessage(Comm.class, (String)bundle_err, (Object)exception_msg);
        LOG.log(Level.SEVERE, title + " : " + msg);
        LOG.log(Level.SEVERE, location + "()");
        if (log_msg != null && !log_msg.isEmpty()) {
            LOG.log(Level.SEVERE, log_msg);
        }
        this.sharing = false;
        if (!this.isCommError) {
            this.isCommError = true;
            if (ex != null && display) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Comm.this.owner.getConsole().printError(title + " : " + msg, true);
                    DialogManager.create((String)title, (String)msg).setOptionType(10).setMessageType(0).show();
                }
            });
            this.owner.stopSharing();
        }
    }

    private static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception ex) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + ex);
            unknownHostException.initCause(ex);
            throw unknownHostException;
        }
    }

    private class CommStreamObject {
        private Map<Integer, byte[]> sentPackets = null;
        private ByteArrayOutputStream receivedStream = null;
        private boolean receivedStreamEOF = false;

        public void reset() {
            this.receivedStream = null;
            this.receivedStreamEOF = false;
        }

        public void setPackets(Map<Integer, byte[]> packets) {
            this.sentPackets = packets;
        }

        public Map<Integer, byte[]> getPackets() {
            return this.sentPackets;
        }

        public boolean isEmpty() {
            return this.sentPackets == null;
        }

        public boolean isComplete() {
            return this.receivedStreamEOF;
        }

        public void setComplete(boolean set) {
            this.receivedStreamEOF = set;
        }

        public byte[] getStream() {
            return this.receivedStream.toByteArray();
        }

        public void init() {
            if (this.receivedStream == null) {
                this.receivedStream = new ByteArrayOutputStream();
            } else {
                this.receivedStream.reset();
            }
        }

        public void write(byte[] bytes) throws IOException {
            this.receivedStream.write(bytes);
        }
    }

    public class User {
        public UserProfile userProfile;
        public String f_NbIndis;
        public String f_NbFamilies;
        public String f_NbSTs;
        public String f_NbEvens;
        public String[] f_STs;
        public String stats_nbOveraps;
        public String stats_nbCityNames;
        public String stats_nbEvents;

        public User(UserProfile userProfile, String f_NbIndis, String f_NbFamilies, String f_NbSTs, String f_NbEvens, String[] f_STs, String over, String cina, String even) {
            this.userProfile = userProfile;
            this.f_NbIndis = f_NbIndis;
            this.f_NbFamilies = f_NbFamilies;
            this.f_NbSTs = f_NbSTs;
            this.f_NbEvens = f_NbEvens;
            this.f_STs = f_STs;
            this.stats_nbOveraps = over;
            this.stats_nbCityNames = cina;
            this.stats_nbEvents = even;
        }
    }

    private class ExpectedResponse {
        private ConnectedUserFrame fromMember = null;
        private String forCommand = "";

        public ExpectedResponse(ConnectedUserFrame member, String command) {
            this.fromMember = member;
            this.forCommand = command.replace("G", "T");
        }
    }
}

