/*
 * Decompiled with CFR 0.152.
 */
package org.miv.mbox.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.miv.mbox.CannotPostException;
import org.miv.mbox.MBox;
import org.miv.mbox.MBoxListener;
import org.miv.mbox.MBoxStandalone;
import org.miv.mbox.net.IdAlreadyInUseException;
import org.miv.mbox.net.MBoxLocator;
import org.miv.mbox.net.Packet;
import org.miv.mbox.net.PositionableByteArrayInputStream;

public class Receiver
extends Thread {
    protected MBoxLocator locator;
    protected ServerSocketChannel server;
    protected Selector selector;
    protected SelectionKey key;
    protected boolean loop = true;
    protected boolean debug = true;
    protected String lastError = null;
    protected HashMap<String, MBox> boxes = new HashMap();
    protected HashMap<SelectionKey, IncomingBuffer> incoming = new HashMap();
    protected static final String LIGHT_YELLOW = "\u001b[33;1m";
    protected static final String RESET = "\u001b[0m";

    public Receiver(MBoxLocator locator) throws IOException, UnknownHostException {
        this(locator.getHostname(), locator.getPort());
    }

    public Receiver(MBoxLocator locator, boolean debug) throws IOException, UnknownHostException {
        this(locator.getHostname(), locator.getPort(), debug);
    }

    public Receiver(String hostname, int port) throws IOException, UnknownHostException {
        this(hostname, port, false);
    }

    public Receiver(String hostname, int port, boolean debug) throws IOException, UnknownHostException {
        this.locator = new MBoxLocator(hostname, port);
        this.setDebugOn(debug);
        this.init();
        this.start();
    }

    public synchronized boolean isRunning() {
        return this.loop;
    }

    public MBoxLocator getLocator() {
        return this.locator;
    }

    public synchronized MBox getMBox(String name) {
        return this.boxes.get(name);
    }

    protected void init() throws IOException, UnknownHostException {
        this.selector = Selector.open();
        this.server = ServerSocketChannel.open();
        this.server.configureBlocking(false);
        InetAddress ia = InetAddress.getByName(this.locator.getHostname());
        InetSocketAddress isa = new InetSocketAddress(ia, this.locator.getPort());
        this.server.socket().bind(isa);
        if (this.debug) {
            this.debug("bound to socket %s:%d", this.server.socket().getInetAddress(), this.server.socket().getLocalPort());
        }
        this.key = this.server.register(this.selector, 16);
    }

    public void setDebugOn(boolean on) {
        this.debug = on;
    }

    public synchronized MBoxStandalone register(String name, MBoxListener listener) throws IdAlreadyInUseException {
        if (this.boxes.containsKey(name)) {
            throw new IdAlreadyInUseException("name " + name + " already registered");
        }
        MBoxStandalone mbox = new MBoxStandalone(listener);
        this.boxes.put(name, mbox);
        if (this.debug) {
            this.debug("registered message box %s", name);
        }
        return mbox;
    }

    public synchronized void register(String name, MBox box) throws IdAlreadyInUseException {
        if (this.boxes.containsKey(name)) {
            throw new IdAlreadyInUseException("name " + name + " already registered");
        }
        this.boxes.put(name, box);
        if (this.debug) {
            this.debug("registered message box %s", name);
        }
    }

    public synchronized void quit() {
        this.loop = false;
        this.key.selector().wakeup();
        if (this.debug) {
            this.debug("stopped", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean l;
        Receiver receiver = this;
        synchronized (receiver) {
            l = this.loop;
        }
        while (l) {
            this.poll();
            receiver = this;
            synchronized (receiver) {
                l = this.loop;
            }
        }
        try {
            this.server.close();
        }
        catch (IOException e) {
            this.error("cannot close the server socket: " + e.getMessage(), e);
        }
        this.debug("receiver " + this.locator + " finished", new Object[0]);
    }

    public void poll() {
        try {
            if (this.key.selector().select() > 0) {
                Set<SelectionKey> readyKeys = this.selector.selectedKeys();
                Iterator<SelectionKey> i = readyKeys.iterator();
                while (i.hasNext()) {
                    SelectionKey akey = i.next();
                    i.remove();
                    if (akey.isAcceptable()) {
                        ServerSocketChannel ssocket = (ServerSocketChannel)akey.channel();
                        SocketChannel socket = ssocket.accept();
                        if (this.debug) {
                            this.debug("accepting socket %s:%d", socket.socket().getInetAddress(), socket.socket().getPort());
                        }
                        socket.configureBlocking(false);
                        socket.finishConnect();
                        socket.register(this.selector, 1);
                        continue;
                    }
                    if (akey.isReadable()) {
                        this.readDataChunk(akey);
                        continue;
                    }
                    if (!akey.isWritable()) continue;
                    throw new RuntimeException("should not happen");
                }
            }
        }
        catch (IOException e) {
            this.error(e, "I/O error in receiver %s thread: aborting: %s", this.locator, e.getMessage());
            this.loop = false;
        }
        catch (Throwable e) {
            this.error(e, "Unknown error: %s", e.getMessage());
            this.loop = false;
        }
    }

    protected void readDataChunk(SelectionKey key) throws IOException {
        IncomingBuffer buf = this.incoming.get(key);
        if (buf == null) {
            buf = new IncomingBuffer();
            this.incoming.put(key, buf);
            SocketChannel socket = (SocketChannel)key.channel();
            if (this.debug) {
                this.debug("creating buffer for new connection from %s:%d", socket.socket().getInetAddress(), socket.socket().getPort());
            }
        }
        try {
            buf.readDataChunk(key);
        }
        catch (IOException e) {
            this.incoming.remove(key);
            e.printStackTrace();
            this.error(e, "receiver %s cannot read object socket channel (I/O error): %s", this.locator.toString(), e.getMessage());
            this.loop = false;
        }
    }

    protected void error(String message, Object ... data) {
        this.error(null, message, data);
    }

    protected void error(Throwable e, String message, Object ... data) {
        System.err.print(LIGHT_YELLOW);
        System.err.print("[");
        System.err.print(RESET);
        System.err.printf(message, data);
        System.err.print(LIGHT_YELLOW);
        System.err.print("]");
        System.err.println(RESET);
        if (e != null) {
            e.printStackTrace();
        }
    }

    protected void debug(String message, Object ... data) {
        System.err.print(LIGHT_YELLOW);
        System.err.printf("[%s|", this.locator.toString());
        System.err.print(RESET);
        System.err.printf(message, data);
        System.err.print(LIGHT_YELLOW);
        System.err.print("]");
        System.err.println(RESET);
    }

    protected class IncomingBuffer {
        protected static final int BUFFER_INITIAL_SIZE = 8192;
        protected ByteBuffer buf = ByteBuffer.allocate(8192);
        protected int end = -1;
        protected int beg = 0;
        protected int pos = 0;
        ObjectInputStream in;
        PositionableByteArrayInputStream bin;
        protected boolean active = false;

        public void readDataChunk(SelectionKey key) throws IOException {
            int limit = 0;
            int nbytes = 0;
            SocketChannel socket = (SocketChannel)key.channel();
            nbytes = this.bufferize(this.pos, socket);
            limit = this.pos + nbytes;
            if (nbytes <= 0) {
                return;
            }
            if (this.end < 0) {
                if (limit - this.beg >= 4) {
                    this.buf.position(0);
                    this.end = this.buf.getInt() + 4;
                    this.beg = 4;
                } else {
                    this.pos = limit;
                }
            }
            if (this.end > 0) {
                while (this.end < limit) {
                    this.decodeMessage(limit);
                    this.buf.position(this.end);
                    if (this.end + 4 <= limit) {
                        this.beg = this.end + 4;
                        this.end = this.end + this.buf.getInt() + 4;
                        continue;
                    }
                    assert (this.beg >= 4);
                    this.beg = this.end;
                    int p = 4 - (this.end + 4 - limit);
                    this.compactBuffer();
                    this.pos = p;
                    this.beg = 0;
                    this.end = -1;
                    break;
                }
                if (this.end == limit) {
                    this.decodeMessage(limit);
                    this.buf.clear();
                    this.pos = 0;
                    this.beg = 0;
                    this.end = -1;
                } else if (this.end > limit) {
                    this.pos = limit;
                    if (this.end > this.buf.capacity()) {
                        this.compactBuffer();
                    }
                }
            }
        }

        protected int bufferize(int at, SocketChannel socket) throws IOException {
            int nbytes = 0;
            try {
                this.buf.position(at);
                nbytes = socket.read(this.buf);
                if (nbytes < 0) {
                    this.active = false;
                    if (this.in != null) {
                        this.in.close();
                    }
                    socket.close();
                    if (Receiver.this.debug) {
                        Receiver.this.debug("socket from %s:%d closed", socket.socket().getInetAddress(), socket.socket().getPort());
                    }
                    return nbytes;
                }
                if (nbytes == 0) {
                    throw new RuntimeException("should not happen: buffer to small, 0 bytes read: compact does not function? messages is larger than " + this.buf.capacity() + "?");
                }
                this.buf.position(at);
                return nbytes;
            }
            catch (IOException e) {
                if (Receiver.this.debug) {
                    Receiver.this.debug("socket from %s:%d I/O error: %s", socket.socket().getInetAddress(), socket.socket().getPort(), e.getMessage());
                }
                this.active = false;
                if (this.in != null) {
                    this.in.close();
                }
                socket.close();
                throw e;
            }
        }

        protected void decodeMessage(int limit) throws IOException {
            Object o = null;
            if (this.in == null) {
                this.bin = new PositionableByteArrayInputStream(this.buf.array(), this.beg, this.end);
                this.in = new ObjectInputStream(this.bin);
            } else {
                this.bin.setPos(this.beg, this.end);
            }
            try {
                o = this.in.readObject();
            }
            catch (Throwable e) {
                throw new IOException("error in object deserialization: " + e.getMessage());
            }
            if (o instanceof Packet) {
                Packet pckt = (Packet)o;
                MBox mbox = Receiver.this.getMBox(pckt.getTo());
                if (mbox != null) {
                    try {
                        mbox.post(pckt.from, pckt.data);
                        Thread.yield();
                    }
                    catch (CannotPostException e) {
                        Receiver.this.error("message from %s to %s ignored since it cannot be posted, error: %s", pckt.getFrom(), pckt.getTo(), e.getMessage());
                    }
                } else {
                    Receiver.this.error("message from %s to %s ignored since it has no registered MBox destination in this receiver (alive=%b)", pckt.getFrom(), pckt.getTo(), pckt.getTo(), Thread.currentThread().isAlive());
                }
            } else {
                throw new IOException("received an object that is a not a Message instance");
            }
        }

        protected int compactBuffer() {
            if (this.beg > 4) {
                int off = this.beg;
                this.buf.position(this.beg);
                this.buf.limit(this.buf.capacity());
                this.buf.compact();
                this.pos -= this.beg;
                this.end -= this.beg;
                this.beg = 0;
                return off;
            }
            return 0;
        }

        protected void enlargeBuffer() {
            ByteBuffer tmp = ByteBuffer.allocate(this.buf.capacity() * 2);
            this.buf.position(0);
            this.buf.limit(this.buf.capacity());
            tmp.put(this.buf);
            tmp.position(this.pos);
            this.buf = tmp;
            if (this.bin != null) {
                this.bin.changeBuffer(this.buf.array());
            }
        }
    }
}

