/*
 * Decompiled with CFR 0.152.
 */
package org.miv.pherd;

import java.util.HashMap;
import java.util.Iterator;
import org.miv.pherd.ParticleBox;
import org.miv.pherd.ParticleBoxListener;
import org.miv.pherd.geom.Point3;
import org.miv.pherd.ntree.Cell;

public abstract class Particle {
    protected Object id;
    protected Point3 pos;
    protected Point3 nextPos = new Point3();
    protected double weight = 1.0;
    protected Cell cell;
    protected ParticleBox box = null;
    protected HashMap<String, Object> attributes;
    protected boolean moved;

    public Particle(Object id, double x, double y, double z) {
        this.id = id;
        this.initPos(x, y, z);
    }

    public Particle(Object id) {
        this.id = id;
        this.initPos(0.0, 0.0, 0.0);
    }

    protected void initPos(double x, double y, double z) {
        this.pos = new Point3(x, y, z);
        this.nextPos.copy(this.pos);
    }

    public Object getId() {
        return this.id;
    }

    public Point3 getPosition() {
        return this.pos;
    }

    public Cell getCell() {
        return this.cell;
    }

    public boolean closeTo(Particle other) {
        return this.closeTo(other, 0.001f);
    }

    public boolean closeTo(Particle other, double delta) {
        double d = this.pos.distance(other.pos);
        return d <= delta;
    }

    public double getWeight() {
        return this.weight;
    }

    public Object getAttribute(String attribute) {
        if (this.attributes != null) {
            return this.attributes.get(attribute);
        }
        return null;
    }

    public Iterator<String> getAttributeKeyIterator() {
        if (this.attributes != null) {
            return this.attributes.keySet().iterator();
        }
        return null;
    }

    public void setCell(Cell responsible) {
        this.cell = responsible;
    }

    public void setWeight(double newWeight) {
        this.weight = newWeight;
        if (this.cell != null) {
            this.cell.getData().recompute();
        }
    }

    public void setAttribute(String attribute, Object ... values) {
        Object v = values == null || values.length == 0 ? Boolean.valueOf(true) : (values.length == 1 ? values[0] : values);
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(attribute, v);
        if (this.box != null && this.box.listeners != null) {
            for (ParticleBoxListener listener : this.box.listeners) {
                listener.particleAttributeChanged(this.id, attribute, v, false);
            }
        }
    }

    public void removeAttribute(String attribute) {
        if (this.attributes != null) {
            this.attributes.remove(attribute);
            if (this.box != null && this.box.listeners != null) {
                for (ParticleBoxListener listener : this.box.listeners) {
                    listener.particleAttributeChanged(this.id, attribute, null, true);
                }
            }
        }
    }

    public abstract void move(int var1);

    public abstract void inserted();

    public abstract void removed();

    public void nextStep(int time) {
        if (this.moved) {
            this.pos.copy(this.nextPos);
            assert (this.cell != null) : "No responsible cell ?";
            this.cell.particleMoved(this);
            for (ParticleBoxListener listener : this.box.listeners) {
                listener.particleMoved(this.id, this.pos.x, this.pos.y, this.pos.z);
            }
            this.moved = false;
        }
    }

    protected void setBox(ParticleBox box) {
        assert (box == null && this.box != null || box != null && this.box == null) : "Particle in two boxes at a time ?";
        this.box = box;
    }

    public void suicide() {
        if (this.box != null) {
            this.box.removeParticle(this.id);
        }
    }
}

