/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.views.graph;

import ancestris.modules.views.graph.LabelFamEnum;
import ancestris.modules.views.graph.LabelIndiEnum;
import genj.util.Registry;
import java.util.Formatter;

public class GraphParameter {
    private static final String CSS = "node.sosa {    fill-color:%s;    size: %s;}node.mariage {    fill-color:%s;}node.mariagesosa {    fill-color:%s;    size: %s;}edge.sosa {    fill-color:%s;    size: %s;}edge.mariage {    fill-color:%s;}edge.asso {    fill-color:%s; }node.cujus {    fill-color:%s;\t   size: %s;}edge {    size: %s;    fill-color:%s;}node {\t   size: %s;    fill-color:%s;}node.sticked {\tfill-color:%s;}edge.sticked {\tfill-color:%s;}graph {\tfill-color:%s;}";
    private static final String GEN_SCHEME = "node.sosa {    fill-color:lightgray, %s, black;    fill-mode: dyn-plain;}node {\t   fill-mode: dyn-plain;    fill-color:lightgray, %s, black;}node.sticked {\t   fill-mode: dyn-plain;    fill-color:lightgray, %s, black;}";
    private boolean showLabel = false;
    private boolean autoDisplay = true;
    private boolean centerGraph = false;
    private boolean hideNodes = false;
    private boolean showAsso = false;
    private boolean doPath = false;
    private String colorDef = "#000000";
    private String colorSosa = "#006400";
    private String colorMariage = "#FF4500";
    private String colorAsso = "#708090";
    private String colorCujus = "#FF00FF";
    private String colorSticked = "#0000FF";
    private String colorBack = "#FFFFFF";
    private String colorMariageSosa = "#FFCC33";
    private String sizeEdge = "2";
    private String sizeNode = "8";
    private String sizeCujus = "20";
    private String sizeNodeSosa = "8";
    private String sizeEdgeSosa = "2";
    private double indiNodeWeight = 10.0;
    private double mariageNodeWeight = 5.0;
    private double edgeWeight = 1.0;
    private boolean useGenerationScheme = false;
    private LabelFamEnum labelFam = LabelFamEnum.FAM_DATE;
    private LabelIndiEnum labelIndi = LabelIndiEnum.INDI_NAME;

    public String getCss() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format(CSS, this.colorSosa, this.sizeNodeSosa, this.colorMariage, this.colorMariageSosa, this.sizeNodeSosa, this.colorSosa, this.sizeEdgeSosa, this.colorMariage, this.colorAsso, this.colorCujus, this.sizeCujus, this.sizeEdge, this.colorDef, this.sizeNode, this.colorDef, this.colorSticked, this.colorSticked, this.colorBack);
        return sb.toString();
    }

    public String getGenerationScheme() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format(GEN_SCHEME, this.colorSticked, this.colorSticked, this.colorSticked);
        return sb.toString();
    }

    public void loadSettings(Registry registry) {
        this.colorDef = registry.get("GRAPH.color.default", "#000000");
        this.colorSosa = registry.get("GRAPH.color.sosa", "#006400");
        this.colorMariage = registry.get("GRAPH.color.marriage", "#FF4500");
        this.colorAsso = registry.get("GRAPH.color.asso", "#708090");
        this.colorCujus = registry.get("GRAPH.color.cujus", "#FF00FF");
        this.colorSticked = registry.get("GRAPH.color.sticked", "#0000FF");
        this.colorBack = registry.get("GRAPH.color.back", "#FFFFFF");
        this.colorMariageSosa = registry.get("GRAPH.color.marriage.sosa", "#FFCC33");
        this.sizeEdge = registry.get("GRAPH.size.edge", "2");
        this.sizeNode = registry.get("GRAPH.size.node", "8");
        this.sizeCujus = registry.get("GRAPH.size.cujus", "20");
        this.sizeNodeSosa = registry.get("GRAPH.size.node.sosa", "8");
        this.sizeEdgeSosa = registry.get("GRAPH.size.edge.sosa", "2");
        this.indiNodeWeight = Double.valueOf(registry.get("GRAPH.weight.node.indi", "10.0"));
        this.mariageNodeWeight = Double.valueOf(registry.get("GRAPH.weight.node.fam", "5.0"));
        this.edgeWeight = Double.valueOf(registry.get("GRAPH.weight.edge", "1.0"));
        this.labelFam = LabelFamEnum.valueOf(registry.get("GRAPH.fam.labels", "FAM_DATE"));
        this.labelIndi = LabelIndiEnum.valueOf(registry.get("GRAPH.indi.labels", "INDI_NAME"));
        this.useGenerationScheme = Boolean.valueOf(registry.get("GRAPH.color.scheme", "false"));
    }

    public void saveSettings(Registry registry) {
        registry.put("GRAPH.color.default", this.colorDef);
        registry.put("GRAPH.color.sosa", this.colorSosa);
        registry.put("GRAPH.color.marriage", this.colorMariage);
        registry.put("GRAPH.color.child", this.colorAsso);
        registry.put("GRAPH.color.cujus", this.colorCujus);
        registry.put("GRAPH.color.sticked", this.colorSticked);
        registry.put("GRAPH.color.back", this.colorBack);
        registry.put("GRAPH.color.marriage.sosa", this.colorMariageSosa);
        registry.put("GRAPH.size.edge", this.sizeEdge);
        registry.put("GRAPH.size.node", this.sizeNode);
        registry.put("GRAPH.size.cujus", this.sizeCujus);
        registry.put("GRAPH.size.node.sosa", this.sizeNodeSosa);
        registry.put("GRAPH.size.edge.sosa", this.sizeEdgeSosa);
        registry.put("GRAPH.weight.node.indi", String.valueOf(this.indiNodeWeight));
        registry.put("GRAPH.weight.node.fam", String.valueOf(this.mariageNodeWeight));
        registry.put("GRAPH.weight.edge", String.valueOf(this.edgeWeight));
        registry.put("GRAPH.fam.labels", this.labelFam.name());
        registry.put("GRAPH.indi.labels", this.labelIndi.name());
        registry.put("GRAPH.color.scheme", Boolean.valueOf(this.useGenerationScheme));
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public boolean isAutoDisplay() {
        return this.autoDisplay;
    }

    public void setAutoDisplay(boolean autoDisplay) {
        this.autoDisplay = autoDisplay;
    }

    public boolean isCenterGraph() {
        return this.centerGraph;
    }

    public void setCenterGraph(boolean centerGraph) {
        this.centerGraph = centerGraph;
    }

    public String getColorDef() {
        return this.colorDef;
    }

    public void setColorDef(String colorDef) {
        this.colorDef = colorDef;
    }

    public String getColorSosa() {
        return this.colorSosa;
    }

    public void setColorSosa(String colorSosa) {
        this.colorSosa = colorSosa;
    }

    public String getColorMariage() {
        return this.colorMariage;
    }

    public void setColorMariage(String colorMariage) {
        this.colorMariage = colorMariage;
    }

    public String getColorAsso() {
        return this.colorAsso;
    }

    public void setColorAsso(String colorAsso) {
        this.colorAsso = colorAsso;
    }

    public String getColorCujus() {
        return this.colorCujus;
    }

    public void setColorCujus(String colorCujus) {
        this.colorCujus = colorCujus;
    }

    public String getColorSticked() {
        return this.colorSticked;
    }

    public void setColorSticked(String colorSticked) {
        this.colorSticked = colorSticked;
    }

    public String getColorBack() {
        return this.colorBack;
    }

    public void setColorBack(String colorBack) {
        this.colorBack = colorBack;
    }

    public String getColorMariageSosa() {
        return this.colorMariageSosa;
    }

    public void setColorMariageSosa(String colorMariageSosa) {
        this.colorMariageSosa = colorMariageSosa;
    }

    public String getSizeEdge() {
        return this.sizeEdge;
    }

    public void setSizeEdge(String sizeEdge) {
        this.sizeEdge = sizeEdge;
    }

    public String getSizeNode() {
        return this.sizeNode;
    }

    public void setSizeNode(String sizeNode) {
        this.sizeNode = sizeNode;
    }

    public String getSizeCujus() {
        return this.sizeCujus;
    }

    public void setSizeCujus(String sizeCujus) {
        this.sizeCujus = sizeCujus;
    }

    public String getSizeNodeSosa() {
        return this.sizeNodeSosa;
    }

    public void setSizeNodeSosa(String sizeNodeSosa) {
        this.sizeNodeSosa = sizeNodeSosa;
    }

    public String getSizeEdgeSosa() {
        return this.sizeEdgeSosa;
    }

    public void setSizeEdgeSosa(String sizeEdgeSosa) {
        this.sizeEdgeSosa = sizeEdgeSosa;
    }

    public double getIndiNodeWeight() {
        return this.indiNodeWeight;
    }

    public void setIndiNodeWeight(double indiNodeWeight) {
        this.indiNodeWeight = indiNodeWeight;
    }

    public double getMariageNodeWeight() {
        return this.mariageNodeWeight;
    }

    public void setMariageNodeWeight(double mariageNodeWeight) {
        this.mariageNodeWeight = mariageNodeWeight;
    }

    public double getEdgeWeight() {
        return this.edgeWeight;
    }

    public void setEdgeWeight(double edgeWeight) {
        this.edgeWeight = edgeWeight;
    }

    public LabelFamEnum getLabelFam() {
        return this.labelFam;
    }

    public void setLabelFam(LabelFamEnum labelFam) {
        this.labelFam = labelFam;
    }

    public LabelIndiEnum getLabelIndi() {
        return this.labelIndi;
    }

    public void setLabelIndi(LabelIndiEnum labelIndi) {
        this.labelIndi = labelIndi;
    }

    public boolean isHideNodes() {
        return this.hideNodes;
    }

    public void setHideNodes(boolean hideNodes) {
        this.hideNodes = hideNodes;
    }

    public boolean isShowAsso() {
        return this.showAsso;
    }

    public void setShowAsso(boolean showAsso) {
        this.showAsso = showAsso;
    }

    public boolean isDoPath() {
        return this.doPath;
    }

    public void setDoPath(boolean doPath) {
        this.doPath = doPath;
    }

    public boolean isUseGenerationScheme() {
        return this.useGenerationScheme;
    }

    public void setUseGenerationScheme(boolean useGenerationScheme) {
        this.useGenerationScheme = useGenerationScheme;
    }
}

