/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.views.graph;

import ancestris.awt.FilteredMouseAdapter;
import ancestris.modules.views.graph.DisplayPathElement;
import ancestris.modules.views.graph.ResultsList;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Property;
import genj.view.ViewContext;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ResultWidget
extends JList<DisplayPathElement>
implements ListSelectionListener,
ListCellRenderer<DisplayPathElement> {
    private final ResultsList results;
    private final JTextPane text = new JTextPane();
    private final Context context;

    public ResultWidget() {
        this.results = new ResultsList();
        this.context = new Context();
    }

    public ResultWidget(ResultsList results, Context context) {
        super(results);
        this.results = results;
        this.context = context;
        this.init();
    }

    private void init() {
        this.setCellRenderer(this);
        this.setFixedCellHeight(18);
        this.addListSelectionListener(this);
        this.text.setOpaque(true);
        this.addMouseListener((MouseListener)new FilteredMouseAdapter(){

            public void mouseClickedFiltered(MouseEvent e) {
                Property cell;
                int row = ResultWidget.this.getSelectedIndex();
                if (row >= 0 && (cell = ResultWidget.this.results.getHit(row).getProperty()) != null) {
                    SelectionDispatcher.fireSelection((AWTEvent)e, (Context)new Context(cell));
                }
            }
        });
    }

    public ViewContext getContext() {
        if (this.context == null) {
            return null;
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Object selection1 : this.getSelectedValuesList()) {
            DisplayPathElement hit = (DisplayPathElement)selection1;
            properties.add(hit.getProperty());
        }
        return new ViewContext(this.context.getGedcom(), null, properties);
    }

    @Override
    public Component getListCellRendererComponent(JList list, DisplayPathElement value, int index, boolean isSelected, boolean cellHasFocus) {
        this.text.setBorder(isSelected ? BorderFactory.createLineBorder(this.getSelectionBackground(), 1, false) : BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.text.setDocument(value.getDocument());
        return this.text;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int row = this.getSelectedIndex();
        if (row >= 0) {
            SelectionDispatcher.fireSelection((Context)new Context(this.results.getHit(row).getProperty()));
        }
    }
}

