/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.views.graph.graphstream;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.graphstream.graph.Node;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.GraphicSprite;
import org.graphstream.ui.view.View;
import org.graphstream.ui.view.util.MouseManager;

public class AncestrisMouseManager
implements MouseManager {
    protected View view;
    protected GraphicGraph graph;
    protected GraphicElement curElement;
    protected float x1;
    protected float y1;

    public void init(GraphicGraph graph, View view) {
        this.view = view;
        this.graph = graph;
        view.addMouseListener((MouseListener)((Object)this));
        view.addMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void release() {
        this.view.removeMouseListener((MouseListener)((Object)this));
        this.view.removeMouseMotionListener((MouseMotionListener)((Object)this));
    }

    protected void mouseButtonPress(MouseEvent event) {
        this.view.requestFocus();
        if (!event.isShiftDown()) {
            for (Node node : this.graph) {
                if (!node.hasAttribute("ui.selected")) continue;
                node.removeAttribute("ui.selected");
            }
            for (GraphicSprite sprite : this.graph.spriteSet()) {
                if (!sprite.hasAttribute("ui.selected")) continue;
                sprite.removeAttribute("ui.selected");
            }
        }
    }

    protected void mouseButtonRelease(MouseEvent event, Iterable<GraphicElement> elementsInArea) {
        for (GraphicElement element : elementsInArea) {
            if (element.hasAttribute("ui.selected")) continue;
            element.addAttribute("ui.selected", new Object[0]);
        }
    }

    protected void mouseButtonPressOnElement(GraphicElement element, MouseEvent event) {
        this.view.freezeElement(element, true);
        if (event.getButton() == 3) {
            element.addAttribute("ui.selected", new Object[0]);
        } else {
            element.addAttribute("ui.clicked", new Object[0]);
        }
    }

    protected void elementMoving(GraphicElement element, MouseEvent event) {
        this.view.moveElementAtPx(element, (double)event.getX(), (double)event.getY());
    }

    protected void mouseButtonReleaseOffElement(GraphicElement element, MouseEvent event) {
        this.view.freezeElement(element, false);
        if (event.getButton() != 3) {
            element.removeAttribute("ui.clicked");
        }
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        this.curElement = this.view.findNodeOrSpriteAt((double)event.getX(), (double)event.getY());
        if (this.curElement != null) {
            this.mouseButtonPressOnElement(this.curElement, event);
        } else {
            this.x1 = event.getX();
            this.y1 = event.getY();
            this.mouseButtonPress(event);
        }
    }

    public void mouseDragged(MouseEvent event) {
        if (this.curElement != null) {
            this.elementMoving(this.curElement, event);
        } else {
            double deltaX = (float)event.getX() - this.x1;
            double deltaY = (float)event.getY() - this.y1;
            Point3 p = this.view.getCamera().getViewCenter();
            Point3 p1 = this.view.getCamera().transformGuToPx(p.x, p.y, p.z);
            Point3 p2 = this.view.getCamera().transformPxToGu(p1.x - deltaX, p1.y - deltaY);
            this.view.getCamera().setViewCenter(p2.x, p2.y, p.z);
            this.x1 = event.getX();
            this.y1 = event.getY();
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (this.curElement != null) {
            this.mouseButtonReleaseOffElement(this.curElement, event);
            this.curElement = null;
        } else {
            float t;
            float x2 = event.getX();
            float y2 = event.getY();
            if (this.x1 > x2) {
                t = this.x1;
                this.x1 = x2;
                x2 = t;
            }
            if (this.y1 > y2) {
                t = this.y1;
                this.y1 = y2;
                y2 = t;
            }
            this.mouseButtonRelease(event, this.view.allNodesOrSpritesIn((double)this.x1, (double)this.y1, (double)x2, (double)y2));
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mouseMoved(MouseEvent e) {
    }
}

