/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree;

import ancestris.report.svgtree.FamBox;
import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.output.FilterTreeElements;
import ancestris.report.svgtree.output.TreeElements;
import java.awt.Graphics2D;

public class FlipTreeElements
extends FilterTreeElements {
    public boolean flip = false;

    public FlipTreeElements(Graphics2D graphics, TreeElements elements) {
        super(graphics, elements);
    }

    public FlipTreeElements(TreeElements elements) {
        super(elements);
    }

    @Override
    public void drawIndiBox(IndiBox indibox, int x, int y, int gen) {
        if (!this.flip) {
            this.elements.drawIndiBox(indibox, x, y, gen);
            return;
        }
        this.graphics.translate(x + indibox.width / 2, y);
        this.graphics.scale(-1.0, 1.0);
        this.elements.drawIndiBox(indibox, -indibox.width / 2, 0, gen);
        this.graphics.scale(-1.0, 1.0);
        this.graphics.translate(-x - indibox.width / 2, -y);
    }

    @Override
    public void drawFamBox(FamBox fambox, int x, int y, int gen) {
        if (!this.flip) {
            this.elements.drawFamBox(fambox, x, y, gen);
            return;
        }
        this.graphics.translate(x + fambox.width / 2, y);
        this.graphics.scale(-1.0, 1.0);
        this.elements.drawFamBox(fambox, -fambox.width / 2, 0, gen);
        this.graphics.scale(-1.0, 1.0);
        this.graphics.translate(-x - fambox.width / 2, -y);
    }

    @Override
    public void header(int width, int height) {
        if (this.flip) {
            this.graphics.translate(width / 2, 0);
            this.graphics.scale(-1.0, 1.0);
            this.graphics.translate(-width / 2, 0);
        }
        this.elements.header(width, height);
    }

    @Override
    public void footer() {
        this.elements.footer();
    }
}

