/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree;

import ancestris.report.svgtree.arrange.AlignLeftArranger;
import ancestris.report.svgtree.arrange.CenteredArranger;
import ancestris.report.svgtree.filter.FilterChain;
import ancestris.report.svgtree.filter.SameHeightSpouses;
import ancestris.report.svgtree.filter.TreeFilter;
import ancestris.report.svgtree.output.HorizontalLines;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LayoutFactory {
    public static final int SPACING = 10;
    public int arrangement = 0;
    public String[] arrangements;
    private Map<String, TreeFilter> layouts = new LinkedHashMap<String, TreeFilter>();
    private List<TreeFilter> layoutList = new ArrayList<TreeFilter>();

    public LayoutFactory() {
        this.add("center", this.getLayout(new CenteredArranger(10)));
        this.add("left", this.getLayout(new AlignLeftArranger(10)));
    }

    public TreeFilter createLayout() {
        return this.layoutList.get(this.arrangement);
    }

    private void add(String name, TreeFilter layout) {
        this.layouts.put(name, layout);
        this.layoutList.add(layout);
        this.arrangements = this.layouts.keySet().toArray(new String[0]);
    }

    private TreeFilter getLayout(TreeFilter layout) {
        return new FilterChain(new TreeFilter[]{layout, new SameHeightSpouses(), new HorizontalLines(10)});
    }
}

