/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree;

import ancestris.report.svgtree.BasicTreeBuilder;
import ancestris.report.svgtree.GraphicsOutputFactory;
import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.LayoutFactory;
import ancestris.report.svgtree.Translator;
import ancestris.report.svgtree.build.TreeBuilder;
import ancestris.report.svgtree.filter.DetermineBoxSizes;
import ancestris.report.svgtree.filter.TreeFilter;
import ancestris.report.svgtree.graphics.GraphicsOutput;
import ancestris.report.svgtree.graphics.GraphicsRenderer;
import ancestris.report.svgtree.output.RendererFactory;
import ancestris.report.svgtree.output.TreeElements;
import ancestris.report.svgtree.output.TreeElementsFactory;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Indi;
import genj.report.Report;
import java.io.IOException;
import java.util.logging.Logger;
import org.openide.util.NbBundle;

public class ReportGraphicalTree
extends Report {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private final Translator translator = new Translator(this);
    public TreeBuilder builder = new BasicTreeBuilder();
    public TreeElementsFactory treeElements = new TreeElementsFactory();
    public LayoutFactory layouts = new LayoutFactory();
    public RendererFactory renderers = new RendererFactory(this.translator);
    public GraphicsOutputFactory outputs = new GraphicsOutputFactory();

    public Object start(Indi indi) {
        LOG.info("WIP: Enter report");
        IndiBox.setTotalBoxes(0);
        LOG.info("WIP: Enter build report");
        IndiBox indibox = this.builder.build(indi);
        LOG.info("WIP: Exit build report");
        int totalBoxes = IndiBox.getTotalBoxes();
        if (totalBoxes > 1000 && DialogManager.OK_OPTION != DialogManager.create((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITL_SizeWarning"), (String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_SizeWarning", (Object)totalBoxes)).setMessageType(2).setOptionType(2).setDialogId("report.ReportGraphicalTree").show()) {
            return null;
        }
        LOG.info("WIP: Enter create layout");
        TreeElements elements = this.treeElements.createElements();
        new DetermineBoxSizes(elements).filter(indibox);
        LOG.info("WIP: Exit create layout");
        TreeFilter arranger = this.layouts.createLayout();
        arranger.filter(indibox);
        LOG.info("WIP: Enter render");
        GraphicsRenderer renderer = this.renderers.createRenderer(indibox, elements);
        GraphicsOutput output = this.outputs.createOutput(this);
        if (output == null) {
            return null;
        }
        try {
            output.output(renderer);
        }
        catch (OutOfMemoryError e) {
            this.println("ERROR! The report ran out of memory.\n");
            this.println("You can try to do the following things:");
            this.println("  * Increase the memory limit for Ancestris");
            this.println("  * Build a smaller tree");
            this.println("  * Choose SVG output (requires the least memory)");
        }
        catch (IOException e) {
            this.println("Error generating output: " + e.getMessage());
        }
        LOG.info("WIP: Exit render");
        return output.result(this);
    }
}

