/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree;

import ancestris.report.svgtree.GraphicsTreeElements;
import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.graphics.GraphicsRenderer;
import ancestris.report.svgtree.graphics.GraphicsUtil;
import genj.gedcom.Indi;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;

public class TitleRenderer
implements GraphicsRenderer {
    public static final int VERTICAL_MARGIN = 10;
    private GraphicsRenderer renderer;
    public String title = "$n ($i)";
    private String formattedTitle;
    public int fontNameTitle = 0;
    public String[] fontNameTitles = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    public int title_height = 0;

    public TitleRenderer(GraphicsRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public int getImageHeight() {
        if (this.title.equals("")) {
            return this.renderer.getImageHeight();
        }
        return this.renderer.getImageHeight() + this.getTitleHeight() + 10;
    }

    private int getTitleHeight() {
        if (this.title_height > 0) {
            return this.title_height;
        }
        return (this.renderer.getImageHeight() + this.renderer.getImageWidth()) / 40;
    }

    @Override
    public int getImageWidth() {
        return this.renderer.getImageWidth();
    }

    @Override
    public void render(Graphics2D graphics) {
        if (!this.title.equals("")) {
            graphics.setBackground(Color.WHITE);
            graphics.clearRect(0, 0, this.getImageWidth(), this.getImageHeight());
            int height = this.getTitleHeight();
            graphics.setColor(Color.BLACK);
            this.checkFont();
            graphics.setFont(new Font(this.fontNameTitles[this.fontNameTitle], 1, height));
            GraphicsTreeElements.centerString(graphics, this.formattedTitle, this.getImageWidth() / 2, height * 3 / 4 + 10);
            graphics.translate(0, height + 10);
        }
        this.renderer.render(graphics);
    }

    private void checkFont() {
        if (!GraphicsUtil.checkFont(this.fontNameTitles[this.fontNameTitle])) {
            this.fontNameTitles[this.fontNameTitle] = "verdana";
        }
    }

    private String format(String value, Indi indi) {
        value = value.replaceAll("\\$i", indi.getId());
        value = value.replaceAll("\\$n", indi.getName());
        value = value.replaceAll("\\$f", indi.getFirstName());
        value = value.replaceAll("\\$l", indi.getLastName());
        return value;
    }

    public void setIndi(IndiBox firstIndi) {
        this.formattedTitle = this.format(this.title, firstIndi.individual);
    }
}

