/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.coloring;

import java.util.LinkedList;
import org.graphstream.algorithm.Algorithm;
import org.graphstream.algorithm.util.FibonacciHeap;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

public class WelshPowell
implements Algorithm {
    protected String attrName = "WelshPowell.color";
    protected Graph g;
    protected int chromaticNumber;

    public WelshPowell(String attrName) {
        this.attrName = attrName;
    }

    public WelshPowell() {
    }

    public int getChromaticNumber() {
        return this.chromaticNumber;
    }

    public void setAttributeName(String attrName) {
        this.attrName = attrName;
    }

    @Override
    public void init(Graph g) {
        this.g = g;
    }

    @Override
    public void compute() {
        String attributeName = "WelshPowell.color";
        if (this.attrName != null) {
            attributeName = this.attrName;
        }
        LinkedList sortedNodes = new LinkedList();
        FibonacciHeap<Integer, Node> heap = new FibonacciHeap<Integer, Node>();
        for (int i = 0; i < this.g.getNodeCount(); ++i) {
            Node n = this.g.getNode(i);
            heap.add(n.getDegree(), n);
        }
        while (!heap.isEmpty()) {
            sortedNodes.addFirst(heap.extractMin());
        }
        heap = null;
        int nbColors = 0;
        while (sortedNodes.size() > 0) {
            Node root = (Node)sortedNodes.poll();
            LinkedList<Node> myGroup = new LinkedList<Node>();
            myGroup.add(root);
            root.addAttribute(attributeName, new Object[]{nbColors});
            int i = 0;
            while (i < sortedNodes.size()) {
                Node p = (Node)sortedNodes.get(i);
                boolean conflict = false;
                for (int j = 0; !conflict && j < myGroup.size(); ++j) {
                    conflict = p.getEdgeBetween(((Node)myGroup.get(j)).getIndex()) != null;
                }
                if (conflict) {
                    ++i;
                    continue;
                }
                p.addAttribute(attributeName, new Object[]{nbColors});
                myGroup.add(p);
                sortedNodes.remove(i);
            }
            myGroup.clear();
            ++nbColors;
        }
        this.chromaticNumber = nbColors;
    }
}

