/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.community;

import java.util.HashMap;
import org.graphstream.algorithm.community.EpidemicCommunityAlgorithm;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

public class Leung
extends EpidemicCommunityAlgorithm {
    protected String weightMarker = "weight";
    protected double m = 0.1;
    protected double delta = 0.05;

    public Leung() {
    }

    public Leung(Graph graph) {
        super(graph);
    }

    public Leung(Graph graph, String marker) {
        super(graph, marker);
    }

    public Leung(Graph graph, String marker, String weightMarker) {
        super(graph, marker);
        this.weightMarker = weightMarker;
    }

    public Leung(Graph graph, double m, double delta) {
        super(graph);
        this.setParameters(m, delta);
    }

    public Leung(Graph graph, String marker, double m, double delta) {
        super(graph, marker);
        this.setParameters(m, delta);
    }

    public Leung(Graph graph, String marker, String weightMarker, double m, double delta) {
        super(graph, marker);
        this.weightMarker = weightMarker;
        this.setParameters(m, delta);
    }

    public void setParameters(double m, double delta) {
        this.m = m;
        this.delta = delta;
    }

    @Override
    public void computeNode(Node node) {
        Object previousCommunity = node.getAttribute(this.marker);
        Double previousScore = (Double)node.getAttribute(this.marker + ".score");
        super.computeNode(node);
        if (previousCommunity == null) {
            previousCommunity = node.getAttribute(this.marker);
            previousScore = (Double)node.getAttribute(this.marker + ".score");
        }
        if (node.getAttribute(this.marker).equals(previousCommunity) && previousScore.equals(1.0)) {
            node.setAttribute(this.marker + ".score", new Object[]{1.0});
        } else {
            Double maxLabelScore = Double.NEGATIVE_INFINITY;
            for (Edge e : node.getEnteringEdgeSet()) {
                Node v = e.getOpposite(node);
                if (!v.hasAttribute(this.marker) || !v.getAttribute(this.marker).equals(node.getAttribute(this.marker))) continue;
                StringBuilder stringBuilder = new StringBuilder();
                if (!((Double)v.getAttribute(stringBuilder.append(this.marker).append(".score").toString()) > maxLabelScore)) continue;
                maxLabelScore = (Double)v.getAttribute(this.marker + ".score");
            }
            node.setAttribute(this.marker + ".score", new Object[]{maxLabelScore - this.delta});
        }
    }

    @Override
    protected void communityScores(Node u) {
        this.communityScores = new HashMap();
        for (Edge e : u.getEnteringEdgeSet()) {
            Edge e2;
            Node v = e.getOpposite(u);
            if (!v.hasAttribute(this.marker)) continue;
            Double score = (Double)v.getAttribute(this.marker + ".score") * Math.pow(v.getInDegree(), this.m);
            Double weight = e.hasAttribute(this.weightMarker) ? (e.isDirected() ? ((e2 = v.getEdgeToward(u.getId())) != null && e2.hasAttribute(this.weightMarker) ? Double.valueOf((Double)e.getAttribute(this.weightMarker) + (Double)e2.getAttribute(this.weightMarker)) : (Double)e.getAttribute(this.weightMarker)) : (Double)e.getAttribute(this.weightMarker)) : Double.valueOf(1.0);
            if (this.communityScores.get(v.getAttribute(this.marker)) == null) {
                this.communityScores.put(v.getAttribute(this.marker), score * weight);
                continue;
            }
            this.communityScores.put(v.getAttribute(this.marker), (Double)this.communityScores.get(v.getAttribute(this.marker)) + score * weight);
        }
    }

    @Override
    protected void originateCommunity(Node node) {
        super.originateCommunity(node);
        node.setAttribute(this.marker + ".score", new Object[]{1.0});
    }
}

