/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import java.util.ArrayList;
import java.util.Random;
import org.graphstream.algorithm.generator.Generator;
import org.graphstream.graph.Graph;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.stream.SourceBase;

public abstract class BaseGenerator
extends SourceBase
implements Generator {
    protected boolean directed = false;
    protected boolean randomlyDirected = false;
    protected ArrayList<String> nodeAttributes = new ArrayList();
    protected ArrayList<String> edgeAttributes = new ArrayList();
    protected double[] nodeAttributeRange = new double[2];
    protected double[] edgeAttributeRange = new double[2];
    protected Random random = new Random();
    protected boolean addNodeLabels = false;
    protected boolean addEdgeLabels = false;
    private boolean useInternalGraph;
    protected Graph internalGraph;
    private static volatile int generatorId;

    public BaseGenerator() {
        this(false, false);
    }

    public BaseGenerator(boolean directed, boolean randomlyDirectedEdges) {
        super(String.format("generator-%08x", generatorId++));
        this.setDirectedEdges(directed, randomlyDirectedEdges);
        this.nodeAttributeRange[0] = 0.0;
        this.nodeAttributeRange[1] = 1.0;
        this.edgeAttributeRange[0] = 0.0;
        this.edgeAttributeRange[1] = 1.0;
    }

    public BaseGenerator(boolean directed, boolean randomlyDirectedEdges, String nodeAttribute, String edgeAttribute) {
        this(directed, randomlyDirectedEdges);
        this.addNodeAttribute(nodeAttribute);
        this.addEdgeAttribute(edgeAttribute);
    }

    @Override
    public void end() {
        this.clearKeptData();
    }

    public void setRandomSeed(long seed) {
        this.random.setSeed(seed);
    }

    public void addNodeLabels(boolean on) {
        this.addNodeLabels = on;
    }

    public void addEdgeLabels(boolean on) {
        this.addEdgeLabels = on;
    }

    public void setDirectedEdges(boolean directed, boolean randomly) {
        this.directed = directed;
        if (directed && randomly) {
            this.randomlyDirected = randomly;
        }
    }

    public void addNodeAttribute(String name) {
        this.nodeAttributes.add(name);
    }

    public void removeNodeAttribute(String name) {
        int pos = this.nodeAttributes.indexOf(name);
        if (pos >= 0) {
            this.nodeAttributes.remove(pos);
        }
    }

    public void addEdgeAttribute(String name) {
        this.edgeAttributes.add(name);
    }

    public void removeEdgeAttribute(String name) {
        int pos = this.edgeAttributes.indexOf(name);
        if (pos >= 0) {
            this.edgeAttributes.remove(pos);
        }
    }

    public void setNodeAttributesRange(double low, double hi) {
        this.nodeAttributeRange[0] = low;
        this.nodeAttributeRange[1] = hi;
    }

    public void setEdgeAttributesRange(double low, double hi) {
        this.edgeAttributeRange[0] = low;
        this.edgeAttributeRange[1] = hi;
    }

    public void setUseInternalGraph(boolean on) {
        this.useInternalGraph = on;
        if (!on && this.internalGraph != null) {
            this.internalGraph.clear();
            this.internalGraph = null;
        }
        if (on && this.internalGraph == null) {
            this.internalGraph = new AdjacencyListGraph(this.getClass().getName() + "-internal_graph");
            this.internalGraph.setStrict(false);
        }
    }

    public boolean isUsingInternalGraph() {
        return this.useInternalGraph;
    }

    protected void addNode(String id, double x, double y) {
        this.addNode(id);
        this.sendNodeAttributeAdded(this.sourceId, id, "xy", new Double[]{new Double(x), new Double(y)});
        if (this.useInternalGraph) {
            this.internalGraph.getNode(id).addAttribute("xy", new Object[]{new Double[]{new Double(x), new Double(y)}});
        }
    }

    protected void addNode(String id) {
        this.sendNodeAdded(this.sourceId, id);
        if (this.addNodeLabels) {
            this.sendNodeAttributeAdded(this.sourceId, id, "label", id);
        }
        if (this.useInternalGraph) {
            this.internalGraph.addNode(id);
        }
        for (String attr : this.nodeAttributes) {
            double value = this.random.nextDouble() * (this.nodeAttributeRange[1] - this.nodeAttributeRange[0]) + this.nodeAttributeRange[0];
            this.sendNodeAttributeAdded(this.sourceId, id, attr, value);
            if (!this.useInternalGraph) continue;
            this.internalGraph.getNode(id).addAttribute(attr, new Object[]{value});
        }
    }

    protected void delNode(String id) {
        if (this.useInternalGraph) {
            this.internalGraph.removeNode(id);
        }
        this.sendNodeRemoved(this.sourceId, id);
    }

    protected void addEdge(String id, String from, String to) {
        if (this.directed && this.randomlyDirected && this.random.nextFloat() > 0.5f) {
            String tmp = from;
            from = to;
            to = tmp;
        }
        if (id == null) {
            id = from + "_" + to;
        }
        this.sendEdgeAdded(this.sourceId, id, from, to, this.directed);
        if (this.useInternalGraph) {
            this.internalGraph.addEdge(id, from, to, this.directed);
        }
        if (this.addEdgeLabels) {
            this.sendEdgeAttributeAdded(this.sourceId, id, "label", id);
        }
        for (String attr : this.edgeAttributes) {
            double value = this.random.nextDouble() * (this.edgeAttributeRange[1] - this.edgeAttributeRange[0]) + this.edgeAttributeRange[0];
            this.sendEdgeAttributeAdded(this.sourceId, id, attr, value);
            if (!this.useInternalGraph) continue;
            this.internalGraph.getEdge(id).addAttribute(attr, new Object[]{value});
        }
    }

    protected void delEdge(String edgeId) {
        this.sendEdgeRemoved(this.sourceId, edgeId);
        if (this.useInternalGraph) {
            this.internalGraph.removeEdge(edgeId);
        }
    }

    protected void clearKeptData() {
        if (this.useInternalGraph) {
            this.internalGraph.clear();
        }
    }
}

