/*
 * Decompiled with CFR 0.152.
 */
package ancestris.usage;

import ancestris.usage.Constants;
import ancestris.usage.UsageDataSet;
import genj.util.EnvironmentChecker;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UsageManager
implements Constants {
    private static final Logger LOG = Logger.getLogger("ancestris.util");
    private static String id = "";
    private static String version = "";
    private static String OS = "";
    private static boolean isConnect = true;

    private static void setActiveUsage() {
        id = UsageManager.truncate(UsageManager.setField(EnvironmentChecker.getProperty("user.home.ancestris", "", ""), "FC7E90DB1F7AH2H3"));
        version = UsageManager.truncate(EnvironmentChecker.getAncestrisVersion());
        OS = UsageManager.truncate(EnvironmentChecker.getProperty("os.name", "", "") + " " + EnvironmentChecker.getProperty("os.version", "", ""));
    }

    public static boolean isConnectable() {
        return isConnect;
    }

    public static boolean writeUsage(String action) {
        if (id.isEmpty()) {
            UsageManager.setActiveUsage();
        }
        if (!isConnect) {
            return true;
        }
        String key1 = "&ID=" + id;
        String key2 = "&ACT=" + action;
        String key3 = "&VER=" + version;
        String key4 = "&OS=" + OS;
        String outputString = UsageManager.query("http://serv01.ancestris.org/usagelogPut.php?user=treeshare01&pw=DhZP8imP" + key1 + key2 + key3 + key4);
        return outputString.isEmpty();
    }

    public static List<UsageDataSet> getPeriodUsage() {
        ArrayList<UsageDataSet> ret = new ArrayList<UsageDataSet>();
        if (!isConnect) {
            return ret;
        }
        String outputString = UsageManager.query("http://serv01.ancestris.org/usagelogPut.php?user=treeshare01&pw=DhZP8imP");
        if (outputString.isEmpty()) {
            return ret;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(outputString));
            Document doc = db.parse(is);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getElementsByTagName("l");
            for (int temp = 0; temp < nodeList.getLength(); ++temp) {
                Node node = nodeList.item(temp);
                if (node.getNodeType() != 1) continue;
                Element member = (Element)node;
                String period = member.getElementsByTagName("p").item(0).getTextContent();
                String value = member.getElementsByTagName("v").item(0).getTextContent();
                ret.add(new UsageDataSet(period, value));
            }
        }
        catch (IOException | ParserConfigurationException | DOMException | SAXException ex) {
            LOG.log(Level.FINEST, "Period usage error", ex);
            return ret;
        }
        return ret;
    }

    public static String getKey(String key) {
        if (id.isEmpty() || version.isEmpty() || OS.isEmpty() || !isConnect) {
            return null;
        }
        String ret = "";
        String key1 = "&ID=" + id;
        String key2 = "&VER=" + version;
        String key3 = "&OS=" + OS;
        String key4 = "&cle=" + key;
        String outputString = UsageManager.query("http://serv01.ancestris.org/registerGet.php?" + key1 + key2 + key3 + key4);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(outputString));
            Document doc = db.parse(is);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getElementsByTagName(key);
            Element node = (Element)nodeList.item(0);
            String str = StringEscapeUtils.unescapeHtml((String)node.getElementsByTagName("value1").item(0).getTextContent());
            ret = ret + UsageManager.read(str);
            ret = ret + " ";
            str = StringEscapeUtils.unescapeHtml((String)node.getElementsByTagName("value2").item(0).getTextContent());
            ret = ret + UsageManager.read(str);
        }
        catch (IOException | ParserConfigurationException | DOMException | SAXException ex) {
            LOG.log(Level.FINEST, "get Key error", ex);
        }
        return ret.trim();
    }

    private static String query(String url) {
        String ret = "";
        try {
            String responseString = "";
            URL data = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)data.openConnection();
            connection.setConnectTimeout(5000);
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((responseString = in.readLine()) != null) {
                ret = ret + responseString;
            }
            in.close();
            connection.disconnect();
        }
        catch (IOException ex) {
            LOG.log(Level.FINEST, "Query error", ex);
            isConnect = false;
            ret = "";
        }
        return ret;
    }

    private static String truncate(String text) {
        if (text == null) {
            return text;
        }
        return text.substring(0, Math.min(text.length(), 30)).replace(" ", "_");
    }

    private static String setField(String text, String cst) {
        try {
            if (text == null || cst == null) {
                return null;
            }
            char[] keys = cst.toCharArray();
            char[] mesg = text.toCharArray();
            int ml = mesg.length;
            int kl = keys.length;
            char[] newmsg = new char[ml];
            for (int i = 0; i < ml; ++i) {
                char c = (char)(mesg[i] ^ keys[i % kl]);
                newmsg[i] = UsageManager.toHex(c % 16);
            }
            return new String(newmsg);
        }
        catch (Exception e) {
            return "UNK";
        }
    }

    private static char toHex(int nybble) {
        if (nybble < 0 || nybble > 15) {
            throw new IllegalArgumentException();
        }
        return "0123456789ABCDEF".charAt(nybble);
    }

    private static String read(String mp) {
        try {
            Cipher dcipher = Cipher.getInstance("DES");
            byte[] bytes = Base64.getDecoder().decode("JYry2QendQg=");
            dcipher.init(2, new SecretKeySpec(bytes, 0, bytes.length, "DES"));
            byte[] dec = Base64.getDecoder().decode(mp);
            return new String(dcipher.doFinal(dec), "UTF8");
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            LOG.log(Level.FINEST, "read error", ex);
            return "";
        }
    }
}

