/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util.swing;

import genj.util.Registry;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public abstract class DialogManager {
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_ONLY_OPTION = 10;
    public static final Object OK_OPTION = DialogDescriptor.OK_OPTION;
    public static final Object CANCEL_OPTION = DialogDescriptor.CANCEL_OPTION;
    public static final Object YES_OPTION = DialogDescriptor.YES_OPTION;
    public static final Object NO_OPTION = DialogDescriptor.NO_OPTION;
    public static final Object CLOSED_OPTION = DialogDescriptor.CLOSED_OPTION;
    protected String dialogId = null;
    protected boolean isResizable = true;

    public static Object show(String title, int messageType, String txt, Object[] options) {
        NotifyDescriptor d = new NotifyDescriptor((Object)txt, title, -1, messageType, options, null);
        return DialogDisplayer.getDefault().notify(d);
    }

    public static ADialog create(String title, JComponent content) {
        return new ADialog(title, content);
    }

    public static ADialog create(String title, JComponent[] content) {
        return DialogManager.create(title, content, true);
    }

    public static ADialog create(String title, JComponent[] content, boolean modal) {
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 1));
        box.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        for (int i = 0; i < content.length; ++i) {
            if (content[i] == null) continue;
            box.add(content[i]);
            content[i].setAlignmentX(0.0f);
        }
        return DialogManager.create(title, box, modal);
    }

    public static ADialog create(String title, JComponent content, boolean modal) {
        return new ADialog(title, content, modal);
    }

    public static InputLine create(String title, String text, String value) {
        return new InputLine(title, text, value);
    }

    public static DialogManager createError(String title, String text) {
        return new Message(title, text).setMessageType(0);
    }

    public static DialogManager create(String title, String text) {
        return new Message(title, text);
    }

    public static DialogManager createYesNo(String title, String text) {
        return new Message(title, text).setOptionType(0).setMessageType(3);
    }

    protected abstract NotifyDescriptor getDescriptor();

    public DialogManager setOptions(Object[] newOptions) {
        this.getDescriptor().setOptions(newOptions);
        return this;
    }

    public DialogManager setAdditionalOptions(Object[] newOptions) {
        this.getDescriptor().setAdditionalOptions(newOptions);
        return this;
    }

    public DialogManager setOptionType(int newType) {
        if (newType == 10) {
            return this.setOptions(new Object[]{OK_OPTION});
        }
        this.getDescriptor().setOptions(null);
        this.getDescriptor().setOptionType(newType);
        return this;
    }

    public DialogManager setMessageType(int newType) {
        this.getDescriptor().setMessageType(newType);
        return this;
    }

    public DialogManager setDialogId(Class type) {
        return this.setDialogId(type.getName());
    }

    public DialogManager setDialogId(String id) {
        this.dialogId = id;
        return this;
    }

    public DialogManager setResizable(boolean set) {
        this.isResizable = set;
        return this;
    }

    public final DialogManager setValid(boolean newValid) {
        this.getDescriptor().setValid(newValid);
        return this;
    }

    public abstract Object show();

    public abstract void cancel();

    public static class ADialog
    extends DialogManager {
        protected DialogDescriptor descriptor;
        private Dialog dialog;

        public ADialog(String title, JComponent content) {
            this.descriptor = new DialogDescriptor((Object)content, title);
        }

        public ADialog(String title, JComponent content, boolean modal) {
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (dialogId != null) {
                        Registry.get(DialogManager.class).put(dialogId + ".dialog", dialog.getSize());
                    }
                    this.cancel();
                }
            };
            this.descriptor = new DialogDescriptor((Object)content, title, modal, al);
        }

        @Override
        protected NotifyDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public Object show() {
            this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
            if (this.dialogId != null) {
                Registry registry = Registry.get(DialogManager.class);
                Dimension bounds = registry.get(this.dialogId + ".dialog", (Dimension)null);
                if (bounds != null) {
                    Rectangle prev = this.dialog.getBounds();
                    bounds.width = Math.max(bounds.width, prev.width);
                    bounds.height = Math.max(bounds.height, prev.height);
                    prev.grow((bounds.width - prev.width) / 2, (bounds.height - prev.height) / 2);
                    this.dialog.setBounds(prev);
                }
                this.dialog.setResizable(this.isResizable);
                this.dialog.setVisible(true);
                registry.put(this.dialogId + ".dialog", this.dialog.getSize());
            } else {
                this.dialog.setResizable(this.isResizable);
                this.dialog.setVisible(true);
            }
            return this.descriptor.getValue();
        }

        @Override
        public void cancel() {
            if (this.dialog == null) {
                throw new IllegalStateException("not showing");
            }
            this.dialog.dispose();
        }
    }

    public static class InputLine
    extends DialogManager {
        private NotifyDescriptor.InputLine descriptor;

        public InputLine(String title, String text, String value) {
            this.descriptor = new MyInputLine(text, title);
            this.descriptor.setInputText(value);
            this.setOptionType(2);
            this.setMessageType(3);
        }

        @Override
        protected NotifyDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public String show() {
            if (NotifyDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)this.descriptor)) {
                return this.descriptor.getInputText();
            }
            return null;
        }

        @Override
        public void cancel() {
        }
    }

    public static class Message
    extends DialogManager {
        private NotifyDescriptor descriptor;

        public Message(String title, String message) {
            this.descriptor = new NotifyDescriptor((Object)message, title, -1, 1, new Object[]{NotifyDescriptor.OK_OPTION}, OK_OPTION);
        }

        @Override
        protected NotifyDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public Object show() {
            return DialogDisplayer.getDefault().notify(this.descriptor);
        }

        @Override
        public void cancel() {
        }
    }

    private static class MyInputLine
    extends NotifyDescriptor.InputLine {
        private boolean isAutoEnabler = true;

        public MyInputLine(String text, String title) {
            super(text, title);
            this.doEnablement();
        }

        public void setInputText(String text) {
            super.setInputText(text);
            this.doEnablement();
        }

        public void setEnabler(boolean set) {
            this.isAutoEnabler = set;
            this.doEnablement();
        }

        protected void initialize() {
            super.initialize();
            this.textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.doEnablement();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.doEnablement();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.doEnablement();
                }
            });
        }

        private void doEnablement() {
            if (this.isAutoEnabler) {
                if (this.textField.getText().isEmpty()) {
                    this.setValid(false);
                } else {
                    this.setValid(true);
                }
            } else {
                this.setValid(true);
            }
        }
    }
}

