/*
 * Decompiled with CFR 0.152.
 */
package ancestris.view;

import ancestris.core.actions.AncestrisActionProvider;
import ancestris.core.actions.CommonActions;
import ancestris.gedcom.PropertyNode;
import ancestris.view.EntityTransferHandler;
import ancestris.view.PropertyProvider;
import genj.gedcom.Property;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class ExplorerHelper {
    private final Component source;
    private ExplorerManager manager;
    private EntityTransferHandler entityTransferHandler;
    transient MouseContextListener mouseContextListener;

    public ExplorerHelper(Component source) {
        this.source = source;
    }

    public boolean isPopupAllowed() {
        return this.mouseContextListener != null;
    }

    public void setPopupAllowed(boolean value) {
        if (this.mouseContextListener == null) {
            this.mouseContextListener = new MouseContextListener();
        }
        if (value) {
            this.addMouseContextListener(this.mouseContextListener);
        } else {
            this.removeMouseContextListener(this.mouseContextListener);
            this.mouseContextListener = null;
        }
    }

    public void addMouseContextListener(MouseContextListener mcl) {
        if (this.manager == null) {
            this.manager = ExplorerHelper.lookupExplorerManager(this.source);
        }
        if (this.entityTransferHandler == null) {
            this.entityTransferHandler = new EntityTransferHandler();
        }
        this.source.addMouseListener((MouseListener)((Object)mcl));
        if (this.isSourceDNDEligible(this.source)) {
            this.source.addMouseMotionListener((MouseMotionListener)((Object)mcl));
            ((JComponent)this.source).setTransferHandler(this.entityTransferHandler);
        }
    }

    public void removeMouseContextListener(MouseContextListener mcl) {
        this.source.removeMouseListener((MouseListener)((Object)mcl));
        if (this.isSourceDNDEligible(this.source)) {
            this.source.removeMouseMotionListener((MouseMotionListener)((Object)mcl));
            ((JComponent)this.source).setTransferHandler(null);
        }
    }

    public static ExplorerManager lookupExplorerManager(Component source) {
        if (source instanceof ExplorerManager.Provider) {
            return ((ExplorerManager.Provider)source).getExplorerManager();
        }
        return ExplorerManager.find((Component)source);
    }

    private boolean isSourceDNDEligible(Component source) {
        if (source.toString().contains("AdvancedEditor$Tree")) {
            return false;
        }
        return source instanceof JComponent;
    }

    protected void createContextMenuPopup(Component clickedComponent, Point p, Node[] selNodes) {
        if (!this.isPopupAllowed()) {
            return;
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        List<AncestrisActionProvider> providers = AncestrisActionProvider.Lookup.lookupAll(clickedComponent);
        for (AncestrisActionProvider ancestrisActionProvider : providers) {
            actions.addAll(ancestrisActionProvider.getActions(true, selNodes));
            actions.add(null);
        }
        if (selNodes.length > 0) {
            actions.addAll(Arrays.asList(NodeOp.findActions((Node[])selNodes)));
            actions.add(null);
        }
        ArrayList<Action> aactions = new ArrayList<Action>();
        for (AncestrisActionProvider aap : Lookup.getDefault().lookupAll(AncestrisActionProvider.class)) {
            aactions.addAll(aap.getActions(false, selNodes));
        }
        actions.addAll(aactions);
        if (actions.size() > 0) {
            if (selNodes.length > 0) {
                Property property = ExplorerHelper.getPropertyFromNodes(selNodes);
                Action menuTitleItem = CommonActions.createTitleAction(CommonActions.TYPE_CONTEXT_MENU, property, new Object[0]);
                actions.add(0, menuTitleItem);
                actions.add(1, null);
            }
            JPopupMenu jPopupMenu = Utilities.actionsToPopup((Action[])actions.toArray(new Action[0]), (Component)clickedComponent);
            jPopupMenu.setPopupSize(Math.min(450, jPopupMenu.getPreferredSize().width), jPopupMenu.getPreferredSize().height);
            if (jPopupMenu.getSubElements().length > 0) {
                jPopupMenu.show(this.source, p.x, p.y);
            }
        }
    }

    public static Property getPropertyFromNodes(Node[] nodes) {
        Property property = null;
        if (nodes != null && nodes.length == 1 && nodes[0] instanceof PropertyNode) {
            property = ((PropertyNode)nodes[0]).getProperty();
        }
        return property;
    }

    private class MouseContextListener
    extends MouseUtils.PopupMouseAdapter {
        private MouseContextListener() {
        }

        protected void showPopup(MouseEvent e) {
            Node[] selNodes = ExplorerHelper.this.manager.getSelectedNodes();
            Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), ExplorerHelper.this.source);
            ExplorerHelper.this.createContextMenuPopup(e.getComponent(), p, selNodes);
        }

        public void mouseDragged(MouseEvent e) {
            if (!e.isConsumed() && (e.getModifiersEx() & 0x400) != 0 && ExplorerHelper.this.isSourceDNDEligible(ExplorerHelper.this.source)) {
                Property property = PropertyProvider.getPropertyFromComponent(ExplorerHelper.this.source, e.getPoint());
                if (property == null) {
                    property = ExplorerHelper.getPropertyFromNodes(ExplorerHelper.this.manager.getSelectedNodes());
                }
                if (property != null) {
                    ExplorerHelper.this.entityTransferHandler.setEntity(property.getEntity());
                    ExplorerHelper.this.entityTransferHandler.exportAsDrag((JComponent)ExplorerHelper.this.source, e, 1);
                }
            }
        }
    }
}

