/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import ancestris.core.TextOptions;
import genj.gedcom.Entity;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyComparator;
import genj.gedcom.PropertyComparator2;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEventDetails;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.PropertyHusband;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyWife;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openide.util.Exceptions;

public class Fam
extends Entity {
    public static final TagPath PATH_FAMMARRDATE = new TagPath("FAM:MARR:DATE");
    public static final TagPath PATH_FAMMARRPLAC = new TagPath("FAM:MARR:PLAC");
    public static final TagPath PATH_FAMDIVDATE = new TagPath("FAM:DIV:DATE");
    public static final TagPath PATH_FAMDIVPLAC = new TagPath("FAM:DIV:PLAC");
    private static final TagPath SORT_SIBLINGS = new TagPath("CHIL:*:..:BIRT:DATE");
    public static final String TAG_PREF = "_PREF";

    @Override
    public PropertyComparator2 getDisplayComparator() {
        return FAMComparator.getInstance();
    }

    public Fam(String tag, String id) {
        super(tag, id);
        this.assertTag("FAM");
    }

    @Override
    public boolean isValid() {
        return this.getValue().isEmpty();
    }

    @Override
    public void moveEntityValue() {
        super.moveEntityValue();
    }

    public Indi getChild(int which) {
        int j = this.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property prop = this.getProperty(i);
            if (!"CHIL".equals(prop.getTag()) || !prop.isValid()) continue;
            if (which == 0) {
                return ((PropertyChild)prop).getChild();
            }
            --which;
        }
        throw new IllegalArgumentException("no such child");
    }

    public Indi[] getChildren() {
        return this.getChildren(true);
    }

    public Indi[] getChildren(boolean sorted) {
        ArrayList<PropertyChild> CHILs = new ArrayList<PropertyChild>(this.getNoOfProperties());
        for (PropertyChild prop : this.getProperties(PropertyChild.class)) {
            if (!prop.isValid()) continue;
            CHILs.add(prop);
        }
        if (sorted) {
            Collections.sort(CHILs, new CHILComparator());
        }
        ArrayList<Indi> children = new ArrayList<Indi>(CHILs.size());
        for (int i = 0; i < CHILs.size(); ++i) {
            Indi child = ((PropertyChild)CHILs.get(i)).getChild();
            if (children.contains(child)) continue;
            children.add(child);
        }
        return Indi.toIndiArray(children);
    }

    public Indi getHusband() {
        Property husb = this.getProperty("HUSB", true);
        if (husb instanceof PropertyHusband) {
            return ((PropertyHusband)husb).getHusband();
        }
        return null;
    }

    public int getNoOfChildren() {
        int result = 0;
        int j = this.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property prop = this.getProperty(i);
            if (prop.getClass() != PropertyChild.class || !prop.isValid()) continue;
            ++result;
        }
        return result;
    }

    public int getNoOfSpouses() {
        int result = 0;
        if (this.getHusband() != null) {
            ++result;
        }
        if (this.getWife() != null) {
            ++result;
        }
        return result;
    }

    public Indi getSpouse(int which) {
        Indi wife;
        Indi husband = this.getHusband();
        if (husband != null) {
            if (which == 0) {
                return husband;
            }
            --which;
        }
        if ((wife = this.getWife()) != null) {
            if (which == 0) {
                return wife;
            }
            --which;
        }
        throw new IllegalArgumentException("No such spouse");
    }

    public List<Indi> getSpouses() {
        ArrayList<Indi> spouses = new ArrayList<Indi>();
        if (this.getHusband() != null) {
            spouses.add(this.getHusband());
        }
        if (this.getWife() != null) {
            spouses.add(this.getWife());
        }
        return spouses;
    }

    public Indi getOtherSpouse(Indi spouse) {
        Indi wife = this.getWife();
        if (wife == spouse) {
            return this.getHusband();
        }
        return wife;
    }

    public Indi getWife() {
        Property wife = this.getProperty("WIFE", true);
        if (wife instanceof PropertyWife) {
            return ((PropertyWife)wife).getWife();
        }
        return null;
    }

    public PropertyXRef setHusband(Indi husband) throws GedcomException {
        int j = this.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property prop = this.getProperty(i);
            if (!"HUSB".equals(prop.getTag()) || !prop.isValid()) continue;
            this.delProperty(prop);
            break;
        }
        if (husband == null) {
            return null;
        }
        PropertyHusband ph = new PropertyHusband();
        ph.setValue(husband.getId());
        this.addProperty(ph);
        try {
            ph.link();
        }
        catch (GedcomException ex) {
            this.delProperty(ph);
            throw ex;
        }
        if (husband.getSex() != 1) {
            husband.setSex(1);
        }
        return ph;
    }

    public PropertyXRef setWife(Indi wife) throws GedcomException {
        int j = this.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property prop = this.getProperty(i);
            if (!"WIFE".equals(prop.getTag()) || !prop.isValid()) continue;
            this.delProperty(prop);
            break;
        }
        if (wife == null) {
            return null;
        }
        PropertyWife pw = new PropertyWife();
        pw.setValue(wife.getId());
        this.addProperty(pw);
        try {
            pw.link();
        }
        catch (GedcomException ex) {
            this.delProperty(pw);
            throw ex;
        }
        if (wife.getSex() != 2) {
            wife.setSex(2);
        }
        return pw;
    }

    public boolean acceptSpouse(int sex) {
        if (this.getNoOfSpouses() == 2) {
            return false;
        }
        Indi husb = this.getHusband();
        if (husb != null && husb.getSex() == 1 && sex != 2) {
            return false;
        }
        Indi wife = this.getWife();
        return wife == null || wife.getSex() != 2 || sex == 1;
    }

    public PropertyXRef setSpouse(Indi spouse) throws GedcomException {
        PropertyXRef HUSBorWIFE;
        Indi husband = this.getHusband();
        Indi wife = this.getWife();
        if (husband != null && wife != null) {
            throw new GedcomException(resources.getString("error.already.spouses", this));
        }
        switch (spouse.getSex()) {
            default: {
                HUSBorWIFE = husband != null ? this.setWife(spouse) : this.setHusband(spouse);
                break;
            }
            case 1: {
                HUSBorWIFE = this.setHusband(spouse);
                if (wife != null && wife.getSex() != 2) {
                    wife.setSex(2);
                }
                if (husband == null) break;
                this.setWife(husband);
                break;
            }
            case 2: {
                HUSBorWIFE = this.setWife(spouse);
                if (husband != null && husband.getSex() != 1) {
                    husband.setSex(1);
                }
                if (wife == null) break;
                this.setHusband(wife);
            }
        }
        return HUSBorWIFE;
    }

    public PropertyXRef addChild(Indi newChild) throws GedcomException {
        PropertyChild pc = new PropertyChild();
        pc.setValue(newChild.getId());
        this.addProperty(pc);
        try {
            pc.link();
        }
        catch (GedcomException ex) {
            this.delProperty(pc);
            throw ex;
        }
        return pc;
    }

    static Fam[] toFamArray(Collection<Fam> c) {
        return c.toArray(new Fam[c.size()]);
    }

    @Override
    protected String getToStringPrefix(boolean showIds) {
        Indi wife;
        StringBuilder result = new StringBuilder();
        Indi husband = this.getHusband();
        if (husband != null) {
            result.append(husband.toString(showIds));
            result.append(" ");
            result.append(TextOptions.getInstance().getMarriageSymbol());
        }
        if ((wife = this.getWife()) != null) {
            result.append(wife.toString(showIds));
        }
        return result.toString();
    }

    @Override
    public String getDisplayTitle() {
        return this.getDisplayTitle(true);
    }

    public String getDisplayTitle(boolean showid) {
        String str;
        String husbname = "?";
        if (this.getHusband() != null) {
            String[] lastNames = this.getHusband().getLastName().split(",");
            husbname = lastNames.length > 0 ? lastNames[0] : "?";
        }
        String wifename = "?";
        if (this.getWife() != null) {
            String[] lastNames = this.getWife().getLastName().split(",");
            wifename = lastNames.length > 0 ? lastNames[0] : "?";
        }
        str = (str = this.getMarriageAsString()).isEmpty() ? "" : " (" + str + ")";
        return (showid ? this.getId() + " - " : "") + husbname + " " + TextOptions.getInstance().getMarriageSymbol() + " " + wifename + str;
    }

    public String getDisplayFullNames(boolean showid) {
        String str;
        String husbname = "?";
        if (this.getHusband() != null) {
            husbname = this.getHusband().getDisplayTitle(showid);
        }
        String wifename = "?";
        if (this.getWife() != null) {
            wifename = this.getWife().getDisplayTitle(showid);
        }
        str = (str = this.getMarriageAsString()).isEmpty() ? "" : "(" + str + ") ";
        return (showid ? this.getId() + " = " : "") + husbname + " " + TextOptions.getInstance().getMarriageSymbol() + str + " " + wifename;
    }

    protected String getNames() {
        StringBuilder result = new StringBuilder();
        Indi husband = this.getHusband();
        if (husband != null) {
            result.append(husband.getName());
        } else {
            result.append(resources.getString("prop.event.knwontohavehappened"));
        }
        result.append(" ");
        result.append(TextOptions.getInstance().getMarriageSymbol());
        result.append(" ");
        Indi wife = this.getWife();
        if (wife != null) {
            result.append(wife.getName());
        } else {
            result.append(resources.getString("prop.event.knwontohavehappened"));
        }
        return result.toString();
    }

    public PropertyDate getMarriageDate() {
        return this.getMarriageDate(false);
    }

    public String getMarriageAsString() {
        PropertyDate p = this.getMarriageDate();
        if (p == null) {
            return "";
        }
        return p.getDisplayValue();
    }

    public PropertyDate getMarriageDate(boolean create) {
        PropertyDate date = (PropertyDate)this.getProperty(PATH_FAMMARRDATE);
        if (null != date || !create) {
            return date;
        }
        this.setValue(PATH_FAMMARRDATE, "");
        return (PropertyDate)this.getProperty(PATH_FAMMARRDATE);
    }

    public PropertyPlace getMarriagePlace() {
        return this.getMarriagePlace(false);
    }

    public PropertyPlace getMarriagePlace(boolean create) {
        PropertyPlace place = (PropertyPlace)this.getProperty(PATH_FAMMARRPLAC);
        if (null != place || !create) {
            return place;
        }
        this.setValue(PATH_FAMMARRPLAC, "");
        return (PropertyPlace)this.getProperty(PATH_FAMMARRPLAC);
    }

    public PropertyDate getDivorceDate() {
        return (PropertyDate)this.getProperty(PATH_FAMDIVDATE);
    }

    public void swapSpouses() throws GedcomException {
        PropertyHusband husband = (PropertyHusband)this.getProperty("HUSB", true);
        PropertyWife wife = (PropertyWife)this.getProperty("WIFE", true);
        if (husband == null && wife == null) {
            return;
        }
        PropertyFamilySpouse famsh = null;
        PropertyFamilySpouse famsw = null;
        if (husband != null) {
            famsh = (PropertyFamilySpouse)husband.getTarget();
            husband.unlink();
        }
        if (wife != null) {
            famsw = (PropertyFamilySpouse)wife.getTarget();
            wife.unlink();
        }
        if (husband == null) {
            this.setHusband((Indi)famsw.getEntity());
            this.delProperty(wife);
            return;
        }
        if (wife == null) {
            this.setWife((Indi)famsh.getEntity());
            this.delProperty(husband);
            return;
        }
        husband.link(famsw);
        wife.link(famsh);
    }

    public void setPreferred(boolean set) {
        Property pref = this.getProperty(TAG_PREF);
        if (pref != null && !set) {
            this.delProperty(pref);
        } else if (pref == null && set) {
            try {
                this.addProperty(TAG_PREF, "", 0);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public boolean isPreferred() {
        return this.getProperty(TAG_PREF) != null;
    }

    @Override
    public List<PropertyEventDetails> getEvents() {
        ArrayList<PropertyEventDetails> eventList = new ArrayList<PropertyEventDetails>();
        this.getAllProperties(null).stream().filter(prop -> prop.isEvent()).forEachOrdered(prop -> eventList.add((PropertyEventDetails)prop));
        return eventList;
    }

    private static class FAMComparator
    extends PropertyComparator2.Default<Fam> {
        private static final FAMComparator INSTANCE = new FAMComparator();

        private FAMComparator() {
        }

        public static PropertyComparator2 getInstance() {
            return INSTANCE;
        }

        @Override
        public String getSortGroup(Fam p) {
            Indi h = p.getHusband();
            if (h == null) {
                return "";
            }
            return h.getDisplayComparator().getSortGroup(h);
        }

        @Override
        public int compare(Fam f1, Fam f2) {
            Indi i2;
            int r = this.compareNull(f1, f2);
            if (r != Integer.MAX_VALUE) {
                return r;
            }
            Indi i1 = f1.getHusband();
            r = this.compareNull(i1, i2 = f2.getHusband());
            if (r == Integer.MAX_VALUE) {
                r = i1.getDisplayComparator().compare(i1, i2);
            }
            if (r != 0) {
                return r;
            }
            i1 = f1.getWife();
            r = this.compareNull(i1, i2 = f2.getWife());
            if (r == Integer.MAX_VALUE) {
                r = i1.getDisplayComparator().compare(i1, i2);
            }
            return r;
        }
    }

    private class CHILComparator
    extends PropertyComparator {
        CHILComparator() {
            super(SORT_SIBLINGS);
        }

        @Override
        public int compare(Property p1, Property p2) {
            int result = super.compare(p1, p2);
            return result != 0 ? result : Fam.this.getPropertyPosition(p1) - Fam.this.getPropertyPosition(p2);
        }
    }
}

