/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.MetaProperty;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.time.PointInTime;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class PropertyChange
extends Property
implements MultiLineProperty {
    private static final DecimalFormat decimal = new DecimalFormat("00");
    public static final String CHAN = "CHAN";
    public static final String TIME = "TIME";
    public static final String DATE = "DATE";
    private long time = -1L;

    public PropertyChange() {
        super(CHAN);
        this.setTime(System.currentTimeMillis());
    }

    public PropertyChange(String tag) {
        super(tag);
        this.assertTag(CHAN);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String getDisplayValue() {
        return this.time < 0L ? "" : this.getDateDisplayValue() + ", " + this.getTimeDisplayValue();
    }

    public String getDateDisplayValue() {
        return this.time < 0L ? "" : PointInTime.getPointInTime(this.toLocal(this.time)).toString();
    }

    public String getTimeDisplayValue() {
        return this.time <= 0L ? "" : this.toString(this.toLocal(this.time));
    }

    private long toLocal(long utc) {
        Calendar c = Calendar.getInstance();
        return utc + (long)c.get(15) + (long)c.get(16);
    }

    private String toString(long time) {
        long sec = time / 1000L % 60L;
        long min = time / 1000L / 60L % 60L;
        long hr = time / 1000L / 60L / 60L % 24L;
        StringBuffer buffer = new StringBuffer();
        buffer.append(decimal.format(hr));
        buffer.append(':');
        buffer.append(decimal.format(min));
        buffer.append(':');
        buffer.append(decimal.format(sec));
        return buffer.toString();
    }

    @Override
    public MultiLineProperty.Collector getLineCollector() {
        return new DateTimeCollector();
    }

    @Override
    public MultiLineProperty.Iterator getLineIterator() {
        return new DateTimeIterator();
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long set) {
        if (this.time == set) {
            return;
        }
        String old = this.getValue();
        this.time = set;
        this.propagatePropertyChanged(this, old);
    }

    @Override
    public void setValue(String value) {
        String old = this.getValue();
        int i = value.indexOf(44);
        if (i < 0) {
            return;
        }
        try {
            this.time = 0L;
            StringTokenizer tokens = new StringTokenizer(value.substring(i + 1), ":");
            if (tokens.hasMoreTokens()) {
                this.time += (long)(Integer.parseInt(tokens.nextToken()) * 60 * 60 * 1000);
            }
            if (tokens.hasMoreTokens()) {
                this.time += (long)(Integer.parseInt(tokens.nextToken()) * 60 * 1000);
            }
            if (tokens.hasMoreTokens()) {
                this.time += (long)(Integer.parseInt(tokens.nextToken()) * 1000);
            }
            this.time += PointInTime.getPointInTime(value.substring(0, i)).getTimeMillis();
            this.getGedcom().updateLastChange(this);
        }
        catch (Throwable t) {
            this.time = -1L;
        }
        this.propagatePropertyChanged(this, old);
    }

    @Override
    public String getValue() {
        return this.time < 0L ? "" : PointInTime.getPointInTime(this.time).getValue() + ',' + this.toString(this.time);
    }

    @Override
    public int compareTo(Property other) {
        if (other instanceof PropertyChange) {
            if (this.time < ((PropertyChange)other).time) {
                return -1;
            }
            if (this.time > ((PropertyChange)other).time) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public void setPrivate(boolean set, boolean recursively) {
    }

    static /* synthetic */ String access$300(PropertyChange x0, long x1) {
        return x0.toString(x1);
    }

    static class Monitor
    extends GedcomListenerAdapter {
        private Set<Entity> updated = new HashSet<Entity>();

        Monitor() {
        }

        private void update(Property where) {
            Entity entity = where.getEntity();
            if (this.updated.contains(entity)) {
                return;
            }
            while (where != null) {
                if (where instanceof PropertyChange) {
                    return;
                }
                where = where.getParent();
            }
            Gedcom.LOG.finer("updating CHAN for " + entity.getId());
            MetaProperty meta = entity.getMetaProperty();
            if (!meta.allows(PropertyChange.CHAN)) {
                return;
            }
            PropertyChange prop = (PropertyChange)entity.getProperty(PropertyChange.CHAN);
            if (prop == null) {
                prop = (PropertyChange)entity.addProperty(new PropertyChange());
            } else {
                prop.setTime(System.currentTimeMillis());
            }
            this.updated.add(entity);
            entity.getGedcom().updateLastChange(prop);
        }

        @Override
        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
            this.update(entity);
        }

        @Override
        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            this.updated.remove(entity);
        }

        @Override
        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
            this.update(added);
        }

        @Override
        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            this.update(property);
        }

        @Override
        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
            if (!(deleted instanceof PropertyChange)) {
                this.update(property);
            }
        }
    }

    private class DateTimeIterator
    implements MultiLineProperty.Iterator {
        int i = 0;
        private String[] tags = new String[]{"CHAN", "DATE", "TIME"};
        private String[] values = new String[]{"", PointInTime.getPointInTime(PropertyChange.access$200(PropertyChange.this)).getValue(), PropertyChange.access$300(PropertyChange.this, PropertyChange.access$200(PropertyChange.this))};

        private DateTimeIterator() {
        }

        @Override
        public void setValue(String value) {
        }

        @Override
        public int getIndent() {
            return this.i;
        }

        @Override
        public String getTag() {
            return this.tags[this.i];
        }

        @Override
        public String getValue() {
            return this.values[this.i];
        }

        @Override
        public boolean next() {
            return PropertyChange.this.time >= 0L && ++this.i != this.tags.length;
        }
    }

    private class DateTimeCollector
    implements MultiLineProperty.Collector {
        private String dateCollected = "01 JAN 1900";
        private String timeCollected = "00:00:00";

        private DateTimeCollector() {
        }

        @Override
        public boolean append(int indent, String tag, String value) {
            if (indent == 1 && PropertyChange.DATE.equals(tag)) {
                this.dateCollected = value;
                return true;
            }
            if (indent == 2 && PropertyChange.TIME.equals(tag)) {
                this.timeCollected = value;
                return true;
            }
            return false;
        }

        @Override
        public String getValue() {
            return this.dateCollected + ',' + this.timeCollected;
        }
    }
}

