/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Fam;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAge;
import genj.gedcom.PropertyDate;
import java.util.ArrayList;

public abstract class PropertyEventDetails
extends Property {
    public PropertyEventDetails(String tag) {
        super(tag);
    }

    public PropertyDate getDate() {
        return this.getDate(true);
    }

    public PropertyDate getDate(boolean valid) {
        Property prop = this.getProperty("DATE", valid);
        if (prop == null) {
            return null;
        }
        return (PropertyDate)prop;
    }

    public String getDateAsString() {
        Property date = this.getProperty("DATE");
        return date != null ? date.getValue() : "";
    }

    @Override
    void propagatePropertyChanged(Property property, String oldValue) {
        super.propagatePropertyChanged(property, oldValue);
        this.maintainAge(property);
    }

    private void maintainAge(Property property) {
        if (!this.isEvent() || !GedcomOptions.getInstance().isAddAge()) {
            return;
        }
        if (property.getGedcom() == null || property.getGedcom().getOrigin() == null || property.getGedcom().isUndoRedoInProgress()) {
            return;
        }
        if (property instanceof PropertyDate && this.getProperty("DATE") == property) {
            ArrayList<PropertyEventDetails> list = new ArrayList<PropertyEventDetails>();
            if (this.getParent().getProperty("BIRT") == this || this.getParent().getProperty("CHR") == this) {
                list.addAll(((Indi)this.getEntity()).getEvents());
            } else {
                list.add(this);
            }
            for (Property property2 : list) {
                ((PropertyEventDetails)property2).updateAge(false, false, false);
            }
        }
    }

    public void updateAge(boolean force, boolean overwriteString, boolean isGuessed) {
        PropertyDate date = this.getDate(true);
        if (date == null) {
            return;
        }
        if ("INDI".equals(this.getEntity().getTag())) {
            PropertyAge age = (PropertyAge)this.getProperty("AGE", false);
            if ("BIRT".equals(this.getTag())) {
                if (age != null) {
                    this.delProperty(age);
                }
            } else {
                if (age == null && (GedcomOptions.getInstance().isAddAge() || force) && PropertyAge.getEarlier((Indi)this.getEntity(), null) != null) {
                    age = (PropertyAge)this.addProperty("AGE", "");
                } else if (age != null) {
                    age.updateAge(overwriteString);
                }
                if (age != null) {
                    age.setGuessed(isGuessed);
                }
            }
        } else {
            Property wife;
            Property husb = this.getProperty("HUSB");
            if (husb == null && (GedcomOptions.getInstance().isAddAge() || force) && PropertyAge.getEarlier(((Fam)this.getEntity()).getHusband(), husb) != null) {
                husb = this.addProperty("HUSB", "");
            }
            if (husb != null) {
                husb.setGuessed(isGuessed);
                PropertyAge age = (PropertyAge)husb.getProperty("AGE", false);
                if (age == null && (GedcomOptions.getInstance().isAddAge() || force) && PropertyAge.getEarlier(((Fam)this.getEntity()).getHusband(), husb) != null) {
                    age = (PropertyAge)husb.addProperty("AGE", "");
                } else if (age != null) {
                    age.updateAge(overwriteString);
                }
                if (age != null) {
                    age.setGuessed(isGuessed);
                }
            }
            if ((wife = this.getProperty("WIFE")) == null && (GedcomOptions.getInstance().isAddAge() || force) && PropertyAge.getEarlier(((Fam)this.getEntity()).getWife(), wife) != null) {
                wife = this.addProperty("WIFE", "");
            }
            if (wife != null) {
                wife.setGuessed(isGuessed);
                PropertyAge age = (PropertyAge)wife.getProperty("AGE", false);
                if (age == null && (GedcomOptions.getInstance().isAddAge() || force) && PropertyAge.getEarlier(((Fam)this.getEntity()).getWife(), wife) != null) {
                    age = (PropertyAge)wife.addProperty("AGE", "");
                } else if (age != null) {
                    age.updateAge(overwriteString);
                }
                if (age != null) {
                    age.setGuessed(isGuessed);
                }
            }
        }
    }

    @Override
    public boolean isValid() {
        if (this.getTag().equals("RESI") && !this.getValue().isEmpty()) {
            this.invalidReason = "err.value.emptyRequired";
            return false;
        }
        return super.isValid();
    }
}

