/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyChoiceValue;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertyRelationship
extends PropertyChoiceValue {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private TagPath anchor = null;

    public PropertyRelationship(String tag) {
        super(tag);
        this.assertTag("RELA");
    }

    @Override
    public String getValue() {
        String value = super.getValue();
        TagPath locAnchor = this.getAnchor();
        if (locAnchor != null && locAnchor.length() > 0) {
            value = value + " @#" + locAnchor.toString() + '@';
        }
        return value;
    }

    @Override
    public String getDisplayValue() {
        return super.getValue();
    }

    @Override
    public void setValue(String value) {
        int marker = value.indexOf("@#");
        String anchorValue = null;
        if (marker >= 0) {
            super.setValue(value.substring(0, marker).trim());
            anchorValue = value.substring(marker + 2, value.length() - 1);
        } else {
            int i = value.lastIndexOf(64);
            if (i >= 0) {
                super.setValue(value.substring(0, i).trim());
                anchorValue = value.substring(i + 1);
            } else {
                super.setValue(value);
            }
        }
        if (anchorValue != null) {
            try {
                this.anchor = new TagPath(anchorValue);
            }
            catch (IllegalArgumentException t) {
                LOG.log(Level.FINE, "Error during anchor test", t);
            }
        }
        if (this.anchor != null && !this.getAnchor().equals(this.anchor)) {
            try {
                PropertyAssociation asso = (PropertyAssociation)this.getParent();
                PropertyXRef target = asso.getTarget();
                asso.unlink();
                target.getParent().delProperty(target);
                asso.link();
            }
            catch (GedcomException e) {
                LOG.log(Level.FINE, "Error during anchor link", e);
            }
        }
    }

    Property getTarget() {
        Property parent = this.getParent();
        if (parent instanceof PropertyAssociation) {
            return ((PropertyAssociation)parent).getTarget();
        }
        return null;
    }

    public TagPath getAnchor() {
        Property panchor;
        Property target = this.getTarget();
        if (target != null && !((panchor = target.getParent()) instanceof Entity) && panchor != null) {
            TagPath result = panchor.getPath(false);
            return panchor.getEntity().getProperty(result) == panchor ? result : panchor.getPath(true);
        }
        return this.anchor;
    }
}

