/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public interface Filter {
    public String getFilterName();

    public boolean veto(Property var1);

    public boolean veto(Entity var1);

    public boolean canApplyTo(Gedcom var1);

    public static class Union
    implements Filter {
        private Set<Property> vetoed = new HashSet<Property>();

        public Union(Gedcom gedcom, Collection<Filter> filters) {
            for (Entity e : gedcom.getEntities()) {
                this.scan(e, filters);
            }
            ArrayDeque<Property> transitive = new ArrayDeque<Property>(this.vetoed);
            while (!transitive.isEmpty()) {
                Property property = (Property)transitive.removeLast();
                for (PropertyXRef xref : property.getProperties(PropertyXRef.class)) {
                    PropertyXRef target;
                    if (!xref.isValid() || (target = xref.getTarget()) == null || !this.vetoed.add(target)) continue;
                    transitive.add(target);
                }
            }
        }

        private void scan(Entity entity, Collection<Filter> filters) {
            if (this.isVetoed(entity, filters)) {
                this.vetoed.add(entity);
            } else {
                for (Property p : entity.getProperties()) {
                    this.scan(p, filters);
                }
            }
        }

        private void scan(Property property, Collection<Filter> filters) {
            if (this.isVetoed(property, filters)) {
                this.vetoed.add(property);
            } else {
                for (Property p : property.getProperties()) {
                    this.scan(p, filters);
                }
            }
        }

        private boolean isVetoed(Entity entity, Collection<Filter> filters) {
            for (Filter filter : filters) {
                if (!filter.veto(entity)) continue;
                return true;
            }
            return false;
        }

        private boolean isVetoed(Property property, Collection<Filter> filters) {
            for (Filter filter : filters) {
                if (!filter.veto(property)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getFilterName() {
            return "Union";
        }

        @Override
        public boolean veto(Property property) {
            return this.vetoed.contains(property);
        }

        @Override
        public boolean veto(Entity entity) {
            return this.vetoed.contains(entity);
        }

        @Override
        public boolean canApplyTo(Gedcom gedcom) {
            return true;
        }
    }
}

