/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.gedcom.Entity;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyXRef;
import genj.io.InputSource;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class MediaRenderer {
    private static final Logger LOG = Logger.getLogger("ancestris.renderer");
    private static final Map<String, CacheEntry> CACHE = new WeakHashMap<String, CacheEntry>();

    public static Dimension getSize(Property root) {
        InputSource source = MediaRenderer.getSource(root);
        if (source == null) {
            return new Dimension();
        }
        return MediaRenderer.getSize(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getSize(InputSource source) {
        CacheEntry cached;
        block18: {
            cached = CACHE.get(source.getName());
            if (cached != null) {
                return cached.size;
            }
            cached = new CacheEntry();
            cached.source = source;
            cached.size = new Dimension();
            CACHE.put(source.getName(), cached);
            try (InputStream in = source.open();){
                if (in == null) break block18;
                LOG.finer("Reading size from " + source);
                ImageInputStream iin = ImageIO.createImageInputStream(in);
                Iterator<ImageReader> iter = ImageIO.getImageReaders(iin);
                if (!iter.hasNext()) break block18;
                ImageReader reader = iter.next();
                try {
                    reader.setInput(iin, false, false);
                    cached.size.setSize(reader.getWidth(0), reader.getHeight(0));
                }
                finally {
                    reader.dispose();
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.FINER, "Can't get image dimension for " + source.getName(), ioe);
            }
        }
        return cached.size;
    }

    public static InputSource getSource(Property prop) {
        Optional<InputSource> ois = MediaRenderer.getInternalSource(prop);
        if (ois.isPresent()) {
            return ois.get();
        }
        return null;
    }

    private static Optional<InputSource> getInternalSource(Property prop) {
        if (prop instanceof PropertyFile) {
            return ((PropertyFile)prop).getInput();
        }
        if (prop instanceof PropertyBlob) {
            return ((PropertyBlob)prop).getInput();
        }
        for (int i = 0; i < prop.getNoOfProperties(); ++i) {
            Property filep;
            Entity e;
            Property child = prop.getProperty(i);
            if (child instanceof PropertyXRef && (e = ((PropertyXRef)child).getTargetEntity()) instanceof Media) {
                Media m = (Media)e;
                PropertyBlob blob = m.getBlob();
                if (blob != null) {
                    return blob.getInput();
                }
                return Optional.ofNullable(m.getFile());
            }
            if (!"OBJE".equals(child.getTag()) || !((filep = child.getProperty("FILE")) instanceof PropertyFile)) continue;
            PropertyFile file = (PropertyFile)filep;
            return file.getInput();
        }
        return Optional.empty();
    }

    public static void render(Graphics g, Rectangle bounds, Property root) {
        Optional<BufferedImage> oImage = MediaRenderer.getScaleImage(root, bounds.width, bounds.height);
        if (oImage.isPresent()) {
            Image image = oImage.get();
            g.drawImage(image, bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height, 0, 0, image.getWidth(null), image.getHeight(null), null);
        }
    }

    public static Optional<BufferedImage> getScaleImage(Property prop, int x, int y) {
        InputSource source = MediaRenderer.getSource(prop);
        if (source == null) {
            return Optional.empty();
        }
        return MediaRenderer.getScaleImage(source, x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<BufferedImage> getScaleImage(InputSource source, int x, int y) {
        BufferedImage image;
        block29: {
            Dimension render = new Dimension(x, y);
            image = null;
            try (InputStream in = source.open();){
                if (in == null) break block29;
                LOG.log(Level.FINE, "Reading image from {0} for {1} and {2}", new Object[]{source, x, y});
                try (ImageInputStream iin = ImageIO.createImageInputStream(in);){
                    Iterator<ImageReader> iter = ImageIO.getImageReaders(iin);
                    if (!iter.hasNext() || x <= 0 || y <= 0) break block29;
                    ImageReader reader = iter.next();
                    try {
                        reader.setInput(iin, false, false);
                        Dimension size = new Dimension(reader.getWidth(0), reader.getHeight(0));
                        ImageReadParam param = reader.getDefaultReadParam();
                        param.setSourceSubsampling(Math.max(1, (int)Math.floor(size.width / x)), Math.max(1, (int)Math.floor(size.height / y)), 0, 0);
                        image = reader.read(0, param);
                    }
                    finally {
                        reader.dispose();
                    }
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.FINER, "Can't get image for " + source, ioe);
            }
        }
        return Optional.ofNullable(image);
    }

    public static Optional<BufferedImage> getImage(InputSource inputSource) {
        BufferedImage image;
        block27: {
            if (inputSource == null) {
                return Optional.empty();
            }
            image = null;
            try (InputStream in = inputSource.open();){
                if (in == null) break block27;
                try (ImageInputStream iin = ImageIO.createImageInputStream(in);){
                    image = ImageIO.read(iin);
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.FINER, "Can't get image for " + inputSource, ioe);
            }
        }
        return Optional.ofNullable(image);
    }

    private static Dimension fit(Dimension a, Dimension b) {
        float scale = Math.min((float)b.width / (float)a.width, (float)b.height / (float)a.height);
        return new Dimension((int)((float)a.width * scale), (int)((float)a.height * scale));
    }

    private static class CacheEntry {
        InputSource source;
        Dimension size;

        private CacheEntry() {
        }
    }
}

