/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.marking;

import ancestris.modules.gedcom.marking.MarkingAction;
import genj.gedcom.Context;
import genj.util.Registry;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MarkingPanel
extends JPanel {
    private Context context;
    private Registry registry = null;
    private Settings settings = new Settings();
    private static String prefix = "_";
    public static final String SEARCH_INDI = "SEARCH_INDI";
    public static final String SEARCH_PARENT_OF = "SEARCH_PARENT_OF";
    public static final String SEARCH_CHILD_OF = "SEARCH_CHILD_OF";
    public static final String SEARCH_SPOUSE_OF = "SEARCH_SPOUSE_OF";
    public static final String SEARCH_ANCESTOR_OF = "SEARCH_ANCESTOR_OF";
    public static final String SEARCH_DESCENDANT_OF = "SEARCH_DESCENDANT_OF";
    public static final String SEARCH_PATRILINE_OF = "SEARCH_PATRILINE_OF";
    public static final String SEARCH_MATRILINE_OF = "SEARCH_MATRILINE_OF";
    public static final String SEARCH_XLINE_OF = "SEARCH_XLINE_OF";
    public static final String[] SEARCH_OPTIONS = new String[]{"SEARCH_INDI", "SEARCH_PARENT_OF", "SEARCH_CHILD_OF", "SEARCH_SPOUSE_OF", "SEARCH_ANCESTOR_OF", "SEARCH_DESCENDANT_OF", "SEARCH_PATRILINE_OF", "SEARCH_MATRILINE_OF", "SEARCH_XLINE_OF"};
    public String[] options = new String[SEARCH_OPTIONS.length];
    private JCheckBox jCheckBoxDisplay;
    private JCheckBox jCheckBoxErase;
    private JCheckBox jCheckBoxImplex;
    private JCheckBox jCheckBoxMark;
    private JCheckBox jCheckBoxMulti;
    private JCheckBox jCheckBoxSearch;
    private JCheckBox jCheckBoxTreeBottom;
    private JCheckBox jCheckBoxTreeTop;
    private JComboBox<String> jComboBoxSearchOptions;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabelActions;
    private JLabel jLabelTag;
    private JLabel jLabelType;
    private JLabel jLabelValue;
    private JSeparator jSeparator1;
    private JTextField jTextFieldImplexTag;
    private JTextField jTextFieldImplexValue;
    private JTextField jTextFieldMultiTag;
    private JTextField jTextFieldMultiValue;
    private JTextField jTextFieldSearchTag;
    private JTextField jTextFieldSearchValue;
    private JTextField jTextFieldTreeBottomTag;
    private JTextField jTextFieldTreeBottomValue;
    private JTextField jTextFieldTreeTopTag;
    private JTextField jTextFieldTreeTopValue;

    public MarkingPanel(Context context) {
        this.context = context;
        this.registry = context.getGedcom().getRegistry();
        for (int i = 0; i < SEARCH_OPTIONS.length; ++i) {
            this.options[i] = NbBundle.getMessage(this.getClass(), (String)SEARCH_OPTIONS[i]);
        }
        this.initComponents();
        this.loadPreferences();
    }

    private void initComponents() {
        this.jLabelType = new JLabel();
        this.jLabelTag = new JLabel();
        this.jLabelValue = new JLabel();
        this.jLabel1 = new JLabel();
        this.jCheckBoxTreeTop = new JCheckBox();
        this.jTextFieldTreeTopTag = new JTextField();
        this.jTextFieldTreeTopValue = new JTextField();
        this.jLabel2 = new JLabel();
        this.jCheckBoxTreeBottom = new JCheckBox();
        this.jTextFieldTreeBottomTag = new JTextField();
        this.jTextFieldTreeBottomValue = new JTextField();
        this.jLabel3 = new JLabel();
        this.jCheckBoxImplex = new JCheckBox();
        this.jTextFieldImplexTag = new JTextField();
        this.jTextFieldImplexValue = new JTextField();
        this.jLabel4 = new JLabel();
        this.jCheckBoxMulti = new JCheckBox();
        this.jTextFieldMultiTag = new JTextField();
        this.jTextFieldMultiValue = new JTextField();
        this.jLabel5 = new JLabel();
        this.jCheckBoxSearch = new JCheckBox();
        this.jTextFieldSearchTag = new JTextField();
        this.jTextFieldSearchValue = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jLabelActions = new JLabel();
        this.jCheckBoxErase = new JCheckBox();
        this.jCheckBoxMark = new JCheckBox();
        this.jCheckBoxDisplay = new JCheckBox();
        this.jComboBoxSearchOptions = new JComboBox();
        Mnemonics.setLocalizedText((JLabel)this.jLabelType, (String)NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jLabelType.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelTag, (String)NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jLabelTag.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelValue, (String)NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jLabelValue.text"));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/marking/ico_treetop.png")));
        this.jLabel1.setLabelFor(this.jCheckBoxTreeTop);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jLabel1.text"));
        this.jLabel1.setBorder(new SoftBevelBorder(0));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxTreeTop, (String)NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jCheckBoxTreeTop.text"));
        this.jCheckBoxTreeTop.setToolTipText(NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jCheckBoxTreeTop.toolTipText"));
        this.jTextFieldTreeTopTag.setText(NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jTextFieldTreeTopTag.text"));
        this.jTextFieldTreeTopTag.setPreferredSize(new Dimension(65, 27));
        this.jTextFieldTreeTopValue.setText(NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jTextFieldTreeTopValue.text"));
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/marking/ico_treebottom.png")));
        this.jLabel2.setLabelFor(this.jCheckBoxTreeTop);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jLabel2.text"));
        this.jLabel2.setBorder(new SoftBevelBorder(0));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxTreeBottom, (String)NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jCheckBoxTreeBottom.text"));
        this.jCheckBoxTreeBottom.setToolTipText(NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jCheckBoxTreeBottom.toolTipText"));
        this.jTextFieldTreeBottomTag.setText(NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jTextFieldTreeBottomTag.text"));
        this.jTextFieldTreeBottomTag.setPreferredSize(new Dimension(65, 27));
        this.jTextFieldTreeBottomValue.setText(NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jTextFieldTreeBottomValue.text"));
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/marking/ico_implex.png")));
        this.jLabel3.setLabelFor(this.jCheckBoxTreeTop);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jLabel3.text"));
        this.jLabel3.setBorder(new SoftBevelBorder(0));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxImplex, (String)NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jCheckBoxImplex.text"));
        this.jCheckBoxImplex.setToolTipText(NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jCheckBoxImplex.toolTipText"));
        this.jTextFieldImplexTag.setText(NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jTextFieldImplexTag.text"));
        this.jTextFieldImplexTag.setPreferredSize(new Dimension(65, 27));
        this.jTextFieldImplexValue.setText(NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jTextFieldImplexValue.text"));
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/marking/ico_multi.png")));
        this.jLabel4.setLabelFor(this.jCheckBoxTreeTop);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jLabel4.text"));
        this.jLabel4.setBorder(new SoftBevelBorder(0));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxMulti, (String)NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jCheckBoxMulti.text"));
        this.jCheckBoxMulti.setToolTipText(NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jCheckBoxMulti.toolTipText"));
        this.jTextFieldMultiTag.setText(NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jTextFieldMultiTag.text"));
        this.jTextFieldMultiTag.setPreferredSize(new Dimension(65, 27));
        this.jTextFieldMultiValue.setText(NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jTextFieldMultiValue.text"));
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/marking/ico_search.png")));
        this.jLabel5.setLabelFor(this.jCheckBoxTreeTop);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jLabel5.text"));
        this.jLabel5.setBorder(new SoftBevelBorder(0));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxSearch, (String)NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jCheckBoxSearch.text"));
        this.jCheckBoxSearch.setToolTipText(NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jCheckBoxSearch.toolTipText"));
        this.jCheckBoxSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarkingPanel.this.jCheckBoxSearchActionPerformed(evt);
            }
        });
        this.jTextFieldSearchTag.setText(NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jTextFieldSearchTag.text"));
        this.jTextFieldSearchTag.setPreferredSize(new Dimension(65, 27));
        this.jTextFieldSearchValue.setText(NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jTextFieldSearchValue.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelActions, (String)NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jLabelActions.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxErase, (String)NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jCheckBoxErase.text"));
        this.jCheckBoxErase.setToolTipText(NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jCheckBoxErase.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxMark, (String)NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jCheckBoxMark.text"));
        this.jCheckBoxMark.setToolTipText(NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jCheckBoxMark.toolTipText"));
        this.jCheckBoxDisplay.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxDisplay, (String)NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jCheckBoxDisplay.text"));
        this.jCheckBoxDisplay.setToolTipText(NbBundle.getMessage(MarkingPanel.class, (String)"MarkingPanel.jCheckBoxDisplay.toolTipText"));
        this.jComboBoxSearchOptions.setModel(new DefaultComboBoxModel<String>(this.options));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel4).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel5)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxSearch).addComponent(this.jCheckBoxMulti).addComponent(this.jCheckBoxImplex).addComponent(this.jCheckBoxTreeBottom).addComponent(this.jCheckBoxTreeTop)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelTag).addComponent(this.jTextFieldTreeTopTag, -1, 169, Short.MAX_VALUE).addComponent(this.jTextFieldTreeBottomTag, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldImplexTag, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldMultiTag, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldSearchTag, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelValue).addComponent(this.jTextFieldTreeTopValue).addComponent(this.jTextFieldTreeBottomValue).addComponent(this.jTextFieldImplexValue, -1, 227, Short.MAX_VALUE).addComponent(this.jTextFieldMultiValue).addComponent(this.jTextFieldSearchValue))).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jSeparator1)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelActions).addComponent(this.jLabelType))).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jCheckBoxErase).addGap(18, 18, 18).addComponent(this.jCheckBoxMark).addGap(18, 18, 18).addComponent(this.jCheckBoxDisplay)).addGroup(layout.createSequentialGroup().addGap(84, 84, 84).addComponent(this.jComboBoxSearchOptions, -2, 371, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelType).addComponent(this.jLabelTag).addComponent(this.jLabelValue)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxTreeTop).addComponent(this.jTextFieldTreeTopTag, -2, -1, -2).addComponent(this.jTextFieldTreeTopValue, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxTreeBottom).addComponent(this.jTextFieldTreeBottomTag, -2, -1, -2).addComponent(this.jTextFieldTreeBottomValue, -2, -1, -2)).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxImplex).addComponent(this.jTextFieldImplexTag, -2, -1, -2).addComponent(this.jTextFieldImplexValue, -2, -1, -2)).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxMulti).addComponent(this.jTextFieldMultiTag, -2, -1, -2).addComponent(this.jTextFieldMultiValue, -2, -1, -2)).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxSearch).addComponent(this.jTextFieldSearchTag, -2, -1, -2).addComponent(this.jTextFieldSearchValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxSearchOptions, -2, -1, -2)).addComponent(this.jLabel5)).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelActions).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxMark).addComponent(this.jCheckBoxDisplay).addComponent(this.jCheckBoxErase)).addContainerGap()));
    }

    private void jCheckBoxSearchActionPerformed(ActionEvent evt) {
        this.jComboBoxSearchOptions.setVisible(this.jCheckBoxSearch.isSelected());
    }

    private void loadPreferences() {
        this.jCheckBoxTreeTop.setSelected(this.registry.get("MarkingTreeTop", false));
        this.jTextFieldTreeTopTag.setText(this.registry.get("MarkingTreeTopTag", NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jTextFieldTreeTopTag.text")));
        this.jTextFieldTreeTopValue.setText(this.registry.get("MarkingTreeTopValue", NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jTextFieldTreeTopValue.text")));
        this.jCheckBoxTreeBottom.setSelected(this.registry.get("MarkingTreeBottom", false));
        this.jTextFieldTreeBottomTag.setText(this.registry.get("MarkingTreeBottomTag", NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jTextFieldTreeBottomTag.text")));
        this.jTextFieldTreeBottomValue.setText(this.registry.get("MarkingTreeBottomValue", NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jTextFieldTreeBottomValue.text")));
        this.jCheckBoxImplex.setSelected(this.registry.get("MarkingImplex", false));
        this.jTextFieldImplexTag.setText(this.registry.get("MarkingImplexTag", NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jTextFieldImplexTag.text")));
        this.jTextFieldImplexValue.setText(this.registry.get("MarkingImplexValue", NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jTextFieldImplexValue.text")));
        this.jCheckBoxMulti.setSelected(this.registry.get("MarkingMulti", false));
        this.jTextFieldMultiTag.setText(this.registry.get("MarkingMultiTag", NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jTextFieldMultiTag.text")));
        this.jTextFieldMultiValue.setText(this.registry.get("MarkingMultiValue", NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jTextFieldMultiValue.text")));
        this.jCheckBoxSearch.setSelected(this.registry.get("MarkingSearch", false));
        this.jTextFieldSearchTag.setText(this.registry.get("MarkingSearchTag", NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jTextFieldSearchTag.text")));
        this.jTextFieldSearchValue.setText(this.registry.get("MarkingSearchValue", NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jTextFieldSearchValue.text")));
        this.jComboBoxSearchOptions.setSelectedIndex(this.indexOf(this.registry.get("MarkingSearchOption", SEARCH_INDI)));
        this.jCheckBoxErase.setSelected(this.registry.get("MarkingErase", false));
        this.jCheckBoxMark.setSelected(this.registry.get("MarkingMark", false));
        this.jCheckBoxDisplay.setSelected(this.registry.get("MarkingDisplay", true));
        if (!(this.jCheckBoxErase.isSelected() || this.jCheckBoxMark.isSelected() || this.jCheckBoxDisplay.isSelected())) {
            this.jCheckBoxDisplay.setSelected(true);
        }
        this.jComboBoxSearchOptions.setVisible(this.jCheckBoxSearch.isSelected());
    }

    public void savePreferences() {
        this.settings.isTreeTop = this.jCheckBoxTreeTop.isSelected();
        this.settings.treeTopTag = this.jTextFieldTreeTopTag.getText().toUpperCase();
        if (!this.settings.treeTopTag.startsWith(prefix)) {
            this.settings.treeTopTag = prefix + this.settings.treeTopTag;
        }
        this.settings.treeTopValue = this.jTextFieldTreeTopValue.getText();
        this.settings.isTreeBottom = this.jCheckBoxTreeBottom.isSelected();
        this.settings.treeBottomTag = this.jTextFieldTreeBottomTag.getText().toUpperCase();
        if (!this.settings.treeBottomTag.startsWith(prefix)) {
            this.settings.treeBottomTag = prefix + this.settings.treeBottomTag;
        }
        this.settings.treeBottomValue = this.jTextFieldTreeBottomValue.getText();
        this.settings.isImplex = this.jCheckBoxImplex.isSelected();
        this.settings.implexTag = this.jTextFieldImplexTag.getText().toUpperCase();
        if (!this.settings.implexTag.startsWith(prefix)) {
            this.settings.implexTag = prefix + this.settings.implexTag;
        }
        this.settings.implexValue = this.jTextFieldImplexValue.getText();
        this.settings.isMulti = this.jCheckBoxMulti.isSelected();
        this.settings.multiTag = this.jTextFieldMultiTag.getText().toUpperCase();
        if (!this.settings.multiTag.startsWith(prefix)) {
            this.settings.multiTag = prefix + this.settings.multiTag;
        }
        this.settings.multiValue = this.jTextFieldMultiValue.getText();
        this.settings.isSearch = this.jCheckBoxSearch.isSelected();
        this.settings.searchTag = this.jTextFieldSearchTag.getText().toUpperCase();
        if (!this.settings.searchTag.startsWith(prefix)) {
            this.settings.searchTag = prefix + this.settings.searchTag;
        }
        this.settings.searchValue = this.jTextFieldSearchValue.getText();
        this.settings.searchOption = SEARCH_OPTIONS[this.jComboBoxSearchOptions.getSelectedIndex()];
        this.settings.toBeErased = this.jCheckBoxErase.isSelected();
        this.settings.toBeMarked = this.jCheckBoxMark.isSelected();
        this.settings.toBeDisplayed = this.jCheckBoxDisplay.isSelected();
        this.registry.put("MarkingTreeTop", Boolean.valueOf(this.settings.isTreeTop));
        this.registry.put("MarkingTreeTopTag", this.settings.treeTopTag);
        this.registry.put("MarkingTreeTopValue", this.settings.treeTopValue);
        this.registry.put("MarkingTreeBottom", Boolean.valueOf(this.settings.isTreeBottom));
        this.registry.put("MarkingTreeBottomTag", this.settings.treeBottomTag);
        this.registry.put("MarkingTreeBottomValue", this.settings.treeBottomValue);
        this.registry.put("MarkingImplex", Boolean.valueOf(this.settings.isImplex));
        this.registry.put("MarkingImplexTag", this.settings.implexTag);
        this.registry.put("MarkingImplexValue", this.settings.implexValue);
        this.registry.put("MarkingMulti", Boolean.valueOf(this.settings.isMulti));
        this.registry.put("MarkingMultiTag", this.settings.multiTag);
        this.registry.put("MarkingMultiValue", this.settings.multiValue);
        this.registry.put("MarkingSearch", Boolean.valueOf(this.settings.isSearch));
        this.registry.put("MarkingSearchTag", this.settings.searchTag);
        this.registry.put("MarkingSearchValue", this.settings.searchValue);
        this.registry.put("MarkingSearchOption", this.settings.searchOption);
        this.registry.put("MarkingErase", Boolean.valueOf(this.settings.toBeErased));
        this.registry.put("MarkingMark", Boolean.valueOf(this.settings.toBeMarked));
        this.registry.put("MarkingDisplay", Boolean.valueOf(this.settings.toBeDisplayed));
    }

    public Settings getSettings() {
        return this.settings;
    }

    private int indexOf(String value) {
        for (int i = 0; i < SEARCH_OPTIONS.length; ++i) {
            if (!SEARCH_OPTIONS[i].equals(value)) continue;
            return i;
        }
        return 0;
    }

    public static class Settings {
        public boolean isTreeTop = true;
        public boolean isTreeBottom = true;
        public boolean isImplex = true;
        public boolean isMulti = true;
        public boolean isSearch = true;
        public String treeTopTag = "";
        public String treeBottomTag = "";
        public String implexTag = "";
        public String multiTag = "";
        public String searchTag = "";
        public String treeTopValue = "";
        public String treeBottomValue = "";
        public String implexValue = "";
        public String multiValue = "";
        public String searchValue = "";
        public String searchOption = "";
        public boolean toBeErased = true;
        public boolean toBeMarked = true;
        public boolean toBeDisplayed = true;

        public String displaySettings() {
            String output = "";
            output = output + NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jCheckBoxTreeTop.text") + " : " + (this.isTreeTop ? NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jTextFieldTreeTopTag.text") + "=" + this.treeTopValue : " - ") + "\n";
            output = output + NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jCheckBoxTreeBottom.text") + " : " + (this.isTreeBottom ? NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jTextFieldTreeBottomTag.text") + "=" + this.treeBottomValue : " - ") + "\n";
            output = output + NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jCheckBoxImplex.text") + " : " + (this.isImplex ? NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jTextFieldImplexTag.text") + "=" + this.implexValue : " - ") + "\n";
            output = output + "   " + NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jCheckBoxImplex.toolTipText") + "\n";
            output = output + NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jCheckBoxMulti.text") + " : " + (this.isMulti ? NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jTextFieldMultiTag.text") + "=" + this.multiValue : " - ") + "\n";
            output = output + "   " + NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jCheckBoxMulti.toolTipText") + "\n";
            output = output + NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jCheckBoxSearch.text") + " : " + (this.isSearch ? NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jTextFieldSearchTag.text") + "=" + this.searchValue : " - ") + "\n";
            output = output + "\n";
            output = output + NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jCheckBoxErase.text") + " : " + (this.toBeErased ? " 1 " : " - ") + "\n";
            output = output + NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jCheckBoxMark.text") + " : " + (this.toBeMarked ? " 1 " : " - ") + "\n";
            output = output + NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.jCheckBoxDisplay.text") + " : " + (this.toBeDisplayed ? " 1 " : " - ") + "\n";
            return output;
        }
    }
}

