/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.datulette;

import ancestris.util.Utilities;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.io.FileAssociation;
import genj.util.WordBuffer;
import genj.util.swing.DateWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class DatuTopComponent
extends TopComponent {
    private static DatuTopComponent instance;
    static final String ICON_PATH = "ancestris/modules/datulette/datulette.png";
    private static final String PREFERRED_ID = "DatuTopComponent";
    private DateWidget dw1 = new DateWidget();
    private boolean updateInProgress = false;
    private Calendar from = PointInTime.GREGORIAN;
    private Calendar to = PointInTime.FRENCHR;
    private int gap = 0;
    private int incertitude = 0;
    private JButton jButton1;
    private JComboBox<Calendar> jComboBox1;
    private JComboBox<Calendar> jComboBox2;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JSlider jSliderGap;
    private JTextField jTextFieldGap;
    private JTextField jTextFieldGap1;

    public DatuTopComponent() {
        this.initComponents();
        this.putClientProperty("netbeans.winsys.tc.keep_preferred_size_when_slided_in", Boolean.TRUE);
        this.jSliderGap.setMajorTickSpacing(50);
        this.jSliderGap.setMinorTickSpacing(10);
        this.jSliderGap.setPaintTicks(true);
        this.jSliderGap.setPaintLabels(true);
        this.jSliderGap.setValue(this.gap);
        this.jTextFieldGap.setText(String.format(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.year"), this.gap));
        this.jComboBox1.setSelectedItem(this.from);
        this.jComboBox2.setSelectedItem(this.to);
        ((TitledBorder)this.jPanel5.getBorder()).setTitle("");
        this.setName(NbBundle.getMessage(DatuTopComponent.class, (String)"CTL_DatuTopComponent"));
        this.setToolTipText(NbBundle.getMessage(DatuTopComponent.class, (String)"HINT_DatuTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.dw1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!DatuTopComponent.this.updateInProgress) {
                    DatuTopComponent.this.updateInProgress = true;
                    DatuTopComponent.this.updateTooltip();
                    if (DatuTopComponent.this.dw1.getCalendar() != null) {
                        DatuTopComponent.this.update();
                    }
                    DatuTopComponent.this.updateInProgress = false;
                }
            }
        });
    }

    public void update() {
        PointInTime Pit;
        try {
            this.incertitude = Integer.parseInt(this.jTextFieldGap1.getText());
        }
        catch (NumberFormatException ex) {
            this.incertitude = 0;
        }
        if (this.incertitude == 1) {
            this.jLabel4.setText(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.month"));
        } else if (this.gap != 0) {
            this.jLabel4.setText(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.months"));
        }
        if (this.dw1.getValue() != null && (Pit = this.dw1.getValue()).isComplete()) {
            this.jLabel1.setText(this.calcule(Pit));
        }
    }

    private void updateTooltip() {
        Calendar cal = this.dw1.getCalendar();
        if (cal != null) {
            this.jComboBox1.setSelectedItem(cal);
            if (cal.equals(PointInTime.GREGORIAN)) {
                this.jPanel5.setToolTipText(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.calendar.gregorian.toolTipText"));
            } else if (cal.equals(PointInTime.FRENCHR)) {
                this.jPanel5.setToolTipText(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.calendar.frenchR.toolTipText"));
            } else {
                this.jPanel5.setToolTipText(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.calendar.others.toolTipText"));
            }
            this.jPanel5.repaint();
        }
    }

    private String calcule(PointInTime pitInitial) {
        String result = null;
        if (this.incertitude == 0) {
            PointInTime pit = new PointInTime();
            pit.set(pitInitial);
            try {
                pit.set((Calendar)PointInTime.GREGORIAN);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            pit.add(0, 0, this.gap);
            try {
                pit.set(this.to);
            }
            catch (GedcomException ex) {
                // empty catch block
            }
            result = pit.toString(new WordBuffer(), GedcomOptions.GedcomDateFormat.LONG).toString();
        } else {
            PointInTime pitMini = new PointInTime();
            pitMini.set(pitInitial);
            try {
                pitMini.set((Calendar)PointInTime.GREGORIAN);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            pitMini.add(0, this.incertitude * -1, this.gap);
            try {
                pitMini.set(this.to);
            }
            catch (GedcomException ex) {
                // empty catch block
            }
            PointInTime pitMaxi = new PointInTime();
            pitMaxi.set(pitInitial);
            try {
                pitMaxi.set((Calendar)PointInTime.GREGORIAN);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            pitMaxi.add(0, this.incertitude, this.gap);
            try {
                pitMaxi.set(this.to);
            }
            catch (GedcomException gedcomException) {
                // empty catch block
            }
            result = String.format(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.FromTo"), pitMini.toString(new WordBuffer(), GedcomOptions.GedcomDateFormat.LONG), pitMaxi.toString(new WordBuffer(), GedcomOptions.GedcomDateFormat.LONG));
        }
        return result;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jSliderGap = new JSlider();
        this.jTextFieldGap = new JTextField();
        this.jPanel7 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jTextFieldGap1 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox<Calendar>(PointInTime.CALENDARS);
        this.jLabel3 = new JLabel();
        this.jComboBox2 = new JComboBox<Calendar>(PointInTime.CALENDARS);
        this.jButton1 = new JButton();
        FormListener formListener = new FormListener();
        this.setPreferredSize(new Dimension(300, 430));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 430));
        this.jScrollPane1.setRequestFocusEnabled(false);
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jPanel1.setMaximumSize(null);
        this.jPanel1.setOpaque(false);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.jPanel5.border.title"), 0, 0, new Font("Bitstream Vera Sans", 1, 12), Color.black));
        this.jPanel5.setToolTipText(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.calendar.gregorian.toolTipText"));
        this.jPanel5.setOpaque(false);
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 2));
        this.jPanel2.add(Box.createHorizontalGlue());
        this.jPanel2.add((Component)this.dw1);
        this.jPanel2.add(Box.createRigidArea(new Dimension(2, 0)));
        this.jPanel2.setSize(this.jPanel5.getPreferredSize().width, this.dw1.getPreferredSize().height + 10);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.jPanel3.border.title"), 0, 0, new Font("Bitstream Vera Sans", 1, 12), Color.black));
        this.jPanel3.setToolTipText(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.jPanel3.toolTipText"));
        this.jPanel3.setOpaque(false);
        this.jPanel3.setPreferredSize(new Dimension(0, 0));
        this.jSliderGap.setFont(new Font("Dialog", 1, 8));
        this.jSliderGap.setMinimum(-100);
        this.jSliderGap.setToolTipText(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.jSliderGap.toolTipText"));
        this.jSliderGap.setValue(0);
        this.jSliderGap.addChangeListener(formListener);
        this.jTextFieldGap.setEditable(false);
        this.jTextFieldGap.setFont(new Font("DejaVu Sans", 0, 10));
        this.jTextFieldGap.setHorizontalAlignment(0);
        this.jTextFieldGap.setText(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.jTextFieldGap.text"));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jSliderGap, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldGap, -2, -1, -2).addGap(1, 1, 1)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldGap, -2, -1, -2).addGroup(jPanel3Layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.jSliderGap, -2, -1, -2))).addContainerGap(24, Short.MAX_VALUE)));
        this.jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.jPanel7.border.title"), 0, 0, new Font("Bitstream Vera Sans", 1, 12), Color.black));
        this.jPanel7.setToolTipText(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.jPanel7.toolTipText"));
        this.jPanel7.setOpaque(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.jLabel5.text"));
        this.jTextFieldGap1.setColumns(2);
        this.jTextFieldGap1.setFont(new Font("Dialog", 1, 12));
        this.jTextFieldGap1.setHorizontalAlignment(0);
        this.jTextFieldGap1.setText(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.jTextFieldGap1.text"));
        this.jTextFieldGap1.setToolTipText(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.jTextFieldGap1.toolTipText"));
        this.jTextFieldGap1.addKeyListener(formListener);
        this.jLabel4.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.month"));
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldGap1, -1, 189, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addGap(0, 0, 0)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldGap1, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jLabel5)));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.jPanel6.border.title"), 0, 0, new Font("Bitstream Vera Sans", 1, 12), Color.black));
        this.jPanel6.setToolTipText(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.result.toolTipText"));
        this.jPanel6.setOpaque(false);
        this.jPanel6.setPreferredSize(new Dimension(196, 93));
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel1.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.jLabel1.text"));
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, 45, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jComboBox1.setModel(new DefaultComboBoxModel<Calendar>(PointInTime.CALENDARS));
        this.jComboBox1.setToolTipText(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.jComboBox1.toolTipText"));
        this.jComboBox1.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.jLabel3.text"));
        this.jComboBox2.setModel(new DefaultComboBoxModel<Calendar>(PointInTime.CALENDARS));
        this.jComboBox2.setToolTipText(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.jComboBox2.toolTipText"));
        this.jComboBox2.addActionListener(formListener);
        this.jButton1.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/datulette/FrenchR.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.jButton1.text"));
        this.jButton1.setToolTipText(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.jButton1.toolTipText"));
        this.jButton1.addActionListener(formListener);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel6, GroupLayout.Alignment.TRAILING, -1, 280, Short.MAX_VALUE).addComponent(this.jPanel7, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, 280, Short.MAX_VALUE).addComponent(this.jPanel5, -1, 280, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox1, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox2, 0, -1, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBox2, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jPanel3, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -2, 82, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addContainerGap(-1, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, -1, Short.MAX_VALUE));
    }

    private void jSliderGapStateChanged(ChangeEvent evt) {
        if (!this.jSliderGap.getValueIsAdjusting()) {
            this.gap = this.jSliderGap.getValue();
            String texte = "";
            if (this.gap == 1 || this.gap == 0) {
                texte = texte + String.format(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.year"), this.gap);
            } else if (this.gap != 0) {
                texte = texte + String.format(NbBundle.getMessage(DatuTopComponent.class, (String)"DatuTopComponent.years"), this.gap);
            }
            this.jTextFieldGap.setText(texte);
            this.update();
        }
    }

    private void jComboBox2ActionPerformed(ActionEvent evt) {
        this.to = (Calendar)this.jComboBox2.getSelectedItem();
        this.update();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        PointInTime pit = this.dw1.getValue();
        if (pit != null) {
            this.from = (Calendar)this.jComboBox1.getSelectedItem();
            try {
                pit.set(this.from);
                if (!this.updateInProgress) {
                    this.dw1.setValue(pit);
                }
            }
            catch (GedcomException ex) {
                this.jComboBox1.setSelectedItem(pit.getCalendar());
            }
            this.update();
        }
        this.updateTooltip();
    }

    private void jTextFieldGap1KeyReleased(KeyEvent evt) {
        this.update();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            String filename = "republicain.jpg";
            File file = Utilities.getResourceAsFile(((Object)((Object)this)).getClass(), (String)filename, (String)filename);
            FileAssociation.getDefault().execute(file.getAbsolutePath());
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static synchronized DatuTopComponent getDefault() {
        if (instance == null) {
            instance = new DatuTopComponent();
        }
        return instance;
    }

    public static synchronized DatuTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(DatuTopComponent.class.getName()).warning("Cannot find DatuTopComponent component. It will not be located properly in the window system.");
            return DatuTopComponent.getDefault();
        }
        if (win instanceof DatuTopComponent) {
            return (DatuTopComponent)win;
        }
        Logger.getLogger(DatuTopComponent.class.getName()).warning("There seem to be multiple components with the 'DatuTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return DatuTopComponent.getDefault();
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    Object readProperties(Properties p) {
        if (instance == null) {
            instance = this;
        }
        return instance;
    }

    public int getPersistenceType() {
        return 0;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private class FormListener
    implements ActionListener,
    KeyListener,
    ChangeListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == DatuTopComponent.this.jComboBox1) {
                DatuTopComponent.this.jComboBox1ActionPerformed(evt);
            } else if (evt.getSource() == DatuTopComponent.this.jComboBox2) {
                DatuTopComponent.this.jComboBox2ActionPerformed(evt);
            } else if (evt.getSource() == DatuTopComponent.this.jButton1) {
                DatuTopComponent.this.jButton1ActionPerformed(evt);
            }
        }

        @Override
        public void keyPressed(KeyEvent evt) {
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            if (evt.getSource() == DatuTopComponent.this.jTextFieldGap1) {
                DatuTopComponent.this.jTextFieldGap1KeyReleased(evt);
            }
        }

        @Override
        public void keyTyped(KeyEvent evt) {
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            if (evt.getSource() == DatuTopComponent.this.jSliderGap) {
                DatuTopComponent.this.jSliderGapStateChanged(evt);
            }
        }
    }
}

