/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.searchduplicates;

import ancestris.modules.gedcom.matchers.MatcherOptions;
import ancestris.modules.gedcom.matchers.MatcherOptionsPanel;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.util.Registry;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SearchDuplicatesPanel
extends JPanel {
    private Registry registry = null;
    private Gedcom gedcom = null;
    private JButton OKButton = null;
    private TreeMap<String, JCheckBox> entitiesChoices = new TreeMap();
    private TreeMap<String, JButton> entitiesButtons = new TreeMap();
    private TreeMap<String, MatcherOptions> selectedOptions = new TreeMap();
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBox5;
    private JCheckBox jCheckBox6;
    private JCheckBox jCheckBox7;
    private JLabel jLabelSelect;
    private JLabel jLabelText;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;

    public SearchDuplicatesPanel(Gedcom gedcom, JButton OKButton) {
        this.gedcom = gedcom;
        this.OKButton = OKButton;
        this.registry = Registry.get(this.getClass());
        this.initComponents();
        this.entitiesChoices.put("INDI", this.jCheckBox1);
        this.entitiesChoices.put("FAM", this.jCheckBox2);
        this.entitiesChoices.put("SUBM", this.jCheckBox3);
        this.entitiesChoices.put("REPO", this.jCheckBox4);
        this.entitiesChoices.put("SOUR", this.jCheckBox5);
        this.entitiesChoices.put("NOTE", this.jCheckBox6);
        this.entitiesChoices.put("OBJE", this.jCheckBox7);
        this.entitiesButtons.put("INDI", this.jButton1);
        this.entitiesButtons.put("FAM", this.jButton2);
        this.entitiesButtons.put("SUBM", this.jButton3);
        this.entitiesButtons.put("REPO", this.jButton4);
        this.entitiesButtons.put("SOUR", this.jButton5);
        this.entitiesButtons.put("NOTE", this.jButton6);
        this.entitiesButtons.put("OBJE", this.jButton7);
        for (String entityTag : this.entitiesChoices.keySet()) {
            JCheckBox cb = this.entitiesChoices.get(entityTag);
            int size = gedcom.getEntities(entityTag).size();
            cb.setText(Gedcom.getName((String)entityTag) + " (" + size + ")");
            cb.setEnabled(size > 0);
            cb.setSelected(size > 0 && this.registry.get("duplicateSelected." + entityTag, entityTag.equals("INDI")));
            JButton b = this.entitiesButtons.get(entityTag);
            b.setText(NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jButton.text"));
            b.setEnabled(size > 0);
            cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchDuplicatesPanel.this.setButton();
                }
            });
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchDuplicatesPanel.this.openCriteria((JButton)e.getSource());
                }
            });
        }
        this.setButton();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jLabelText = new JLabel();
        this.jLabelSelect = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jButton1 = new JButton();
        this.jCheckBox2 = new JCheckBox();
        this.jButton2 = new JButton();
        this.jCheckBox3 = new JCheckBox();
        this.jButton3 = new JButton();
        this.jCheckBox4 = new JCheckBox();
        this.jButton4 = new JButton();
        this.jCheckBox5 = new JCheckBox();
        this.jButton5 = new JButton();
        this.jCheckBox6 = new JCheckBox();
        this.jButton6 = new JButton();
        this.jCheckBox7 = new JCheckBox();
        this.jButton7 = new JButton();
        this.setPreferredSize(new Dimension(340, 359));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SearchDuplicatesPanel.this.formComponentResized(evt);
            }
        });
        this.jScrollPane1.setPreferredSize(new Dimension(346, 359));
        this.jPanel1.setPreferredSize(new Dimension(330, 353));
        Mnemonics.setLocalizedText((JLabel)this.jLabelText, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jLabelText.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelSelect, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jLabelSelect.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jCheckBox1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jButton1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox2, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jCheckBox2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jButton2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox3, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jCheckBox3.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton3, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jButton3.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox4, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jCheckBox4.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton4, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jButton4.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox5, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jCheckBox5.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton5, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jButton5.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox6, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jCheckBox6.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton6, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jButton6.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox7, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jCheckBox7.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton7, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jButton7.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelSelect).addGroup(jPanel1Layout.createSequentialGroup().addGap(40, 40, 40).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox2).addComponent(this.jCheckBox1).addComponent(this.jCheckBox3).addComponent(this.jCheckBox6).addComponent(this.jCheckBox7).addComponent(this.jCheckBox4).addComponent(this.jCheckBox5)).addGap(40, 40, 40).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton3).addComponent(this.jButton4).addComponent(this.jButton5).addComponent(this.jButton6).addComponent(this.jButton7).addComponent(this.jButton1).addComponent(this.jButton2)))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabelText, -1, 320, Short.MAX_VALUE).addContainerGap()))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelText, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelSelect).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox1).addComponent(this.jButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox2).addComponent(this.jButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox3).addComponent(this.jButton3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox4).addComponent(this.jButton4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox5).addComponent(this.jButton5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox6).addComponent(this.jButton6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox7).addComponent(this.jButton7)).addContainerGap()));
        this.jScrollPane1.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 338, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, -1, Short.MAX_VALUE));
    }

    private void formComponentResized(ComponentEvent evt) {
    }

    public List<String> getEntitiesToCheck() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String entityTag : this.entitiesChoices.keySet()) {
            JCheckBox cb = this.entitiesChoices.get(entityTag);
            if (!cb.isSelected()) continue;
            ret.add(entityTag);
        }
        return ret;
    }

    public TreeMap<String, MatcherOptions> getSelectedOptions() {
        for (String entityTag : this.entitiesChoices.keySet()) {
            JCheckBox cb = this.entitiesChoices.get(entityTag);
            if (!cb.isSelected()) continue;
            this.selectedOptions.put(entityTag, new MatcherOptionsPanel(entityTag).getMatcherOptions());
        }
        return this.selectedOptions;
    }

    private void setButton() {
        boolean activated = false;
        for (String entityTag : this.entitiesChoices.keySet()) {
            JCheckBox cb = this.entitiesChoices.get(entityTag);
            activated |= cb.isSelected();
            this.registry.put("duplicateSelected." + entityTag, Boolean.valueOf(cb.isSelected()));
        }
        this.OKButton.setEnabled(activated);
    }

    private void openCriteria(JButton b) {
        for (String entityTag : this.entitiesButtons.keySet()) {
            JButton readB = this.entitiesButtons.get(entityTag);
            if (!b.equals(readB)) continue;
            MatcherOptionsPanel panel = new MatcherOptionsPanel(entityTag);
            Object o = DialogManager.create((String)NbBundle.getMessage(MatcherOptionsPanel.class, (String)"CTL_MatcherOptionsTitle"), (JComponent)panel).setMessageType(-1).setOptions(new Object[]{DialogManager.OK_OPTION, DialogManager.CANCEL_OPTION}).show();
            if (o != DialogManager.OK_OPTION) {
                return;
            }
            this.selectedOptions.put(entityTag, panel.getMatcherOptions());
        }
    }
}

