/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.app.App;
import ancestris.app.DisplaySettingsPanel;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.GedcomDirectory;
import ancestris.gedcom.GedcomFileListener;
import ancestris.util.Lifecycle;
import ancestris.util.swing.DialogManager;
import ancestris.view.AncestrisTopComponent;
import ancestris.view.AncestrisViewInterface;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.util.EnvironmentChecker;
import genj.util.Origin;
import genj.util.Registry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.commons.io.FileUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;

public final class ActionSaveLayout
implements ActionListener,
GedcomFileListener {
    public void commitRequested(Context context) {
    }

    public void gedcomClosed(Gedcom gedcom) {
        ActionSaveLayout.saveLayout(gedcom);
    }

    public void gedcomOpened(Gedcom gedcom) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String absolutePath;
        List ctx;
        Context selected = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
        if (selected == null && !(ctx = GedcomDirectory.getDefault().getContexts()).isEmpty()) {
            selected = (Context)ctx.get(0);
        }
        Gedcom gedcom = selected != null ? selected.getGedcom() : null;
        boolean existsGedcomSettings = false;
        boolean existsDefaultSettings = false;
        if (gedcom != null) {
            Registry reg = gedcom.getRegistry();
            existsGedcomSettings = this.existDock(reg);
        }
        if (!(absolutePath = EnvironmentChecker.getProperty((String)"user.home.ancestris", (String)"", (String)"")).isEmpty()) {
            absolutePath = absolutePath + "/../config/Preferences/ancestris/modules/";
            File dir = new File(absolutePath);
            for (File file : FileUtils.listFiles((File)dir, (String[])new String[]{"properties"}, (boolean)true)) {
                if (!file.getAbsolutePath().contains("ancestris-modules")) continue;
                String debug = this.getNodeFromFile(file);
                Registry reg = Registry.get((String)this.getNodeFromFile(file));
                existsDefaultSettings |= this.existDock(reg);
            }
        }
        Registry defaultSettings = Registry.get(AncestrisViewInterface.class);
        DateFormat mediumDateFormat = DateFormat.getDateTimeInstance(2, 2);
        String date = "";
        date = defaultSettings.get("openViews.date", (String)null) != null ? mediumDateFormat.format(new Date(new Long(defaultSettings.get("openViews.date", "0")))) : NbBundle.getMessage(this.getClass(), (String)"TXT_ASL_never");
        DisplaySettingsPanel layoutPanel = new DisplaySettingsPanel(gedcom, existsGedcomSettings, existsDefaultSettings, date);
        Object choice = DialogManager.create((String)NbBundle.getMessage(ActionSaveLayout.class, (String)"TTL_LayoutSetting"), (JComponent)layoutPanel).setMessageType(-1).setOptionType(2).setDialogId("windowSetting").show();
        if (choice == DialogManager.OK_OPTION) {
            switch (layoutPanel.getAction()) {
                case "currentSave": {
                    ActionSaveLayout.saveLayout(gedcom, false);
                    break;
                }
                case "currentRestore": {
                    this.eraseLayout(gedcom, selected, existsDefaultSettings);
                    break;
                }
                case "defaultSave": {
                    this.saveDefaultLayout(gedcom);
                    break;
                }
                case "defaultRestore": {
                    this.eraseDefaultLayout(false);
                    break;
                }
                case "allErase": {
                    this.eraseAllLayout(gedcom != null);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    public static void saveLayout(Gedcom gedcom) {
        ActionSaveLayout.saveLayout(gedcom, true);
    }

    public static void saveLayout(Gedcom gedcom, boolean quiet) {
        ArrayList<String> openedViews = new ArrayList<String>();
        ArrayList<String> focusViews = new ArrayList<String>();
        Registry gedcomPrefs = gedcom.getRegistry();
        TopComponent tcHasFocus = TopComponent.getRegistry().getActivated();
        for (AncestrisViewInterface gjvTc : AncestrisPlugin.lookupAll(AncestrisViewInterface.class)) {
            if (!((AncestrisTopComponent)gjvTc).isOpened() || !gedcom.equals(gjvTc.getGedcom())) continue;
            Mode mode = gjvTc.getMode();
            App.LOG.info("Saving current mode for gedcom " + gedcom.getName() + " and for " + gjvTc.getClass().getName() + ": " + mode.getName());
            gedcomPrefs.put(((AncestrisTopComponent)gjvTc).getPreferencesKey("dockMode"), mode.getName());
            if (gjvTc.equals(mode.getSelectedTopComponent()) && !gjvTc.equals(tcHasFocus)) {
                focusViews.add(gjvTc.getClass().getName());
            }
            openedViews.add(gjvTc.getClass().getName());
        }
        if (tcHasFocus instanceof AncestrisTopComponent) {
            focusViews.add(tcHasFocus.getClass().getName());
        }
        gedcomPrefs.put("openViews", openedViews);
        gedcomPrefs.put("focusViews", focusViews);
        gedcomPrefs.put("openViews.date", System.currentTimeMillis() + "");
        if (quiet) {
            return;
        }
        DialogManager.create((String)NbBundle.getMessage(ActionSaveLayout.class, (String)"TTL_LayoutSetting"), (String)(NbBundle.getMessage(ActionSaveLayout.class, (String)"DisplaySettingsPanel.saveCurrentRadioButton.text") + ": " + NbBundle.getMessage(ActionSaveLayout.class, (String)"DLG_Done"))).setMessageType(1).setOptionType(10).show();
    }

    private void eraseLayout(Gedcom gedcom, Context context, boolean existsDefaultSettings) {
        Object choice = DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"DisplaySettingsPanel.currentLabel.text", (Object)(gedcom.getDisplayName() + " ")), (String)NbBundle.getMessage(this.getClass(), (String)"DLG_ActionEraseLayout", (Object)gedcom.getDisplayName())).setMessageType(3).setOptionType(0).setDialogId("windowSetting.eraseLayout").show();
        if (choice != DialogManager.YES_OPTION) {
            return;
        }
        Origin origin = gedcom.getOrigin();
        GedcomDirectory.getDefault().closeGedcom(context);
        Registry gedcomPrefs = gedcom.getRegistry();
        gedcomPrefs.remove("openViews");
        gedcomPrefs.remove("focusViews");
        this.removeModeFromRegistry(gedcomPrefs);
        GedcomDirectory.getDefault().openAncestrisGedcom(FileUtil.toFileObject((File)origin.getFile()));
        String text = NbBundle.getMessage(ActionSaveLayout.class, (String)"DisplaySettingsPanel.resetCurrentRadioButton.text", (Object)(existsDefaultSettings ? NbBundle.getMessage(ActionSaveLayout.class, (String)"DisplaySettingsPanel.resetCurrentRadioButton.userLayout") : NbBundle.getMessage(ActionSaveLayout.class, (String)"DisplaySettingsPanel.resetCurrentRadioButton.AncestrisLayout")));
        DialogManager.create((String)NbBundle.getMessage(ActionSaveLayout.class, (String)"TTL_LayoutSetting"), (String)(text + ": " + NbBundle.getMessage(ActionSaveLayout.class, (String)"DLG_Done"))).setMessageType(1).setOptionType(10).show();
    }

    public void saveDefaultLayout(Gedcom gedcom) {
        Registry defaultSettings = Registry.get(AncestrisViewInterface.class);
        Object date = defaultSettings.get("openViews.date", (String)null) == null ? NbBundle.getMessage(this.getClass(), (String)"TXT_ASL_never") : new Date(new Long(defaultSettings.get("openViews.date", "0")));
        Object choice = DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"DisplaySettingsPanel.userLabel.text"), (String)NbBundle.getMessage(this.getClass(), (String)"DLG_ActionSaveLayout", (Object)gedcom.getDisplayName(), (Object)date)).setMessageType(3).setOptionType(0).setDialogId("windowSetting.saveDefaultLayout").show();
        if (choice != DialogManager.YES_OPTION) {
            return;
        }
        ArrayList<String> openedViews = new ArrayList<String>();
        for (AncestrisViewInterface gjvTc : AncestrisPlugin.lookupAll(AncestrisViewInterface.class)) {
            if (!((AncestrisTopComponent)gjvTc).isOpened() || !gedcom.equals(gjvTc.getGedcom())) continue;
            Mode mode = gjvTc.getMode();
            App.LOG.info("Changing default mode for " + gjvTc.getClass().getName() + ": " + mode.getName());
            gjvTc.setDefaultMode(mode);
            openedViews.add(gjvTc.getClass().getName());
        }
        defaultSettings.put("openViews", openedViews.toArray());
        defaultSettings.put("openViews.date", System.currentTimeMillis() + "");
        DialogManager.create((String)NbBundle.getMessage(ActionSaveLayout.class, (String)"TTL_LayoutSetting"), (String)(NbBundle.getMessage(ActionSaveLayout.class, (String)"DisplaySettingsPanel.saveUserRadioButton.text", (Object)(gedcom.getDisplayName() + " ")) + ": " + NbBundle.getMessage(ActionSaveLayout.class, (String)"DLG_Done"))).setMessageType(1).setOptionType(10).show();
    }

    private void eraseDefaultLayout(boolean quiet) {
        Registry defaultSettings = Registry.get(AncestrisViewInterface.class);
        defaultSettings.remove("openViews");
        String absolutePath = EnvironmentChecker.getProperty((String)"user.home.ancestris", (String)"", (String)"");
        if (!absolutePath.isEmpty()) {
            absolutePath = absolutePath + "/../config/Preferences/ancestris/";
            File dir = new File(absolutePath);
            for (File file : FileUtils.listFiles((File)dir, (String[])new String[]{"properties"}, (boolean)true)) {
                if (!file.getAbsolutePath().contains("ancestris-modules")) continue;
                Registry reg = Registry.get((String)this.getNodeFromFile(file));
                this.removeModeFromRegistry(reg);
            }
        }
        if (quiet) {
            return;
        }
        DialogManager.create((String)NbBundle.getMessage(ActionSaveLayout.class, (String)"TTL_LayoutSetting"), (String)(NbBundle.getMessage(ActionSaveLayout.class, (String)"DisplaySettingsPanel.resetUserRadioButton.text") + ": " + NbBundle.getMessage(ActionSaveLayout.class, (String)"DLG_Done"))).setMessageType(1).setOptionType(10).show();
    }

    private void eraseAllLayout(boolean openGen) {
        File dir;
        String text1 = NbBundle.getMessage(this.getClass(), (String)"DLG_ActionEraseAllLayout1");
        String text2 = NbBundle.getMessage(this.getClass(), (String)"DLG_ActionEraseAllLayout2");
        String text3 = NbBundle.getMessage(this.getClass(), (String)"DLG_ActionEraseAllLayout3");
        String text = openGen ? text1 + text2 + text3 : text1 + text3;
        Object choice = DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"DisplaySettingsPanel.allLayoutLabel.text"), (String)text).setMessageType(3).setOptionType(0).setDialogId("windowSetting.eraseAllLayout").show();
        if (choice != DialogManager.YES_OPTION) {
            return;
        }
        for (Context ctx : GedcomDirectory.getDefault().getContexts()) {
            GedcomDirectory.getDefault().closeGedcom(ctx);
        }
        String absolutePath = EnvironmentChecker.getProperty((String)"user.home.ancestris", (String)"", (String)"");
        if (!absolutePath.isEmpty() && (dir = new File(absolutePath = absolutePath + "/../config/Preferences/gedcoms/settings/")).exists()) {
            for (File file : FileUtils.listFiles((File)dir, (String[])new String[]{"properties"}, (boolean)true)) {
                Registry reg = Registry.get((String)this.getNodeFromFile(file));
                this.removeModeFromRegistry(reg);
                reg.remove("openViews");
                reg.remove("focusViews");
            }
        }
        this.eraseDefaultLayout(true);
        absolutePath = EnvironmentChecker.getProperty((String)"user.home.ancestris", (String)"", (String)"");
        if (!absolutePath.isEmpty()) {
            absolutePath = absolutePath + "/../config/Windows2Local/";
            dir = new File(absolutePath);
            try {
                FileUtils.deleteDirectory((File)dir);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        DialogManager.create((String)NbBundle.getMessage(ActionSaveLayout.class, (String)"TTL_LayoutSetting"), (String)(NbBundle.getMessage(ActionSaveLayout.class, (String)"DisplaySettingsPanel.resetAllLayoutRadioButton.text") + ": " + NbBundle.getMessage(ActionSaveLayout.class, (String)"DLG_Done"))).setMessageType(1).setOptionType(10).show();
        Lifecycle.askForRestart(null);
    }

    private void removeModeFromRegistry(Registry reg) {
        Set keys = reg.getProperties();
        for (String key : keys) {
            if (!key.endsWith(".dockMode")) continue;
            reg.remove(key);
        }
    }

    private boolean existDock(Registry reg) {
        boolean found = false;
        Set keys = reg.getProperties();
        for (String key : keys) {
            if (!key.endsWith(".dockMode")) continue;
            found = true;
            break;
        }
        return found;
    }

    private String getNodeFromFile(File file) {
        String filename = file.getAbsolutePath();
        int i = filename.indexOf("Preferences");
        int j = filename.indexOf(".properties");
        String ret = filename.substring(i + 12, j);
        ret = ret.replaceAll("\\\\", "/");
        return ret;
    }
}

