/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.gedcom.GedcomDirectory;
import ancestris.util.Utilities;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import java.text.Normalizer;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;

public class FamQuickSearch
implements SearchProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(SearchRequest request, SearchResponse response) {
        String req = request.getText().replace("(", "\\(").replace(")", "\\)");
        FamQuickSearch famQuickSearch = this;
        synchronized (famQuickSearch) {
            for (Context context : GedcomDirectory.getDefault().getContexts()) {
                for (Fam fam : context.getGedcom().getFamilies()) {
                    String str1 = Normalizer.normalize(this.getStringFromFam(fam), Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
                    String str2 = Normalizer.normalize(req, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
                    if (!Utilities.wordsMatch((String)str1.toLowerCase(), (String)str2.toLowerCase()) || response.addResult(this.createAction((Entity)fam), fam.toString(true))) continue;
                    return;
                }
            }
        }
    }

    private Runnable createAction(final Entity entity) {
        return new Runnable(){

            @Override
            public void run() {
                SelectionDispatcher.fireSelection((Context)new Context(entity));
            }
        };
    }

    private String getStringFromFam(Fam fam) {
        Indi wife;
        String ret = "";
        Indi husb = fam.getHusband();
        if (husb != null) {
            String[] names;
            for (String name : names = husb.getLastNames()) {
                ret = ret + name + " ";
            }
            String[] firstnames = husb.getFirstNames();
            for (String firstname : firstnames) {
                ret = ret + firstname + " ";
            }
        }
        if ((wife = fam.getWife()) != null) {
            String[] firstnames;
            String[] names;
            for (String name : names = wife.getLastNames()) {
                ret = ret + name + " ";
            }
            for (String firstname : firstnames = wife.getFirstNames()) {
                ret = ret + firstname + " ";
            }
        }
        ret = ret + fam.toString(true);
        return ret.toLowerCase();
    }
}

