/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app.actions;

import ancestris.app.App;
import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.util.EventUsage;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.TagPath;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.NbBundle;

public class SortEntityAction
extends AbstractAncestrisContextAction {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private final Map<String, EventUsage> eventOrder = new HashMap<String, EventUsage>();

    public SortEntityAction() {
        this.setImage("/ancestris/view/images/Sort.png");
        this.setText(NbBundle.getMessage(App.class, (String)"action.sort"));
        this.setTip(NbBundle.getMessage(App.class, (String)"action.sort.tip"));
        EventUsage.init(this.eventOrder);
    }

    public void actionPerformedImpl(ActionEvent ae) {
        LOG.log(Level.FINEST, "Entering action Sort properties");
        if (this.context == null) {
            LOG.log(Level.FINEST, "Exiting action Sort properties, no context");
            return;
        }
        Entity e = this.getContext().getEntity();
        if (e instanceof Indi) {
            this.sortPropertyIndi((Indi)e);
        } else {
            this.sortPropertyFam((Fam)e);
        }
        LOG.log(Level.FINEST, "Exiting action Sort properties");
    }

    private void sortPropertyIndi(Indi indi) {
        try {
            this.getGedcom().doUnitOfWork(gedcom -> indi.moveProperties(this.doSortPropertyIndi(indi), 0));
        }
        catch (GedcomException e) {
            DialogManager.createError(null, (String)e.getMessage()).show();
        }
    }

    protected List<Property> doSortPropertyIndi(Indi indi) {
        ArrayList<SortingProperty> sps = new ArrayList<SortingProperty>();
        ArrayList<Property> sortableProperties = new ArrayList<Property>();
        Collections.addAll(sortableProperties, indi.getProperties("BIRT"));
        Collections.addAll(sortableProperties, indi.getProperties("CHR"));
        Collections.addAll(sortableProperties, indi.getProperties("BAPM"));
        Collections.addAll(sortableProperties, indi.getProperties("CAST"));
        Collections.addAll(sortableProperties, indi.getProperties("DSCR"));
        Collections.addAll(sortableProperties, indi.getProperties("EDUC"));
        Collections.addAll(sortableProperties, indi.getProperties("IDNO"));
        Collections.addAll(sortableProperties, indi.getProperties("NATI"));
        Collections.addAll(sortableProperties, indi.getProperties("NATI"));
        Collections.addAll(sortableProperties, indi.getProperties("NCHI"));
        Collections.addAll(sortableProperties, indi.getProperties("NMR"));
        Collections.addAll(sortableProperties, indi.getProperties("OCCU"));
        Collections.addAll(sortableProperties, indi.getProperties("PROP"));
        Collections.addAll(sortableProperties, indi.getProperties("RELI"));
        Collections.addAll(sortableProperties, indi.getProperties("RESI"));
        Collections.addAll(sortableProperties, indi.getProperties("SSN"));
        Collections.addAll(sortableProperties, indi.getProperties("TITL"));
        Collections.addAll(sortableProperties, indi.getProperties("FACT"));
        Collections.addAll(sortableProperties, indi.getProperties("BARM"));
        Collections.addAll(sortableProperties, indi.getProperties("BASM"));
        Collections.addAll(sortableProperties, indi.getProperties("BLES"));
        Collections.addAll(sortableProperties, indi.getProperties("CENS"));
        Collections.addAll(sortableProperties, indi.getProperties("CHRA"));
        Collections.addAll(sortableProperties, indi.getProperties("CONF"));
        Collections.addAll(sortableProperties, indi.getProperties("EMIG"));
        Collections.addAll(sortableProperties, indi.getProperties("FCOM"));
        Collections.addAll(sortableProperties, indi.getProperties("GRAD"));
        Collections.addAll(sortableProperties, indi.getProperties("IMMI"));
        Collections.addAll(sortableProperties, indi.getProperties("NATU"));
        Collections.addAll(sortableProperties, indi.getProperties("ORDN"));
        Collections.addAll(sortableProperties, indi.getProperties("PROB"));
        Collections.addAll(sortableProperties, indi.getProperties("RETI"));
        Collections.addAll(sortableProperties, indi.getProperties("ADOP"));
        Collections.addAll(sortableProperties, indi.getProperties("EVEN"));
        Collections.addAll(sortableProperties, indi.getProperties("BAPL"));
        Collections.addAll(sortableProperties, indi.getProperties("CONL"));
        Collections.addAll(sortableProperties, indi.getProperties("ENDL"));
        Collections.addAll(sortableProperties, indi.getProperties("INIL"));
        Collections.addAll(sortableProperties, indi.getProperties("SLGC"));
        Collections.addAll(sortableProperties, indi.getProperties("FAMS"));
        Collections.addAll(sortableProperties, indi.getProperties("WILL"));
        Collections.addAll(sortableProperties, indi.getProperties("DEAT"));
        Collections.addAll(sortableProperties, indi.getProperties("CREM"));
        Collections.addAll(sortableProperties, indi.getProperties("BURI"));
        for (Property p : sortableProperties) {
            List dates = p.getProperties(PropertyDate.class);
            if (!dates.isEmpty()) {
                Collections.sort(dates);
                sps.add(new SortingProperty((PropertyDate)dates.get(0), p));
                continue;
            }
            if (p instanceof PropertyFamilySpouse) {
                PropertyFamilySpouse pc = (PropertyFamilySpouse)p;
                PropertyDate pd = pc.getFamily().getMarriageDate();
                if (pd == null) continue;
                sps.add(new SortingProperty(pd, p));
                continue;
            }
            sps.add(new SortingProperty(new PropertyDate(), p));
        }
        Collections.sort(sps);
        sortableProperties.clear();
        Collections.addAll(sortableProperties, indi.getProperties("NAME"));
        Collections.addAll(sortableProperties, indi.getProperties("SEX"));
        Collections.addAll(sortableProperties, indi.getProperties("_SOSA"));
        Collections.addAll(sortableProperties, indi.getProperties("_SOSADABOVILLE"));
        Collections.addAll(sortableProperties, indi.getProperties("_DABOVILLE"));
        Collections.addAll(sortableProperties, indi.getProperties("FAMC"));
        for (SortingProperty sp : sps) {
            sortableProperties.add(sp.getContexte());
        }
        return sortableProperties;
    }

    private void sortPropertyFam(Fam fam) {
        try {
            this.getGedcom().doUnitOfWork(gedcom -> fam.moveProperties(this.doSortPropertyFam(fam), 0));
        }
        catch (GedcomException e) {
            DialogManager.createError(null, (String)e.getMessage()).show();
        }
    }

    protected List<Property> doSortPropertyFam(Fam fam) {
        ArrayList<SortingProperty> sps = new ArrayList<SortingProperty>();
        ArrayList<Property> sortableProperties = new ArrayList<Property>();
        Collections.addAll(sortableProperties, fam.getProperties("NCHI"));
        Collections.addAll(sortableProperties, fam.getProperties("RESI"));
        Collections.addAll(sortableProperties, fam.getProperties("ENGA"));
        Collections.addAll(sortableProperties, fam.getProperties("MARB"));
        Collections.addAll(sortableProperties, fam.getProperties("MARC"));
        Collections.addAll(sortableProperties, fam.getProperties("MARL"));
        Collections.addAll(sortableProperties, fam.getProperties("MARR"));
        Collections.addAll(sortableProperties, fam.getProperties("ANUL"));
        Collections.addAll(sortableProperties, fam.getProperties("MARS"));
        Collections.addAll(sortableProperties, fam.getProperties("CHIL"));
        Collections.addAll(sortableProperties, fam.getProperties("DIVF"));
        Collections.addAll(sortableProperties, fam.getProperties("DIV"));
        Collections.addAll(sortableProperties, fam.getProperties("CENS"));
        Collections.addAll(sortableProperties, fam.getProperties("EVEN"));
        Collections.addAll(sortableProperties, fam.getProperties("SLGS"));
        for (Property p : sortableProperties) {
            List dates = p.getProperties(PropertyDate.class);
            if (!dates.isEmpty()) {
                Collections.sort(dates);
                sps.add(new SortingProperty((PropertyDate)dates.get(0), p));
                continue;
            }
            if (p instanceof PropertyChild) {
                PropertyChild pc = (PropertyChild)p;
                PropertyDate pd = pc.getChild().getBirthDate();
                if (pd != null) {
                    sps.add(new SortingProperty(pd, p));
                    continue;
                }
                pd = (PropertyDate)pc.getChild().getProperty(new TagPath("INDI:CHR:DATE"));
                if (pd == null) continue;
                sps.add(new SortingProperty(pd, p));
                continue;
            }
            sps.add(new SortingProperty(new PropertyDate(), p));
        }
        Collections.sort(sps);
        sortableProperties.clear();
        Collections.addAll(sortableProperties, fam.getProperties("HUSB"));
        Collections.addAll(sortableProperties, fam.getProperties("WIFE"));
        for (SortingProperty sp : sps) {
            sortableProperties.add(sp.getContexte());
        }
        return sortableProperties;
    }

    private class SortingProperty
    implements Comparable<SortingProperty> {
        private final PropertyDate date;
        private final Property contexte;

        SortingProperty(PropertyDate theDate, Property theProp) {
            this.date = theDate;
            this.contexte = theProp;
        }

        @Override
        public int compareTo(SortingProperty o) {
            if (this.date.isComparable() && o.getDate().isComparable()) {
                return this.date.compareTo((Property)o.getDate());
            }
            EventUsage theOne = (EventUsage)SortEntityAction.this.eventOrder.get(this.contexte.getTag());
            EventUsage theOther = (EventUsage)SortEntityAction.this.eventOrder.get(o.getContexte().getTag());
            if (theOne == null) {
                return -1;
            }
            if (theOther == null) {
                return 1;
            }
            return theOne.getOrder() - theOther.getOrder();
        }

        public PropertyDate getDate() {
            return this.date;
        }

        public Property getContexte() {
            return this.contexte;
        }
    }
}

