/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.familygroups;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.gedcom.ActionSaveViewAsGedcom;
import ancestris.modules.document.view.FopDocumentView;
import ancestris.modules.familygroups.FamilyGroupsPlugin;
import ancestris.modules.familygroups.FamilyGroupsRunner;
import ancestris.util.ProgressListener;
import genj.fo.Document;
import genj.gedcom.Context;
import genj.util.Trackable;
import genj.view.Images;
import java.awt.event.ActionEvent;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import spin.Spin;

public final class OpenFamilyGroupsAction
extends AbstractAncestrisContextAction {
    private Preferences modulePreferences = NbPreferences.forModule(FamilyGroupsPlugin.class);

    public OpenFamilyGroupsAction() {
        this.setImage("ancestris/modules/familygroups/FamilyGroups.png");
        this.setText(NbBundle.getMessage(OpenFamilyGroupsAction.class, (String)"CTL_FamilyGroupsAction"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        Context contextToOpen = this.getContext();
        if (contextToOpen != null) {
            if (this.modulePreferences.getInt("minGroupSize", -1) == -1) {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(FamilyGroupsPlugin.class, (String)"OpenFamilyGroupsAction.setParameters"), 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                OptionsDisplayer.getDefault().open("Extensions/FamilyGroups", true);
            }
            this.run();
        }
    }

    private void run() {
        Context contextToOpen = this.getContext();
        FamilyGroupsRunner fgrunner = (FamilyGroupsRunner)Spin.off((Object)new FamilyGroupsPlugin(contextToOpen.getGedcom()));
        ProgressListener.Dispatcher.processStarted((Trackable)fgrunner);
        fgrunner.run();
        ProgressListener.Dispatcher.processStopped((Trackable)fgrunner);
        final FamilyGroupsPlugin fgp = fgrunner.getFgp();
        Document doc = fgp.getDocument();
        if (doc != null) {
            String gen = contextToOpen.getGedcom().getDisplayName();
            ActionSaveViewAsGedcom extractAction = fgp.getExtractAction(contextToOpen.getGedcom());
            ActionSaveViewAsGedcom extractGroupsAction = fgp.getExtractGroupsAction(contextToOpen.getGedcom());
            FopDocumentView window = new FopDocumentView(contextToOpen, NbBundle.getMessage(FamilyGroupsPlugin.class, (String)"title", (Object)gen), NbBundle.getMessage(FamilyGroupsPlugin.class, (String)"title.tip", (Object)gen), new AbstractAncestrisAction[]{this.runAction(), fgp.selectSubgroupsAction(contextToOpen.getGedcom(), extractAction, extractGroupsAction), extractAction, fgp.getMarkAction(contextToOpen.getGedcom()), this.optionAction()});
            window.executeOnClose(new Runnable(){

                @Override
                public void run() {
                    fgp.stop();
                }
            });
            window.displayDocument(doc, this.modulePreferences);
        }
    }

    private AbstractAncestrisAction runAction() {
        AbstractAncestrisAction option = new AbstractAncestrisAction(){

            public void actionPerformed(ActionEvent e) {
                OpenFamilyGroupsAction.this.run();
            }
        };
        option.setImage("ancestris/modules/familygroups/Start.png");
        option.setTip(NbBundle.getMessage(FamilyGroupsPlugin.class, (String)"OpenFamilyGroupsAction.rerun"));
        return option;
    }

    private AbstractAncestrisAction optionAction() {
        AbstractAncestrisAction option = new AbstractAncestrisAction(){

            public void actionPerformed(ActionEvent e) {
                OptionsDisplayer.getDefault().open("Extensions/FamilyGroups", true);
            }
        };
        option.setImage((Icon)Images.imgSettings);
        option.setTip(NbBundle.getMessage(FamilyGroupsPlugin.class, (String)"OpenFamilyGroupsAction.parameters"));
        return option;
    }
}

