/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare.options;

import ancestris.core.CoreOptions;
import ancestris.modules.gedcomcompare.communication.UserProfile;
import ancestris.modules.gedcomcompare.options.GedcomCompareOptionsPanelController;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import genj.util.EnvironmentChecker;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

public final class GedcomCompareOptionsPanel
extends JPanel
implements PropertyChangeListener {
    private static final int IMG_ICON_WIDTH = 14;
    private static final int IMG_ICON_HEIGHT = 16;
    private static final int IMG_SMALL_WIDTH = 16;
    private static final int IMG_SMALL_HEIGHT = 19;
    private static final int IMG_MEDIUM_WIDTH = 51;
    private static final int IMG_MEDIUM_HEIGHT = 62;
    public static final int IMG_LARGE_WIDTH = 155;
    public static final int IMG_LARGE_HEIGHT = 186;
    private static final int PSEUDO_MAXLENGTH = 15;
    private final ImageIcon DEFPROF_PHOTO = new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/nophotobig.png"));
    private static String photoPath = "";
    private static File dest = null;
    private static BufferedImage targetImage = null;
    private static boolean loading = false;
    private boolean changeInProgress = false;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField4;
    private JTextField jTextField5;
    private JTextField jTextField6;
    private JCheckBox showOutputCheckBox;

    GedcomCompareOptionsPanel(GedcomCompareOptionsPanelController controller) {
        this.initComponents();
        DocumentChangeListener listener = new DocumentChangeListener();
        this.jTextField2.getDocument().putProperty("owner", "username");
        this.jTextField2.getDocument().addDocumentListener(listener);
        this.jTextField4.getDocument().putProperty("owner", "useremail");
        this.jTextField4.getDocument().addDocumentListener(listener);
        CoreOptions.getInstance().addPropertyChangeListener((PropertyChangeListener)this);
        loading = false;
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jTextField5 = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jTextField6 = new JTextField();
        this.jTextField1 = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextField4 = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jPanel3 = new JPanel();
        this.showOutputCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"GedcomCompareOptionsPanel.jLabel5.text"));
        this.jTextField5.setText(NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"GedcomCompareOptionsPanel.jTextField5.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"GedcomCompareOptionsPanel.jLabel6.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"GedcomCompareOptionsPanel.jLabel1.text"));
        this.jTextField6.setText(NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"GedcomCompareOptionsPanel.jTextField6.text"));
        this.jTextField1.setText(NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"GedcomCompareOptionsPanel.jTextField1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"GedcomCompareOptionsPanel.jLabel7.text"));
        this.jTextField4.setText(NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"GedcomCompareOptionsPanel.jTextField4.text"));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel8.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"GedcomCompareOptionsPanel.jLabel8.text"));
        this.jLabel8.setToolTipText(NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"GedcomCompareOptionsPanel.jLabel8.toolTipText"));
        this.jLabel8.setBorder(null);
        this.jLabel8.setIconTextGap(0);
        this.jLabel8.setPreferredSize(new Dimension(155, 186));
        this.jLabel8.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GedcomCompareOptionsPanel.this.jLabel8MouseClicked(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.jLabel8.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"GedcomCompareOptionsPanel.jLabel8.AccessibleContext.accessibleName"));
        this.jLabel8.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"GedcomCompareOptionsPanel.jLabel8.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"GedcomCompareOptionsPanel.jLabel2.text"));
        this.jTextField2.setText(NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"GedcomCompareOptionsPanel.jTextField2.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel7).addComponent(this.jLabel5).addComponent(this.jLabel6)).addGap(32, 32, 32).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextField5).addComponent(this.jTextField2, GroupLayout.Alignment.LEADING, -1, 219, Short.MAX_VALUE).addComponent(this.jTextField1, GroupLayout.Alignment.LEADING, -1, 219, Short.MAX_VALUE).addComponent(this.jTextField4).addComponent(this.jTextField6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, -1, -2)).addGap(4, 4, 4).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jTextField4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextField5, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jTextField6, -2, -1, -2))).addComponent(this.jPanel1, -2, -1, -2)).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"GedcomCompareOptionsPanel.jPanel2.TabConstraints.tabTitle"), this.jPanel2);
        Mnemonics.setLocalizedText((AbstractButton)this.showOutputCheckBox, (String)NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"GedcomCompareOptionsPanel.showOutputCheckBox.text"));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.showOutputCheckBox).addContainerGap(273, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.showOutputCheckBox).addContainerGap(159, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"GedcomCompareOptionsPanel.jPanel3.TabConstraints.tabTitle"), this.jPanel3);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1).addGap(17, 17, 17)));
    }

    private void jLabel8MouseClicked(MouseEvent evt) {
        loading = true;
        this.chooseAndDisplayImage();
        loading = false;
    }

    void load() {
        this.jTextField1.setText(NbPreferences.forModule(GedcomCompareOptionsPanel.class).get("Pseudo", GedcomCompareOptionsPanel.getPseudo()).trim());
        this.jTextField2.setText(CoreOptions.getInstance().getUserName(""));
        this.jTextField4.setText(CoreOptions.getInstance().getUserEmail(""));
        this.jTextField5.setText(NbPreferences.forModule(GedcomCompareOptionsPanel.class).get("City", "").trim());
        this.jTextField6.setText(NbPreferences.forModule(GedcomCompareOptionsPanel.class).get("Country", "").trim());
        photoPath = NbPreferences.forModule(GedcomCompareOptionsPanel.class).get("Photo", "");
        this.jLabel8.setText("");
        this.jLabel8.setToolTipText(NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"GedcomCompareOptionsPanel.jLabel8.toolTipText"));
        if (GedcomCompareOptionsPanel.loadSavePhoto(new File(photoPath))) {
            this.jLabel8.setIcon(new ImageIcon(targetImage));
        } else {
            this.jLabel8.setIcon(this.DEFPROF_PHOTO);
        }
        this.showOutputCheckBox.setSelected(NbPreferences.forModule(GedcomCompareOptionsPanel.class).getBoolean("ShowOutput", false));
    }

    void store() {
        String str = this.jTextField1.getText();
        int i = str.indexOf(" ");
        NbPreferences.forModule(GedcomCompareOptionsPanel.class).put("Pseudo", i == -1 ? str : str.substring(0, i));
        CoreOptions.getInstance().setUserName(this.jTextField2.getText().trim());
        CoreOptions.getInstance().setUserEmail(this.jTextField4.getText().trim());
        NbPreferences.forModule(GedcomCompareOptionsPanel.class).put("City", this.jTextField5.getText().trim());
        NbPreferences.forModule(GedcomCompareOptionsPanel.class).put("Country", this.jTextField6.getText().trim());
        if (targetImage != null && dest != null) {
            photoPath = dest.getAbsolutePath();
            GedcomCompareOptionsPanel.saveImage(dest);
            NbPreferences.forModule(GedcomCompareOptionsPanel.class).put("Photo", photoPath);
        }
        NbPreferences.forModule(GedcomCompareOptionsPanel.class).putBoolean("ShowOutput", this.showOutputCheckBox.isSelected());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.changeInProgress) {
            if (evt.getPropertyName().equals("username")) {
                this.jTextField2.setText((String)evt.getNewValue());
            } else if (evt.getPropertyName().equals("useremail")) {
                this.jTextField4.setText((String)evt.getNewValue());
            }
        }
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                GedcomCompareOptionsPanel.this.changeInProgress = false;
            }
        });
    }

    boolean valid() {
        return true;
    }

    private void chooseAndDisplayImage() {
        File file = new FileChooserBuilder(GedcomCompareOptionsPanel.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"FileChooserTitle")).setApproveText(NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"FileChooserButton")).setDefaultExtension(FileChooserBuilder.getImageFilter().getExtensions()[0]).setFileFilter((FileFilter)FileChooserBuilder.getImageFilter()).setAcceptAllFileFilterUsed(false).setFileHiding(true).setDefaultPreviewer().showOpenDialog();
        if (file != null) {
            if (GedcomCompareOptionsPanel.processImage(file)) {
                this.jLabel8.setIcon(new ImageIcon(targetImage));
            } else {
                this.jLabel8.setIcon(this.DEFPROF_PHOTO);
            }
        }
    }

    private static boolean loadSavePhoto(File f) {
        if (GedcomCompareOptionsPanel.processImage(f)) {
            GedcomCompareOptionsPanel.saveImage(f);
            return true;
        }
        return false;
    }

    private static boolean processImage(File f) {
        try {
            if (f == null) {
                throw new Exception("FileIsNull");
            }
            targetImage = GedcomCompareOptionsPanel.scaleImage(f, 155, 186);
            File dir = new File(new File(System.getProperty("user.home.ancestris")).getParent() + File.separator + "config" + File.separator + "Preferences" + NbPreferences.forModule(GedcomCompareOptionsPanel.class).absolutePath());
            dir.mkdirs();
            dest = new File(dir, GedcomCompareOptionsPanel.removeExtension(f.getName()) + ".jpg");
            return true;
        }
        catch (Exception ex) {
            if (loading) {
                DialogManager.create((String)NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)("TITL_" + ex.getMessage())), (String)NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"TITL_PleaseChooseOther")).setMessageType(0).show();
            }
            return false;
        }
    }

    private static void saveImage(File f) {
        try {
            ImageIO.write((RenderedImage)targetImage, "jpeg", f);
        }
        catch (Exception ex) {
            DialogManager.create((String)NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"TITL_CannotSaveCopy"), (String)NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"TITL_PleaseCheckPath", (Object)photoPath)).setMessageType(0).show();
        }
    }

    private static BufferedImage scaleImage(File f, int IMG_LARGE_WIDTH, int IMG_LARGE_HEIGHT) throws Exception {
        BufferedImage ret = null;
        BufferedImage image = null;
        try {
            image = ImageIO.read(f);
        }
        catch (Exception ex) {
            throw new Exception("FileIsNotAnImage");
        }
        if (image == null) {
            throw new Exception("FileIsNotAnImage");
        }
        int imageWidth = ((Image)image).getWidth(null);
        int imageHeight = ((Image)image).getHeight(null);
        if (imageWidth <= 0 || imageHeight <= 0) {
            image.flush();
            throw new Exception("FileIsNotAnImage");
        }
        int targetWidth = IMG_LARGE_WIDTH;
        int targetHeight = IMG_LARGE_HEIGHT;
        double targetRatio = (double)targetWidth / (double)targetHeight;
        double imageRatio = (double)imageWidth / (double)imageHeight;
        if (targetRatio < imageRatio) {
            targetHeight = (int)((double)targetWidth / imageRatio);
        } else {
            targetWidth = (int)((double)targetHeight * imageRatio);
        }
        try {
            ret = GedcomCompareOptionsPanel.resizeImage(image, targetWidth, targetHeight);
        }
        catch (Exception e) {
            throw new Exception("FileCannotBeResized");
        }
        return ret;
    }

    private static BufferedImage resizeImage(Image img, int width, int height) {
        BufferedImage dimg = new BufferedImage(width, height, 1);
        Graphics2D g = dimg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(img, 0, 0, width, height, null);
        g.dispose();
        return dimg;
    }

    public static byte[] getPhotoBytes(File f) {
        try {
            BufferedImage img = ImageIO.read(f);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "jpg", baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static ImageIcon getPhoto(int size, byte[] photoBytes) {
        Image image = null;
        if (photoBytes == null) {
            return null;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(photoBytes));
            image = size == 0 ? bufferedImage.getScaledInstance(14, 16, 1) : (size == 1 ? bufferedImage.getScaledInstance(16, 19, 1) : (size == 2 ? bufferedImage.getScaledInstance(51, 62, 1) : (size == 3 ? bufferedImage.getScaledInstance(155, 186, 1) : bufferedImage.getScaledInstance(51, 62, 1))));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return new ImageIcon(image);
    }

    public static String getPseudo() {
        String p = NbPreferences.forModule(GedcomCompareOptionsPanel.class).get("Pseudo", GedcomCompareOptionsPanel.getDefaultPseudo()).trim();
        NbPreferences.forModule(GedcomCompareOptionsPanel.class).put("Pseudo", p);
        return p;
    }

    public static String getDefaultPseudo() {
        String rawName = EnvironmentChecker.getProperty((String)"user.home.ancestris", (String)"", (String)"").trim();
        int i = rawName.indexOf(File.separator);
        rawName = rawName.substring(i + 1);
        i = rawName.indexOf(File.separator);
        if ((i = (rawName = rawName.substring(i + 1)).indexOf(File.separator)) == -1) {
            i = rawName.length();
        }
        if ((rawName = rawName.substring(0, Math.min(15, i)).trim()).isEmpty()) {
            char[] buf = new char[12];
            char[] symbols = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
            Random random = new Random();
            for (int idx = 0; idx < buf.length; ++idx) {
                buf[idx] = symbols[random.nextInt(symbols.length)];
            }
            rawName = "ZZZ" + new String(buf);
        }
        return rawName;
    }

    public static UserProfile getProfile() {
        UserProfile profile = new UserProfile();
        profile.name = CoreOptions.getInstance().getUserName("");
        profile.email = CoreOptions.getInstance().getUserEmail("");
        profile.city = NbPreferences.forModule(GedcomCompareOptionsPanel.class).get("City", "").trim();
        profile.country = NbPreferences.forModule(GedcomCompareOptionsPanel.class).get("Country", "").trim();
        File f = new File(NbPreferences.forModule(GedcomCompareOptionsPanel.class).get("Photo", ""));
        if (GedcomCompareOptionsPanel.loadSavePhoto(f)) {
            profile.photoBytes = GedcomCompareOptionsPanel.getPhotoBytes(f);
        }
        return profile;
    }

    public static String getProfileError() {
        UserProfile myProfile = GedcomCompareOptionsPanel.getProfile();
        if (myProfile.name.isEmpty()) {
            return NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"ERR_NullName");
        }
        if (!GedcomCompareOptionsPanel.isValidEmailAddress(myProfile.email)) {
            return NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"ERR_NullEmail");
        }
        if (myProfile.city.isEmpty() || myProfile.country.isEmpty()) {
            return NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"ERR_NullPlace");
        }
        if (myProfile.photoBytes == null || myProfile.photoBytes.length == 0) {
            return NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"ERR_NullPhoto");
        }
        return "";
    }

    public static boolean isValidEmailAddress(String email) {
        String ePattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
        Pattern p = Pattern.compile(ePattern);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    private static String removeExtension(String name) {
        String ret = name;
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex >= 0) {
            ret = name.substring(0, dotIndex);
        }
        return ret;
    }

    private class DocumentChangeListener
    implements DocumentListener {
        private DocumentChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateOption(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateOption(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateOption(e);
        }

        private void updateOption(DocumentEvent e) {
            String property = (String)e.getDocument().getProperty("owner");
            String oldValue = "";
            String newValue = "";
            try {
                newValue = e.getDocument().getText(0, e.getDocument().getLength());
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            GedcomCompareOptionsPanel.this.changeInProgress = true;
            CoreOptions.getInstance().fireOptionChange(property, (Object)oldValue, (Object)newValue);
        }
    }
}

