/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare.tools;

import ancestris.modules.gedcomcompare.GedcomCompareTopComponent;
import ancestris.modules.gedcomcompare.tools.CompareListPanel;
import ancestris.modules.gedcomcompare.tools.CompareMapPanel;
import ancestris.modules.gedcomcompare.tools.ComparedGedcom;
import ancestris.modules.gedcomcompare.tools.DataFrame;
import ancestris.modules.gedcomcompare.tools.LocalGedcomFrame;
import ancestris.modules.gedcomcompare.tools.STFactory;
import ancestris.modules.gedcomcompare.tools.STMap;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ComparisonFrame
extends DataFrame {
    private Set<ComparedGedcom> gedcomPair = null;
    private STMap stMap1 = null;
    private STMap stMap2 = null;
    private STMap stIntersection = null;
    private CompareMapPanel mapPanel = null;
    private CompareListPanel listPanel = null;
    private JLabel eventLabel;
    private JButton geoButton;
    private JLabel lastCityLabel;
    private JButton listButton;
    private JLabel overlapLabel;
    private JProgressBar progressBar;

    public ComparisonFrame(GedcomCompareTopComponent tstc, ComparedGedcom gedcomFrame1, ComparedGedcom gedcomFrame2) {
        super(NbBundle.getMessage(ComparisonFrame.class, (String)"TITL_Comparison"));
        JButton menuButton;
        MouseListener[] mls;
        this.owner = tstc;
        this.gedcomPair = new HashSet<ComparedGedcom>();
        this.gedcomPair.add(gedcomFrame1);
        this.gedcomPair.add(gedcomFrame2);
        this.initComponents();
        this.setComponentPopupMenu(null);
        JComponent pane = ((BasicInternalFrameUI)this.getUI()).getNorthPane();
        if (pane.getComponent(0) instanceof JButton && (mls = (menuButton = (JButton)pane.getComponent(0)).getMouseListeners()).length > 1 && mls[1] instanceof MouseAdapter) {
            menuButton.removeMouseListener(mls[1]);
        }
        this.reset();
    }

    public void reset() {
        this.stMap1 = null;
        this.stMap2 = null;
        this.stIntersection = null;
        this.lastCityLabel.setText(NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.lastCityLabel.text", (Object)"-"));
        this.eventLabel.setText(NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.eventLabel.text", (Object)"-"));
        this.progressBar.setValue(0);
    }

    private void initComponents() {
        this.overlapLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.lastCityLabel = new JLabel();
        this.eventLabel = new JLabel();
        this.geoButton = new JButton();
        this.listButton = new JButton();
        this.setBorder(new SoftBevelBorder(0));
        this.setToolTipText(NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.toolTipText"));
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/comparegedcom.png")));
        this.setVisible(true);
        this.overlapLabel.setFont(this.overlapLabel.getFont().deriveFont((float)this.overlapLabel.getFont().getSize() - 1.0f));
        Mnemonics.setLocalizedText((JLabel)this.overlapLabel, (String)NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.overlapLabel.text"));
        this.progressBar.setFont(this.progressBar.getFont().deriveFont(this.progressBar.getFont().getStyle() | 1, this.progressBar.getFont().getSize() - 2));
        this.progressBar.setToolTipText(NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.progressBar.toolTipText"));
        this.progressBar.setStringPainted(true);
        this.lastCityLabel.setFont(this.lastCityLabel.getFont().deriveFont((float)this.lastCityLabel.getFont().getSize() - 1.0f));
        this.lastCityLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/indi.png")));
        Mnemonics.setLocalizedText((JLabel)this.lastCityLabel, (String)NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.lastCityLabel.text"));
        this.lastCityLabel.setToolTipText(NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.lastCityLabel.toolTipText"));
        this.eventLabel.setFont(this.eventLabel.getFont().deriveFont((float)this.eventLabel.getFont().getSize() - 1.0f));
        this.eventLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/even.png")));
        Mnemonics.setLocalizedText((JLabel)this.eventLabel, (String)NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.eventLabel.text"));
        this.eventLabel.setToolTipText(NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.eventLabel.toolTipText"));
        this.geoButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/geo.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.geoButton, (String)NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.geoButton.text"));
        this.geoButton.setToolTipText(NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.geoButton.toolTipText"));
        this.geoButton.setPreferredSize(new Dimension(34, 28));
        this.geoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComparisonFrame.this.geoButtonActionPerformed(evt);
            }
        });
        this.listButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/list.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.listButton, (String)NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.listButton.text"));
        this.listButton.setToolTipText(NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.listButton.toolTipText"));
        this.listButton.setPreferredSize(new Dimension(34, 28));
        this.listButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComparisonFrame.this.listButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.overlapLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -1, 92, Short.MAX_VALUE)).addComponent(this.lastCityLabel).addComponent(this.eventLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.geoButton, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.listButton, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.overlapLabel).addComponent(this.progressBar, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lastCityLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.eventLabel)).addGroup(layout.createSequentialGroup().addComponent(this.geoButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.listButton, -2, 28, -2))).addContainerGap()));
    }

    private void geoButtonActionPerformed(ActionEvent evt) {
        this.showGeoView();
    }

    private void listButtonActionPerformed(ActionEvent evt) {
        this.showListView();
    }

    public boolean contains(ComparedGedcom gedcomFrame1, ComparedGedcom gedcomFrame2) {
        return this.gedcomPair.contains(gedcomFrame1) && this.gedcomPair.contains(gedcomFrame2);
    }

    public boolean includesMain() {
        return this.gedcomPair.stream().anyMatch(item -> item.isMain());
    }

    public boolean matchID(String id) {
        return this.gedcomPair.stream().anyMatch(item -> item.getID().equals(id));
    }

    public boolean contains(ComparedGedcom gedcomFrame) {
        return this.gedcomPair.contains(gedcomFrame);
    }

    public void updateMain(LocalGedcomFrame main) {
        if (this.stMap1 == null || this.stMap2 == null || this.stIntersection == null) {
            return;
        }
        if (main.getMap() != this.stMap1) {
            this.launchCompare(false);
        }
    }

    public boolean launchCompare(boolean quiet) {
        if (this.gedcomPair.size() != 2) {
            this.displayInstructions("TEXT_Instruction1");
            return false;
        }
        ComparedGedcom[] cd = this.gedcomPair.toArray(new ComparedGedcom[2]);
        STMap map1 = cd[0].getMap();
        STMap map2 = cd[1].getMap();
        if (map1 == null || map2 == null) {
            if (!quiet) {
                this.displayInstructions("TEXT_Instruction1");
            }
            return false;
        }
        if (cd[1].isMain()) {
            map1 = cd[1].getMap();
            map2 = cd[0].getMap();
        }
        this.stMap1 = map1;
        this.stMap2 = map2;
        this.stIntersection = STFactory.intersectSTMaps(map1, map2);
        this.progressBar.setValue(this.stIntersection.getOverlap());
        this.lastCityLabel.setText(NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.lastCityLabel.text", (Object)this.stIntersection.getLastCityNb()));
        this.eventLabel.setText(NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.eventLabel.text", (Object)this.stIntersection.getEventNb()));
        this.owner.updateStatsDisplay();
        return true;
    }

    private void displayInstructions(String text) {
        DialogManager.create((String)NbBundle.getMessage(ComparisonFrame.class, (String)"TITL_Instruction"), (String)NbBundle.getMessage(ComparisonFrame.class, (String)text)).setMessageType(1).setDialogId(ComparisonFrame.class).setOptionType(10).show();
    }

    private void showGeoView() {
        boolean ret;
        if (!(this.stMap1 != null && this.stMap2 != null && this.stIntersection != null || (ret = this.launchCompare(false)))) {
            return;
        }
        if (this.stMap2.isRemote() && !this.stMap2.isComplete()) {
            this.displayInstructions("TEXT_Instruction1");
            return;
        }
        if (this.mapPanel == null) {
            this.mapPanel = new CompareMapPanel();
        }
        this.mapPanel.init(this.stMap1, this.stMap2, this.stIntersection);
        DialogManager.create((String)NbBundle.getMessage(ComparisonFrame.class, (String)"TITL_Map"), (JComponent)this.mapPanel).setMessageType(-1).setDialogId(CompareMapPanel.class).setOptionType(10).show();
        this.mapPanel.fixZoom();
    }

    private void showListView() {
        boolean ret;
        if (!(this.stMap1 != null && this.stMap2 != null && this.stIntersection != null || (ret = this.launchCompare(false)))) {
            return;
        }
        if (this.listPanel == null) {
            this.listPanel = new CompareListPanel();
        }
        this.listPanel.init(this.stMap1, this.stMap2, this.stIntersection);
        JButton extractButton = new JButton(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/download.png")));
        extractButton.setEnabled(this.stIntersection != null && this.stIntersection.getLastCityNb() > 0);
        extractButton.setToolTipText(NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.export.toolTipText"));
        Object action = DialogManager.create((String)NbBundle.getMessage(ComparisonFrame.class, (String)"TITL_List"), (JComponent)this.listPanel).setMessageType(-1).setDialogId(CompareListPanel.class).setOptions(new Object[]{extractButton, DialogManager.OK_OPTION}).show();
        if (action == extractButton) {
            this.extractTable();
        }
    }

    private void extractTable() {
        File file = new FileChooserBuilder(ComparisonFrame.class).setTitle(NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.export")).setApproveText(NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.export")).setFileHiding(true).setParent((Component)this).setFileFilter((FileFilter)new FileNameExtensionFilter(NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.export.filter.text"), "txt", "csv")).setDefaultExtension(FileChooserBuilder.getTextFilter().getExtensions()[0]).setDefaultBadgeProvider().setDefaultWorkingDirectory(new File(System.getProperty("user.home"))).showSaveDialog(true);
        if (file == null) {
            return;
        }
        try {
            this.tsvExport(file);
            DialogManager.create((String)NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.export"), (String)NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.export.success", (Object)file.getAbsoluteFile())).show();
        }
        catch (IOException e) {
            DialogManager.createError((String)NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.export"), (String)NbBundle.getMessage(ComparisonFrame.class, (String)"ComparisonFrame.export.error", (Object)file.getAbsoluteFile())).show();
        }
    }

    public void tsvExport(File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        writer.write(this.stMap1.getName() + "\t");
        writer.write(this.stMap2.getName());
        writer.write("\n");
        Object[][] objectArray = this.stIntersection.getData();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] line;
            Object[] cells = line = objectArray[i];
            writer.write((String)cells[1] + "\t");
            writer.write((String)cells[2] + "\t");
            writer.write("\n");
        }
        writer.close();
    }

    public Set<String> getIntersectionKeys() {
        if (this.stIntersection == null) {
            this.launchCompare(true);
        }
        return this.stIntersection != null ? this.stIntersection.keySet() : null;
    }

    public int getOverlap(int maxoverlap) {
        return this.stIntersection == null || this.stIntersection.getOverlap() <= maxoverlap ? maxoverlap : this.stIntersection.getOverlap();
    }

    public int getLastCityNb() {
        return this.stIntersection != null ? this.stIntersection.getLastCityNb() : 0;
    }

    public int getEventNb() {
        return this.stIntersection != null ? this.stIntersection.getEventNb() : 0;
    }

    public List<String> getAreaCityNames() {
        return this.stIntersection.getAreaCityNames();
    }
}

